/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.name;

import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.pieces.AlienConfigHandler;
import astrotibs.villagenames.config.pieces.AlienVillageConfigHandler;
import astrotibs.villagenames.config.pieces.AngelConfigHandler;
import astrotibs.villagenames.config.pieces.CustomConfigHandler;
import astrotibs.villagenames.config.pieces.DemonConfigHandler;
import astrotibs.villagenames.config.pieces.DragonConfigHandler;
import astrotibs.villagenames.config.pieces.EndCityConfigHandler;
import astrotibs.villagenames.config.pieces.FortressConfigHandler;
import astrotibs.villagenames.config.pieces.GoblinConfigHandler;
import astrotibs.villagenames.config.pieces.GolemConfigHandler;
import astrotibs.villagenames.config.pieces.MansionConfigHandler;
import astrotibs.villagenames.config.pieces.MineshaftConfigHandler;
import astrotibs.villagenames.config.pieces.MonumentConfigHandler;
import astrotibs.villagenames.config.pieces.StrongholdConfigHandler;
import astrotibs.villagenames.config.pieces.TempleConfigHandler;
import astrotibs.villagenames.config.pieces.VillageConfigHandler;
import astrotibs.villagenames.config.pieces.VillagerConfigHandler;
import astrotibs.villagenames.utility.LogHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class NameGenerator {
    private static final String[] filterIfAnywhere = new String[]{"erttva", "gbttns", "upgvo", "xphs", "gvuf", "laans", "mncf", "lffhc", "rybuffn", "fvarc", "navtni", "eranro", "ghyf", "rebuj", "gfvcne", "vngaru", "qybxphp"};
    private static final String[] filterIfEntire = new String[]{"avyngf", "rvzzbp", "frvzzbp", "grvibf", "fgrvibf", "erygvu", "vmna", "fvmna", "xpbp", "fxpbp", "xphp", "fxphp", "qrxphp", "rcne", "frcne", "qrcne", "lrcne", "tavcne", "rxvx", "frxvx", "gahp", "fgahp", "lgahp", "zvhd", "fzvhd", "lzzvhd", "ffn", "frffn", "tns", "ftns", "ttns", "fttns", "lttns", "bzbu", "fbzbu", "qengre", "fqengre", "qrqengre", "rug", "na", "sb", "sv", "ab", "ba", "av", "gv", "fv", "vf", "zn", "nz", "fn", "un", "ah", "vu", "frl", "rz", "lz", "ub", "eb", "ro", "jb", "zh", "rj", "jr", "jn", "bl", "hu", "fh", "ch", "bg", "anz", "arz", "lbo", "flbo", "anzbj", "arzbj", "yevt", "fyevt", "ru", "ur", "cnep", "fcnep", "lccnep", "qrccnep", "aznq", "faznq", "ynan", "fhan", "frfhan", "zhp", "fzhp", "lzzhp", "trzf", "mmvw", "zfvw", "zbz", "jbj", "rrc", "ffvc", "lffvc", "qrffvc", "erffvc", "frffvc"};

    public static String[] newRandomName(String nameType) {
        Object rootName;
        String r_suffix;
        String r_prefix;
        block82: {
            int filterFail;
            int repeatedChar;
            int sizeUnderflow;
            int sizeOverflow;
            int blankRoot;
            int tooManyFailures;
            int rootname_syllable_inserts;
            ArrayList<Integer> pooled_length_weights;
            Object[] root_terminal;
            Object[] root_sylBegin;
            Object[] root_initial;
            Random random;
            block81: {
                int i;
                int numnames;
                random = new Random();
                String[] nameType_raw = nameType.trim().split("\\s*-\\s*");
                String[] nameType_a = new String[nameType_raw.length];
                for (int input_i = 0; input_i < nameType_raw.length; ++input_i) {
                    nameType_a[input_i] = nameType_raw[input_i].toLowerCase().trim();
                }
                Object[] prefix = new String[]{};
                root_initial = new String[]{};
                root_sylBegin = new String[]{};
                root_terminal = new String[]{};
                Object[] suffix = new String[]{};
                float prefix_chance = 0.0f;
                float suffix_chance = 0.0f;
                int normalization = 0;
                pooled_length_weights = new ArrayList<Integer>();
                if (Arrays.asList(nameType_a).contains("village")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])VillageConfigHandler.village_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])VillageConfigHandler.village_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])VillageConfigHandler.village_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])VillageConfigHandler.village_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])VillageConfigHandler.village_suffix);
                    numnames = "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Aa, Ash, Au, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Bai, Be, Be, Be, Be, Be, Be, Be, Be, Beau, Bei, Bei, Bei, Bi, Bi, Bi, Bi, Bi, Bloe, Bo, Bo, Bo, Bra, Bra, Bra, Bra, Bra, Bra, Bra, Bri, Bri, Bri, Bru, Bru, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bue, Bue, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Cai, Cai, Cay, Cay, Ce, Cha, Cha, Cha, Chi, Chi, Cley, Cli, Clo, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Conde, Cre, Cre, Cru, Cu, Da, Da, Da, Da, Da, Da, De, De, De, Dha, Dha, Di, Di, Dji, Dji, Do, Do, Do, Do, Do, Do, Do, Dou, Dou, Dou, Du, Du, Du, Du, Du, Du, Du, Du, Dy, E, E, E, E, E, E, E, Ed, Ed, Fa, Fa, Fa, Fai, Fi, Fi, Fi, Fi, Fi, Fi, Fra, Free, Free, Fu, Fu, Fy, Ga, Ga, Ga, Ga, Gai, Geo, Geo, Geo, Geo, Geo, Geo, Geo, Geo, Gi, Gi, Go, Goa, Gree, Gro, Gu, Gu, Gua, Gua, Gua, Gy, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, He, He, He, He, Hi, Ho, Ho, Ho, Ho, I, I, I, I, I, I, Ja, Ja, Ja, Ja, Ja, Je, Je, Je, Ji, Jo, Jo, Jo, Jo, Jo, Ju, Ju, Ju, Jua, Jua, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Kai, Kha, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Kie, Ko, Ko, Ko, Ko, Ku, Ku, Ku, Kua, Kua, Kyi, La, La, Li, Li, Li, Li, Li, Li, Li, Li, Li, Li, Li, Lju, Lju, Lo, Lo, Lo, Lo, Lo, Lo, Lo, Lou, Lou, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Luo, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Mba, Me, Me, Me, Me, Mi, Mi, Mi, Mi, Mi, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Moo, More, More, Mu, Mu, Mu, My, My, My, N, N, N, Na, Na, Na, Na, Na, Nai, Nai, Nay, Ne, Ni, Ni, Ni, Ni, Nia, Nia, Nou, Nou, Noua, Noua, Nu, Nu, Nuu, Nuu, O, O, O, O, O, O, O, Oua, Oua, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pau, Pe, Pe, Pe, Phi, Phno, Phno, Pi, Pi, Ply, Po, Po, Po, Po, Pra, Pra, Pra, Pra, Pra, Pre, Pre, Pri, Pri, Pri, Pri, Pu, Pyo, Pyo, Que, Que, Qui, Ra, Ra, Re, Re, Rey, Rey, Ri, Ri, Ri, Ri, Ro, Ro, Ro, Ro, Ro, Roa, Roa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sai, Sai, Schaa, Se, Se, Se, Se, Se, Seou, Seou, Sha, Shi, Si, Si, Si, Sko, Sko, So, So, Spai, Sta, Sta, Ste, Ste, Sto, Sto, Su, Su, Su, Su, Su, Sy, Sy, T, T, T\u00f3, T\u00f3, Ta, Ta, Ta, Ta, Ta, Ta, Ta, Tai, Tai, Te, Te, Te, Te, Te, Te, Tha, Thi, Thi, Thi, Ti, Ti, Ti, Ti, Ti, Ti, To, To, To, To, To, To, To, To, Tre, Tree, Tri, Tri, Troi, Tskhi, Tskhi, Tu, Tu, Tu, Tze, U, U, U, Va, Va, Va, Va, Va, Va, Ve, Vi, Vi, Vi, Vi, Vi, Vi, Vi, Vi, Vie, Vie, Wa, Wa, Wa, Wa, Wa, We, We, Wi, Wi, Wi, Wi, Wi, Wu, Xi, Ya, Ya, Ya, Ya, Ya, Ye, Ye, Yo, Z\u00fc, Za, Za, Zo".length();
                    prefix_chance += VillageConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += VillageConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < VillageConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + VillageConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(VillageConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("temple")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])TempleConfigHandler.temple_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])TempleConfigHandler.temple_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])TempleConfigHandler.temple_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])TempleConfigHandler.temple_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])TempleConfigHandler.temple_suffix);
                    numnames = "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Au, Au, B\u00f3, Ba, Ba, Ba, Ba, Ba, Ba, Baa, Baa, Be, Bo, Bor, Bu, C\u00f3, Ca, Ca, Ca, Cae, Ce, Ch\u00e2, Ci, Clau, Cle, Co, Co, Co, Co, Cou, Cu, Da, Da, De, De, De, De, Di, Di, Di, Di, Do, Do, Do, Do, Do, E, E, E, E, E, E, E, E, E, E, F\u00e2, Fau, Fe, Fi, Fle, G, G\u00f6, Ga, Ge, Ge, Gha, Giu, Gra, Grie, Ha, Ha, Ha, Ha, Ha, Ha, He, He, He, He, He, He, He, He, Hei, Hi, I, I, Ja, Je, Jo, Ju, Ju, Ju, Ka, Ka, Kha, Ko, Koe, Ku, La, Le, Le, Le, Li, Lo, Lu, Lu, Ly, Ly, M, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Me, Me, Me, Me, Mi, Mi, Mo, Mou, Mu, Mu, Ne, Ne, Ni, Ny, O, O, O, Pa, Pa, Pa, Pa, Pa, Pe, Pe, Pea, Phi, Po, Po, Po, Po, Pri, Pri, Pu, Qa, Qa, Qe, Ra, Ra, Re, Ro, Ro, Ro, Ro, Ro, S, Sa, Sa, Sa, Sa, Sa, Sch\u00f6, Se, Se, Se, Se, Se, Se, Se, Sha, Si, Si, Si, Si, Sko, So, So, Spe, Sy, Sy, Ta, Ta, Ta, Ta, Ta, Ta, Tau, Te, Te, Te, Thu, Ti, To, To, Tr\u00e9, Tra, Tu, U, U, V\u00e9, Va, Ve, Ve, Ve, Ve, Ve, Ve, Vei, Vi, Vi, Wa, Wa, Wa, We, Xa, Xe, Y, Za, Za, Zeu".length();
                    prefix_chance += TempleConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += TempleConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < TempleConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + TempleConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(TempleConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("mineshaft")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])MineshaftConfigHandler.mineshaft_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])MineshaftConfigHandler.mineshaft_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])MineshaftConfigHandler.mineshaft_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])MineshaftConfigHandler.mineshaft_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])MineshaftConfigHandler.mineshaft_suffix);
                    numnames = "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Age, Ape, Ay, B\u00e4, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Bau, Be, Be, Be, Be, Be, Be, Bea, Bea, Bi, Bi, Bi, Bi, Bi, Bla, Blue, Bo, Bo, Boo, Bou, Boy, Bra, Bre, Bri, Bri, Bro, Bro, Bro, Broo, Brou, Bru, Bru, Bru, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bu, Bw, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Cau, Ce, Ce, Ch\u00f9i, Cha, Cha, Cha, Cha, Che, Chi, Chi, Ci, Cli, Cli, Cli, Cli, Cli, Cli, Clo, Co, Co, Co, Co, Co, Co, Co, Co, Co, Co, Coo, Cra, Crei, Cri, Cro, Cy, Da, Da, Da, Da, Da, Da, De, Di, Di, Do, Do, Do, Do, Dru, Dvoi, E, E, E, E, E, E, Fa, Fa, Fe, Fe, Fe, Fi, Fi, Fle, Flee, Fo, Fo, Fra, Fro, Froo, Ga, Ga, Ga, Ge, Ge, Geo, Gi, Gi, Gi, Gi, Gi, Gla, Glei, Go, Goo, Gra, Gre, Gree, Gree, Gu, Gui, Gwa, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Hay, He, He, He, He, He, Hi, Hi, Hi, Hi, Hi, Hi, Hi, Ho, Ho, Ho, Ho, Hu, Hu, I, I, I, I, I, I, Ja, Jo, Jo, Ju, Jua, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Ke, Ke, Ke, Ke, Kee, Kho, Ki, Ki, Ki, Ki, Ki, Ki, Ki, Kii, Klo, Ko, Ko, Ko, Kra, Kre, Ku, Ku, L\u00f8, La, La, La, La, La, La, Le, Le, Li, Li, Li, Lo, Lo, Lu, Lu, Lu, Ly, M\u00e9, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, May, Me, Mi, Mi, Mi, Mi, Mi, Mo, Mo, Mo, Mo, Mo, Mo, Mu, Mu, Mu, Na, Na, Na, Na, Na, Ne, Ne, Neui, No, No, No, No, Noo, Nu, O, O, O, O, O, O, Oa, Oa, Ou, P, P\u00eb, Pa, Pa, Pa, Pa, Pa, Pa, Pa, Pau, Pe, Pe, Pe, Pe, Pe, Phoe, Pi, Pi, Plea, Plu, Pre, Pri, Prie, Pro, Pro, Pu, Py, Qui, Qui, Ra, Ra, Ra, Ra, Ra, Ray, Re, Re, Ri, Ri, Ro, Rou, Ru, Sa, Sa, Sa, Schuy, Se, Se, Se, Sea, Sha, Sha, Shi, Shu, Si, Si, Sli, Smi, Smu, Sna, Snae, So, Sou, Spa, Spri, Sta, Sta, Sta, Stave, Ste, Stee, Stee, Sti, Stra, Stro, Stu, Su, Su, Su, Su, Su, Su, Ta, Ta, Ta, Ta, Ta, Tau, Te, Te, Tha, The, Tho, Thu, Ti, Ti, To, To, Trea, Tu, Tu, Tu, Ty, Ty, U, U, Va, Vi, Vla, Wa, Wa, Wa, Wa, Wa, We, We, We, Whi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wie, Wo, Wri, Wu, Wy, Ye, Yo, You, Yu, Za, Zi, Zo, Zo".length();
                    prefix_chance += MineshaftConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += MineshaftConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < MineshaftConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + MineshaftConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(MineshaftConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("fortress")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])FortressConfigHandler.fortress_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])FortressConfigHandler.fortress_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])FortressConfigHandler.fortress_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])FortressConfigHandler.fortress_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])FortressConfigHandler.fortress_suffix);
                    numnames = "\u00c9, A, A, A, A, A, A, A, Aea, Ca, Cae, Ce, Ce, Cha, Chi, Ci, Co, Di, Di, Dra, Du, E, E, E, Eu, Fey, Ga, Gj\u00f6, Gja, Go, Ha, Ha, He, He, He, Hy, Hy, I, La, Le, Le, M\u00f3, Me, Me, Mi, Mi, Mu, Mu, N\u00e1, Na, Ni, Ni, O, Pa, Pa, Pa, Pe, Pe, Phae, Phle, Plu, Pro, Rha, So, Sty, Ta, Ta, Tha, Ti, Ti, Tu, Xi, Yo, You".length();
                    prefix_chance += FortressConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += FortressConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < FortressConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + FortressConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(FortressConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("stronghold")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])StrongholdConfigHandler.stronghold_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])StrongholdConfigHandler.stronghold_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])StrongholdConfigHandler.stronghold_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])StrongholdConfigHandler.stronghold_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])StrongholdConfigHandler.stronghold_suffix);
                    numnames = "\u00c1, A, A, A, A, A, A, A, A, Au, Ba, Ba, Ba, Ba, Ba, Ba, Bei, Bi, Bou, Bri, Cai, Cha, Cha, Che, Co, Co, Co, Co, Co, Cze, Da, De, Di, Du, E, E, Fa, Fa, Flo, Flo, G\u00f6, Ge, Go, Gri, Gu, Ha, He, He, Hei, Hi, Hi, Hu, I, Ja, Ja, Je, Je, Je, Ju, Ka, Ke, Kli, Ko, Kre, Ku, Lo, Lu, Lu, M, Ma, Ma, Ma, Me, Me, Me, Mie, Mo, Mo, Ne, Ni, Ni, O, Pa, Pa, Pa, Pe, Po, Qry, Qua, Ra, Rha, Ru, Sa, Sa, Se, Se, Se, Se, Si, Sie, Sta, Sto, Su, Su, Svea, Tla, To, Tra, Tri, Va, Vi, Vi, Wa, Xi, Yo".length();
                    prefix_chance += StrongholdConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += StrongholdConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < StrongholdConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + StrongholdConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(StrongholdConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("monument")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])MonumentConfigHandler.monument_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])MonumentConfigHandler.monument_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])MonumentConfigHandler.monument_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])MonumentConfigHandler.monument_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])MonumentConfigHandler.monument_suffix);
                    numnames = "A, A, A, A, A, A, A, A, Aa, Bai, Bi, Bou, Bu, Ca, Ca, Ca, Ca, Can, Co, Cu, Di, Dwa, Ei, Ga, Ge, Ge, Ha, He, He, He, He, Kha, Ki, L, Le, Lo, Lu, Ly, Ma, Ma, Mu, Mu, Na, Na, Ne, Ne, O, O, O, Pa, Pha, Phe, Po, Pu, Quia, R, Ra, Ra, Ra, Rha, Ru, Sa, Sa, Sa, Sae, Shi, Su, Ta, Ta, Tho, Ti, Tu, Y, Ya, Yo".length();
                    prefix_chance += MonumentConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += MonumentConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < MonumentConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + MonumentConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(MonumentConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("endcity")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])EndCityConfigHandler.endcity_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])EndCityConfigHandler.endcity_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])EndCityConfigHandler.endcity_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])EndCityConfigHandler.endcity_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])EndCityConfigHandler.endcity_suffix);
                    numnames = "A, A, A, A, Ba, Brah, Ca, Ca, Ce, Ce, Cha, Di, Dy, E, E, E, E, E, Eu, Eu, Ga, Gai, Hau, Hea, Hla, I, I, I, I, I, Ju, Ka, Ko, Lu, Ma, Ma, Ma, Me, Me, Mi, Mi, Moo, N\u00f3, Ne, Ni, O, Pa, Plu, Pu, Rhe, Sa, Sa, Se, Su, Te, Te, Ti, Tla, Tri, U, U, U, U, Va, Ve, Yh, Yo".length();
                    prefix_chance += EndCityConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += EndCityConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < EndCityConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + EndCityConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(EndCityConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("mansion")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])MansionConfigHandler.mansion_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])MansionConfigHandler.mansion_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])MansionConfigHandler.mansion_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])MansionConfigHandler.mansion_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])MansionConfigHandler.mansion_suffix);
                    numnames = "'I, A, A, A, A, A, A, A, Be, Be, Be, Be, Bi, Blai, Bo, Brae, Bray, Brea, Ca, Ca, Ca, Cha, Co, Co, Coe, Da, Da, Du, Du, E, E, E, Fai, Fi, Fleu, Flo, Fri, Ga, Ge, Gle, Grey, Ha, Ha, Hay, He, Hea, Hi, Ho, Ho, Hu, Hy, Hy, I, I, I, Ka, Ky, Ly, Ly, Ma, Ma, McCu, Mea, Mi, Mi, Mo, Ne, O, O, O, O, Pa, Pa, Pa, Pa, Pa, Pay, Pe, Pe, Po, Pre, R\u00ea, Ra, Re, Rei, Ri, Ro, Ry, Se, Se, Sea, Sea, Sha, Sha, She, Shi, Ti, To, To, Twi, U, Ve, Vi, Wa, Wa, Whi, Whi, Wi, Wi, Wi, Woo, Xa, Ya, Zi".length();
                    prefix_chance += MansionConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += MansionConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < MansionConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + MansionConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(MansionConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("alien")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])AlienConfigHandler.alien_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])AlienConfigHandler.alien_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])AlienConfigHandler.alien_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])AlienConfigHandler.alien_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])AlienConfigHandler.alien_suffix);
                    numnames = "'Y, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Ae, Ai, Ay, B, Ba, Ba, Ba, Bo, Bu, Bya, C, Chau, Co, Co, Cro, Cthaa, Cthae, Cthu, Cthu, Cthy, Cto, Cxa, Cy, Cy\u00e4, D, Da, Dhu, Di, Dray, Dry, Dy, Dy, Dz\u00e9, E, E, Ei, Ei, Fu, Ge, Gha, Ghi, Ghro, Ghro, Gi, Gla, Glee, Gloo, Go, Go, Go, Go, Go, Gtu, Gu, Gu, Gwa, Gz, H, Ha, Ha, Ha, Ha, Hai, Hna, Hziu, I, I, I, I, I, I, I, Ia, Ja, Je, Ju, K, Ka, Ka, Ka, Kaa, Kaa, Kau, Kha, Klaa, Klo, Klu, Kra, Krai, Kri, Ktha, Ktha, Ku, La, Le, Lloi, Lo, Lo, Lo, Lu, Ly, M, M, M, Ma, Mla, Mno, Mo, Mo, Mo, Mo, Mri, My, N, N, N, Na, Nee, Ngi, Ngy, No, No, Nu, Ny, Ny, Ny, Nya, Nya, Nyo, O, O, O, O, O, O, O, O, Oo, Ou, Pa, Pe, Pha, Pha, Po, Psu, Pta, Q, Qu, Qua, R, R, Ra, Ra, Raa, Rha, Rha, Rho, Ri, Ro, S, Sa, Saa, Sca, Se, Se, Se, Sfa, Sha, Sha, Sha, Sha, Shau, She, Shi, Shli, Sho, Shte, Shu, Shu, Shuy, Stha, Su, Su, Swa, Ta, Te, Th, Tha, Tha, Tha, Tha, Tho, To, Tru, Tsa, Tu, Tu, Tu, U, U, U, U, Ui, V, Ve, Vhu, Vi, Vi, Vo, Vo, Vo, Vu, Wa, X, Xa, Xa, Xe, Xi, Xi, Xi, Xi, Xo, Xo, Y, Y, Y, Y, Y, Y, Ya, Ya, Ya, Ye, Ye, Yha, Yha, Yhou, Yi, Yi, Yi, Yo, Yo, Yo, Yo, Yu, Yu, Yu, Z, Z, Za, Ze, Zha, Zi, Zi, Zo, Zo, Zu, Zvi".length();
                    prefix_chance += AlienConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += AlienConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < AlienConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + AlienConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(AlienConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("alienvillage")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])AlienVillageConfigHandler.alienvillage_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])AlienVillageConfigHandler.alienvillage_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])AlienVillageConfigHandler.alienvillage_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])AlienVillageConfigHandler.alienvillage_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])AlienVillageConfigHandler.alienvillage_suffix);
                    numnames = "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Ae, Ae, Au, Au, B, Ba, Baa, Baa, Be, Be, Bi, Bi, Bla, Bo, Bo, Bo, Bo, Bo, Bo, Bou, Bra, Bray, Bri, Bu, Bu, By, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Ca, Cau, Cau, Ce, Cha, Cle, Cle, Cloo, Co, Co, Co, Co, Cri, Cu, Cy, Da, Da, Da, Da, Da, De, De, Di, Di, Di, Do, Do, Dra, Dzie, E, E, E, E, E, Eu, Fe, Fe, Fe, Fi, Fla, Fo, Fo, Fre, Fri, Fu, Fu, G, G, G, G\u00e4, Ga, Ga, Ga, Ga, Ga, Gau, Gay, Ge, Gei, Gllo, Glo, Gly, Gna, Gra, Gra, Gri, Gru, Gue, H, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Hae, He, He, He, Hei, Hi, Hi, Hi, Ho, Hu, Hu, Hu, Huy, Hy, Hy, Hy, I, I, I, I, I, Ja, Ja, Ju, K, K, K, K, Ke, Ko, Ko, Kra, Krie, Ku, Ky, Ky, L, La, Le, Leu, Li, Li, Lie, Lu, Lu, Lu, M, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Mae, Mai, Mau, May, Me, Me, Me, Me, Me, Me, Mi, Mi, Mi, Mo, Mo, Mo, Ne, Ni, Ni, Ni, Niu, Nu, Nyi, O, O, O, O, O, O, O, O, O, Pa, Pa, Pa, Pe, Pe, Pe, Pe, Ph, Phe, Pi, Pi, Pi, Pi, Pla, Pla, Plei, Pli, Pni, Po, Po, Pri, Pro, Pru, Ptha, Pu, Py, R\u00e9, R\u00f6, R\u00fc, Ra, Re, Re, Re, Rei, Rei, Rhei, Rhy, Ri, Ri, Ri, Ri, Ro, Roo, Ru, Ru, Sa, Sa, Schr\u00f6, Schr\u00f6, Schr\u00f6, Sci, Se, Se, Seu, Sha, Sha, Shee, Sho, Shu, Si, Si, Sie, Smi, Smy, Sne, So, So, So, So, So, Spei, Spi, Spu, Ste, Sti, Su, Su, Su, Su, Sy, Sy, Ta, Tae, Tau, Te, Te, Te, Te, The, The, Thu, Thu, Thy, Ti, Ti, Ti, To, To, Tra, Tri, U, U, U, V, Va, Va, Ve, Ve, Ve, Vhoo, Vi, Vi, Vi, Vi, Vi, Vla, Vo, Wa, We, Whi, Wo, Wu, Xa, Xe, Xe, Xi, Xi, Xo, Y, Y, Y, Ya, Ya, Ya, Ya, Ya, Ya, Ye, Yi, Yi, Yi, Yli, Yu, Yu, Z, Za, Za, Zi, Zly, Zu".length();
                    prefix_chance += AlienVillageConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += AlienVillageConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < AlienVillageConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + AlienVillageConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(AlienVillageConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("goblin")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])GoblinConfigHandler.goblin_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])GoblinConfigHandler.goblin_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])GoblinConfigHandler.goblin_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])GoblinConfigHandler.goblin_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])GoblinConfigHandler.goblin_suffix);
                    numnames = "A, A, A, A, A, A, A, A, A, A, A, A, B, Ba, Ba, Bau, Be, Bei, Bla, Ble, Bo, Bo, Bri, Bri, Bro, Bu, Bu, Bu, Ca, Ca, Cae, Ce, Ci, Cl\u00edo, Clu, Cy, Cy, D\u00f6, Da, Da, Di, Do, Do, Do, Drau, Dry, Du, Dwa, E, E, E, E, E, E, E, Fae, Fai, Fau, Fi, Fi, Frey, Frey, Ga, Ga, Ghou, Gi, Glo, Gno, Go, Go, Go, Gre, Gre, Gwi, Gwy, Gwy, Ha, Ha, Ha, He, Hi, Hi, Ho, Ho, Hu, Hu, I, In, Ja, Je, Ji, Jo, Jo, Ka, Ka, Ka, Ke, Ki, Ki, Kla, Kno, Ko, Ko, La, La, Le, Li, Li, Lj\u00f3, Lu, Lu, Ma, Ma, Ma, Ma, Ma, Ma, Me, Mi, Mo, Mo, Mo, Moo, Moo, Na, Na, Nai, Ne, Ne, Ni, Ni, Nu, Nu, Ny, O, O, O, O, Pa, Pi, Po, Po, Poo, Pu, Pu, Ra, Re, Ro, Ru, Sa, Sa, Sa, Sa, Se, See, She, Si, Si, Smy, So, Sphi, Spri, Spri, Su, Sva, Sy, Te, Te, Tho, Ti, Ti, Ti, To, Tra, Tri, Tro, Tro, Tsu, U, U, V\u00e6, Va, Vi, Wa, Wa, We, Xa, Y, Ya, Ya, Ya, Ye, Yu, Zo, Zo".length();
                    prefix_chance += GoblinConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += GoblinConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < GoblinConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + GoblinConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(GoblinConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("golem")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])GolemConfigHandler.golem_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])GolemConfigHandler.golem_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])GolemConfigHandler.golem_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])GolemConfigHandler.golem_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])GolemConfigHandler.golem_suffix);
                    numnames = "\u00c9, \u0130, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Ae, Ba, Ba, Ba, Bha, Bi, Bri, Bu, Bu, Ca, Cha, Che, Chri, Co, Co, D, Da, Da, Do, Du, Du, E, E, E, E, E, E, E, Ei, Eu, Fe, Fe, Fra, Fre, Fre, Frie, Gau, Ge, Ge, Ge, Geo, Go, Ha, Ha, He, He, He, He, He, Hja, Ho, Hua, I, I, I, Ja, Je, Je, Je, Jea, Jo, Jo, Jo, Jo, Joe, Ju, Jua, Ka, Ka, Kha, Kle, Kro, Ku, L\u00e9, La, La, Lai, Le, Le, Le, Li, Li, Lou, Lou, Lu, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Me, Mi, Mo, Mu, Na, Naa, Ne, Ne, Ne, Ni, Ni, Ni, No, Nu, O, O, O, Ou, Pe, Po, Ra, Ro, Ro, Sa, Sa, Sa, Sa, Sa, Sa, Se, Shi, Si, Si, Ta, Te, Tha, The, The, Tho, Ti, U, Va, Va, Vai, Ve, Vi, Vi, Vla, Vu, Wa, Wi, Wi, Wi, Wi, Wi, Ya, Ya, Zeu".length();
                    prefix_chance += GolemConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += GolemConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < GolemConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + GolemConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(GolemConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("demon")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])DemonConfigHandler.demon_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])DemonConfigHandler.demon_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])DemonConfigHandler.demon_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])DemonConfigHandler.demon_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])DemonConfigHandler.demon_suffix);
                    numnames = "\u00d6, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Aa, Ae, Ai, As, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Baa, Bae, Be, Be, Be, Be, Be, Be, Be, Bhu, Bi, Bi, Bo, Bo, Bu, Bu, Bu, Bue, By, Ca, Ca, Ca, Ca, Caa, Caa, Cai, Ce, Cha, Cha, Che, Cho, Cho, Ci, Ci, Cla, Co, Cro, Cu, D, Da, Da, Da, Da, Da, Da, Dao, De, De, De, De, Di, Dji, Dre, E, E, E, Ei, Ex, Fla, Flau, Fo, Fo, Fo, Fo, Fo, Fo, Fu, Fu, Ga, Ga, Ga, Gaa, Gau, Ghou, Gla, Gla, Go, Go, Gre, Gri, Gu, Gu, Gu, Gu, Gua, Gua, Ha, Ha, Ha, Ha, Haa, Hau, Hei, Hi, I, I, I, I, I, I, If, Ji, Ji, Ka, Ka, Ka, Ka, Ka, Ki, Ko, Kra, Kro, Ku, Ku, Le, Le, Le, Le, Le, Le, Le, Leo, Li, Li, Li, Li, Lju, Lu, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Me, Me, Me, Me, Me, Mo, Mo, Mu, Na, Na, Na, Naa, Ne, Ne, Ni, O, O, O, O, O, O, O, O, Pa, Pa, Pai, Pe, Pe, Phe, Pho, Pi, Po, Po, Pre, Pro, Pru, Pu, Ra, Ra, Ra, Rau, Ro, Ru, Ru, S, Sa, Sa, Sa, Sa, Sa, Sa, Sca, Se, Sei, Sha, Shai, She, Si, Si, So, Sti, Sto, Su, Su, Sua, Ta, Ta, Ti, Ti, To, Tri, Tu, Twi, U, Va, Va, Va, Va, Va, Ve, Vi, We, We, We, Ye, Za, Ze, Zi, Zu".length();
                    prefix_chance += DemonConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += DemonConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < DemonConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + DemonConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(DemonConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("angel")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])AngelConfigHandler.angel_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])AngelConfigHandler.angel_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])AngelConfigHandler.angel_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])AngelConfigHandler.angel_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])AngelConfigHandler.angel_suffix);
                    numnames = "A, A, A, A, A, A, A, A, A, A, A, A, Ba, Ba, Ca, Ca, Che, Da, Da, Du, E, E, Fe, Fe, Ga, Ga, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, He, He, Ho, I, I, I, Je, Je, Je, Je, Je, Ji, Jo, Ka, Ka, Ke, Ke, Ke, Kha, Ki, Ku, La, Le, Lu, Ma, Maa, Me, Me, Mi, Mi, Mo, Mu, Mu, Mu, Na, Na, Ne, Ni, Nu, O, O, Pa, Pe, Pha, Po, Pra, Pu, Qa, Ra, Ra, Ra, Ra, Ra, Rai, Re, Ri, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sche, Se, Se, Sha, Sha, Shi, Si, Te, Te, Tu, U, U, Va, Ve, Wor, Za, Za, Za, Za, Ze, Ze, Zo".length();
                    prefix_chance += AngelConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += AngelConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < AngelConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + AngelConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(AngelConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("dragon")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])DragonConfigHandler.dragon_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])DragonConfigHandler.dragon_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])DragonConfigHandler.dragon_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])DragonConfigHandler.dragon_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])DragonConfigHandler.dragon_suffix);
                    numnames = "A, A, A, A, A, A, A, A, Ai, B, Ba, Ba, Ba, Bo, Boi, Co, Co, Cu, Ddrai, Dr\u00e1, Dra, Dra, Dre, E, E, E, E, E, Fa, Go, Gui, Gyo, Hua, Hy, I, I, I, J\u00f6, Ku, Ku, Ku, L\u00f3, La, La, Le, Li, Lo, Mu, N\u00ed, Na, Nea, No, O, Ou, Pa, Py, Q', Qi, Que, Que, Ry, Ry, S\u00e1, Sei, Sli, Smo, Sy, Te, Te, The, Ti, Ti, Ty, Ve, Vi, Vri, Wy, Wy, Xiu, Ya, Yi, Yo, Za, Zbu, Zi, Zi, Zi, Zmei, Zo".length();
                    prefix_chance += DragonConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += DragonConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < DragonConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + DragonConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(DragonConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("custom")) {
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])CustomConfigHandler.custom_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])CustomConfigHandler.custom_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])CustomConfigHandler.custom_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])CustomConfigHandler.custom_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])CustomConfigHandler.custom_suffix);
                    numnames = "No".length();
                    prefix_chance += CustomConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += CustomConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < CustomConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + CustomConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(CustomConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (Arrays.asList(nameType_a).contains("villager") || root_initial.length <= 0) {
                    if (!Arrays.asList(nameType_a).contains("villager") && root_initial.length <= 0 && GeneralConfig.debugMessages) {
                        LogHelper.error("Submitted nameType contained no valid entries! Defaulting to Villager name pool.");
                    }
                    prefix = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])VillagerConfigHandler.villager_prefix);
                    root_initial = (String[])ArrayUtils.addAll((Object[])root_initial, (Object[])VillagerConfigHandler.villager_root_initial);
                    root_sylBegin = (String[])ArrayUtils.addAll((Object[])root_sylBegin, (Object[])VillagerConfigHandler.villager_root_syllables);
                    root_terminal = (String[])ArrayUtils.addAll((Object[])root_terminal, (Object[])VillagerConfigHandler.villager_root_terminal);
                    suffix = (String[])ArrayUtils.addAll((Object[])suffix, (Object[])VillagerConfigHandler.villager_suffix);
                    numnames = "A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Aa, Aa, Ab, Ae, Ai, Ai, Ai, Ay, Ba, Ba, Ba, Ba, Ba, Ba, Ba, Bai, Be, Be, Be, Be, Be, Be, Be, Be, Be, Bi, Bi, Bi, Bi, Bi, Bi, Bi, Bla, Bo, Bo, Bo, Bo, Bra, Bra, Bra, Bra, Bru, Bu, Bu, Ca, Ca, Ca, Ca, Cai, Ce, Ce, Ce, Cha, Cha, Cha, Che, Chi, Chia, Chlo, Chlo, Chri, Chri, Chri, Chri, Chri, Chry, Ci, Ci, Ci, Ci, Clou, Co, Co, Co, Cry, Cy, Da, Da, Da, Da, Da, Da, Da, Da, Da, Da, Da, Dai, De, De, De, De, De, De, Deu, Di, Di, Di, Do, Do, Do, Do, Do, Do, Do, Dra, Du, Du, Dua, Dy, Dy, Dzo, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, E, Ea, Ei, El, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fa, Fe, Fi, Fi, Flo, Flo, Fo, Fra, Fra, Fre, Fri, Fu, Fu, G\u00fc, Ga, Ga, Ga, Ga, Ga, Ga, Ga, Ga, Ga, Ga, Ga, Gae, Gau, Geo, Geo, Geo, Geo, Geo, Geo, Geo, Geo, Gi, Gi, Gi, Gio, Glo, Go, Go, Go, Go, Gre, Gu, Guo, Guy, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Ha, Hay, He, He, He, He, He, Hei, Hei, Hi, Hi, Hi, Hi, Hi, Ho, Ho, Ho, Ho, Ho, Hu, Hu, Hui, Hui, I, I, I, I, I, I, I, I, I, I, I, Io, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Ja, Jay, Jay, Jay, Je, Je, Je, Je, Ji, Ji, Jia, Jie, Jo, Jo, Jo, Jo, Jo, Jo, Jo, Jo, Jo, Joe, Joe, Ju, Ju, Ju, Ju, Jua, Ka, Ka, Ka, Ka, Ka, Ka, Ka, Kai, Ke, Ke, Ke, Kha, Ki, Ki, Ki, Ki, Ki, Ki, Ko, Ko, Ko, Kri, Kri, Kse, Ku, L\u00e9, La, La, La, La, La, La, Lau, Lau, Lau, Le, Le, Le, Le, Le, Le, Le, Lei, Li, Li, Li, Li, Li, Li, Li, Lia, Lia, Lo, Lo, Lo, Lo, Lou, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Lu, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Maa, Mau, Me, Me, Me, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mi, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mo, Mu, Mu, Mu, Mu, Mu, My, Na, Na, Na, Na, Na, Na, Na, Ne, Ne, Ne, Ne, Nea, Ni, Ni, Ni, Ni, Ni, Ni, Ni, No, No, No, No, No, No, No, No, No, No, No, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, Pa, Pa, Pa, Pa, Pau, Pau, Pau, Pe, Pe, Pe, Pe, Phae, Pi, Pi, Po, Po, Pre, Pri, Pu, Py, Qia, Qio, Qui, Ra, Ra, Ra, Rai, Rai, Ray, Re, Re, Re, Re, Re, Ree, Ree, Rhi, Ri, Ri, Ri, Ri, Ri, Ri, Ro, Ro, Ro, Ro, Ro, Ro, Ro, Ru, Ru, Ru, Ru, Ry, Ry, Ry, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sa, Sca, Sco, Sco, Sco, Se, Se, Se, Se, Se, Se, Se, Se, Se, Sei, Seo, Sha, Sha, Sha, Shei, Shri, Shu, Shu, Si, Si, Si, Sji, Smi, Smi, Smy, So, So, So, So, So, So, So, So, So, So, So, So, So, So, So, So, Squa, Sta, Ste, Ste, Ste, Stra, Su, Su, Ta, Ta, Ta, Ta, Ta, Ta, Tao, Te, Te, Te, Te, Te, Te, Te, Tha, The, Tho, Tho, Tho, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, Ti, To, To, To, To, To, To, To, To, Tre, Tri, Tsu, Tsu, U, U, U, U, Va, Ve, Vi, Vi, Vi, Vi, Vi, Vi, Vi, Vi, Vi, Wa, Wa, We, We, We, Wei, Wei, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Wi, Xa, Xe, Xi, Xia, Xia, Xu, Ya, Ya, Ya, Ye, Yo, You, Yu, Yu, Yu, Yu, Za, Za, Ze, Ze, Ze, Ze, Zhe, Zi, Zi, Zo, Zo, Zo, Zo".length();
                    prefix_chance += VillagerConfigHandler.prefix_chance * (float)numnames;
                    suffix_chance += VillagerConfigHandler.suffix_chance * (float)numnames;
                    normalization += numnames;
                    for (i = 0; i < VillagerConfigHandler.syllable_count_weighting.length; ++i) {
                        if (pooled_length_weights.size() > i) {
                            pooled_length_weights.set(i, (Integer)pooled_length_weights.get(i) + VillagerConfigHandler.syllable_count_weighting[i]);
                            continue;
                        }
                        pooled_length_weights.add(VillagerConfigHandler.syllable_count_weighting[i]);
                    }
                }
                if (normalization > 0) {
                    prefix_chance /= (float)normalization;
                    suffix_chance /= (float)normalization;
                }
                r_prefix = "";
                r_suffix = "";
                rootName = "";
                rootname_syllable_inserts = 1;
                tooManyFailures = 50;
                blankRoot = 0;
                sizeOverflow = 0;
                sizeUnderflow = 0;
                repeatedChar = 0;
                filterFail = 0;
                int prefixsuffixFail = 0;
                do {
                    r_prefix = "";
                    if (random.nextFloat() < prefix_chance && normalization > 0 && prefix.length > 0) {
                        r_prefix = ((String)prefix[random.nextInt(prefix.length)]).trim();
                    }
                    r_suffix = "";
                    if (random.nextFloat() < suffix_chance && normalization > 0 && suffix.length > 0) {
                        r_suffix = ((String)suffix[random.nextInt(suffix.length)]).trim();
                    }
                    if (r_prefix.equals("") || r_suffix.equals("") || !r_prefix.equals(r_suffix)) break block81;
                } while (++prefixsuffixFail < tooManyFailures);
                String errorMessage = "Name type " + nameType + " Matched too many prefixes and suffixes! Check your syllable configs.";
                LogHelper.fatal(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            do {
                int i;
                int totalWeight = 0;
                for (int i2 = 0; i2 < pooled_length_weights.size(); ++i2) {
                    totalWeight += ((Integer)pooled_length_weights.get(i2)).intValue();
                }
                if (totalWeight <= 0) {
                    String errorMessage = "Name type " + nameType + " total syllable weighting was non-positive! Check the weighting values in your configs.";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                int randomObject = random.nextInt(totalWeight);
                for (i = 0; i < pooled_length_weights.size(); ++i) {
                    if ((randomObject -= ((Integer)pooled_length_weights.get(i)).intValue()) > 0) continue;
                    rootname_syllable_inserts = i;
                    break;
                }
                if (root_initial.length <= 0) {
                    String errorMessage = "Name type " + nameType + " has no root-initial entries! No name can be constructed!";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                rootName = root_initial[random.nextInt(root_initial.length)];
                for (i = 0; i < rootname_syllable_inserts; ++i) {
                    if (root_sylBegin.length <= 0) {
                        String errorMessage = "Name type " + nameType + " has no root-syllable entries! You need at least one, even if it's the blank entry character: ~";
                        LogHelper.error(errorMessage);
                        rootName = (String)rootName + "~";
                        continue;
                    }
                    rootName = (String)rootName + (String)root_sylBegin[random.nextInt(root_sylBegin.length)];
                }
                if (root_terminal.length <= 0) {
                    String errorMessage = "Name type " + nameType + " has no root-terminal entries! You need at least one, even if it's the blank entry character: ~";
                    LogHelper.error(errorMessage);
                    rootName = (String)rootName + "~";
                } else {
                    rootName = (String)rootName + (String)root_terminal[random.nextInt(root_terminal.length)];
                }
                rootName = ((String)rootName).trim();
                rootName = ((String)rootName).replace(" ", "");
                rootName = ((String)rootName).replaceAll("\\_", " ");
                rootName = ((String)rootName).replace("^", "");
                if (((String)rootName).length() <= 15) {
                    if (((String)rootName).length() >= 3) {
                        char[] nameRootArray = ((String)rootName).toLowerCase().toCharArray();
                        int consecutives = 0;
                        for (int ci = 0; ci < nameRootArray.length - 2; ++ci) {
                            if (nameRootArray[ci] != nameRootArray[ci + 1] || nameRootArray[ci] != nameRootArray[ci + 2]) continue;
                            ++consecutives;
                        }
                        if (consecutives == 0) {
                            if (!NameGenerator.contentScan((String)rootName)) break block82;
                            ++filterFail;
                        } else {
                            ++repeatedChar;
                        }
                    } else if (((String)rootName).length() == 2) {
                        if (((String)rootName).toLowerCase().charAt(0) != ((String)rootName).toLowerCase().charAt(1)) {
                            if (!NameGenerator.contentScan((String)rootName)) break block82;
                            ++filterFail;
                        }
                    } else if (((String)rootName).length() > 0) {
                        ++sizeUnderflow;
                    } else {
                        ++blankRoot;
                    }
                } else {
                    ++sizeOverflow;
                }
                if (sizeOverflow >= tooManyFailures) {
                    String errorMessage = "Name type " + nameType + " names are too long! Check your syllable lengths.";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                if (sizeUnderflow >= tooManyFailures) {
                    String errorMessage = "Name type " + nameType + " names are too short! Check your syllables configs.";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                if (blankRoot >= tooManyFailures) {
                    String errorMessage = "Name type " + nameType + " Produced blank names! Check your syllable configs.";
                    LogHelper.fatal(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
                if (repeatedChar < tooManyFailures) continue;
                String errorMessage = "Name type " + nameType + " has too many consecutive repeated letters! Check your syllable configs.";
                LogHelper.fatal(errorMessage);
                throw new RuntimeException(errorMessage);
            } while (filterFail < tooManyFailures);
            String errorMessage = "Name type " + nameType + " has tripped the content filter too many times. Are you being naughty?";
            LogHelper.fatal(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        String headerTags = GeneralConfig.headerTags.trim();
        String[] nameStringArray = new String[]{headerTags, r_prefix, rootName, r_suffix};
        return nameStringArray;
    }

    public static String getCareerTag(String entityClasspath, int villagerProfession, String villagerProfessionForge, int villagerCareer, String targetPName) {
        String careerTag;
        block50: {
            Map<String, ArrayList> mappedNamesAutomatic = GeneralConfig.unpackMappedNames(GeneralConfig.modNameMappingAutomatic);
            Map<String, ArrayList> mappedNamesClickable = GeneralConfig.unpackMappedNames(GeneralConfig.modNameMappingClickable);
            Map<String, ArrayList> mappedProfessions = GeneralConfig.unpackMappedProfessions(GeneralConfig.modProfessionMapping);
            careerTag = "(";
            if (mappedNamesClickable.get("ClassPaths").contains(entityClasspath)) {
                careerTag = careerTag + (String)mappedNamesClickable.get("Professions").get(mappedNamesClickable.get("ClassPaths").indexOf(entityClasspath));
                careerTag = careerTag.trim();
            } else if (mappedNamesAutomatic.get("ClassPaths").contains(entityClasspath)) {
                careerTag = careerTag + (String)mappedNamesAutomatic.get("Professions").get(mappedNamesAutomatic.get("ClassPaths").indexOf(entityClasspath));
                careerTag = careerTag.trim();
            } else if (entityClasspath.equals("stevekung.mods.moreplanets.planets.nibiru.entity.EntityNibiruVillager") || entityClasspath.equals("stevekung.mods.moreplanets.module.planets.nibiru.entity.EntityNibiruVillager")) {
                switch (villagerProfession % 3) {
                    case 0: {
                        careerTag = careerTag + "Farmer";
                        break;
                    }
                    case 1: {
                        careerTag = careerTag + "Librarian";
                        break;
                    }
                    case 2: {
                        careerTag = careerTag + "Medic";
                    }
                }
            } else {
                block6 : switch (villagerProfession) {
                    case 0: {
                        switch (villagerCareer) {
                            case 1: {
                                careerTag = careerTag + "Farmer";
                                break block6;
                            }
                            case 2: {
                                careerTag = careerTag + "Fisherman";
                                break block6;
                            }
                            case 3: {
                                careerTag = careerTag + "Shepherd";
                                break block6;
                            }
                            case 4: {
                                careerTag = careerTag + "Fletcher";
                                break block6;
                            }
                        }
                        careerTag = careerTag + "Farmer";
                        break;
                    }
                    case 1: {
                        switch (villagerCareer) {
                            case 1: {
                                careerTag = careerTag + "Librarian";
                                break block6;
                            }
                            case 2: {
                                careerTag = careerTag + "Cartographer";
                                break block6;
                            }
                        }
                        careerTag = careerTag + "Librarian";
                        break;
                    }
                    case 2: {
                        switch (villagerCareer) {
                            case 1: {
                                careerTag = careerTag + "Cleric";
                                break block6;
                            }
                        }
                        careerTag = careerTag + "Priest";
                        break;
                    }
                    case 3: {
                        switch (villagerCareer) {
                            case 1: {
                                careerTag = careerTag + "Armorer";
                                break block6;
                            }
                            case 2: {
                                careerTag = careerTag + "Weaponsmith";
                                break block6;
                            }
                            case 3: {
                                careerTag = careerTag + "Toolsmith";
                                break block6;
                            }
                            case 4: {
                                careerTag = careerTag + "Mason";
                                break block6;
                            }
                        }
                        careerTag = careerTag + "Blacksmith";
                        break;
                    }
                    case 4: {
                        switch (villagerCareer) {
                            case 1: {
                                careerTag = careerTag + "Butcher";
                                break block6;
                            }
                            case 2: {
                                careerTag = careerTag + "Leatherworker";
                                break block6;
                            }
                        }
                        careerTag = careerTag + "Butcher";
                        break;
                    }
                    case 5: {
                        String nitwitCareer = GeneralConfig.nitwitProfession.trim().equals("") || GeneralConfig.nitwitProfession.toLowerCase().trim().equals("null") ? "" : GeneralConfig.nitwitProfession;
                        switch (villagerCareer) {
                            case 1: {
                                careerTag = careerTag + nitwitCareer;
                                break block6;
                            }
                        }
                        careerTag = careerTag + nitwitCareer;
                    }
                }
                if (villagerProfession > 5) {
                    try {
                        String otherModProfString = (String)mappedProfessions.get("Professions").get(mappedProfessions.get("IDs").indexOf(villagerProfessionForge));
                        otherModProfString = otherModProfString.replaceAll("\\(", "");
                        otherModProfString = otherModProfString.replaceAll("\\)", "");
                        otherModProfString = otherModProfString.trim();
                        if (otherModProfString.toLowerCase().equals("null")) {
                            otherModProfString = "";
                        }
                        careerTag = careerTag + otherModProfString;
                    }
                    catch (Exception e) {
                        if (!GeneralConfig.debugMessages) break block50;
                        LogHelper.info("Error evaluating mod profession ID. Check your formatting!");
                    }
                }
            }
        }
        careerTag = careerTag + ")";
        if (careerTag.equals("()")) {
            careerTag = "";
        }
        return careerTag;
    }

    private static boolean contentScan(String inputString) {
        for (String s : filterIfAnywhere) {
            if (!inputString.trim().toLowerCase().contains(new StringBuilder(NameGenerator.rot13(s)).reverse().toString())) continue;
            return true;
        }
        for (String s : filterIfEntire) {
            if (!inputString.trim().toLowerCase().equals(new StringBuilder(NameGenerator.rot13(s)).reverse().toString())) continue;
            return true;
        }
        return false;
    }

    public static String rot13(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            out.append(c);
        }
        return out.toString();
    }
}

