/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.nbt.VNWorldDataStructure;
import astrotibs.villagenames.utility.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WellDecorateEvent {
    Random random = new Random();

    @SubscribeEvent
    public void onPopulating(PopulateChunkEvent.Post event) {
        if (event.isHasVillageGenerated() && event.getWorld().field_73011_w.getDimension() == 0 && !event.getWorld().field_72995_K) {
            int i = (event.getChunkX() << 4) + 8;
            int k = (event.getChunkZ() << 4) + 8;
            int inwardYaw = GeneralConfig.villageBanners ? GeneralConfig.signYaw : 4;
            int signLocation = this.random.nextInt(4);
            int signXOffset = (1 - Math.abs((signLocation + 1) / 2 - 1) * 2) * 2;
            int signZOffset = (signLocation / 2 * 2 - 1) * 2;
            int signHeightOffGround = 2;
            Block signBase = Blocks.field_150347_e;
            int bannerLocation = GeneralConfig.villageBanners ? (signLocation + (this.random.nextBoolean() ? 1 : -1) + 4) % 4 : signLocation;
            int bannerXOffset = (1 - Math.abs((bannerLocation + 1) / 2 - 1) * 2) * 2;
            int bannerZOffset = (bannerLocation / 2 * 2 - 1) * 2;
            int signOrientation = 0;
            int bannerOrientation = 0;
            block4 : switch (signLocation) {
                case 0: {
                    switch (bannerLocation) {
                        case 1: {
                            signOrientation = 8 + inwardYaw;
                            bannerOrientation = 8 - inwardYaw;
                            ++bannerXOffset;
                            break block4;
                        }
                        case 3: {
                            signOrientation = 4 - inwardYaw;
                            bannerOrientation = 4 + inwardYaw;
                            ++bannerZOffset;
                            break block4;
                        }
                    }
                    signOrientation = this.random.nextBoolean() ? 8 + inwardYaw : 4 - inwardYaw;
                    bannerOrientation = 0;
                    break;
                }
                case 1: {
                    switch (bannerLocation) {
                        case 0: {
                            signOrientation = 8 - inwardYaw;
                            bannerOrientation = 8 + inwardYaw;
                            --bannerXOffset;
                            break block4;
                        }
                        case 2: {
                            signOrientation = 12 + inwardYaw;
                            bannerOrientation = 12 - inwardYaw;
                            ++bannerZOffset;
                            break block4;
                        }
                    }
                    signOrientation = this.random.nextBoolean() ? 8 - inwardYaw : 12 + inwardYaw;
                    bannerOrientation = 0;
                    break;
                }
                case 2: {
                    switch (bannerLocation) {
                        case 1: {
                            signOrientation = 12 - inwardYaw;
                            bannerOrientation = 12 + inwardYaw;
                            --bannerZOffset;
                            break block4;
                        }
                        case 3: {
                            signOrientation = 0 + inwardYaw;
                            bannerOrientation = 0 - inwardYaw;
                            --bannerXOffset;
                            break block4;
                        }
                    }
                    signOrientation = this.random.nextBoolean() ? 12 - inwardYaw : 0 + inwardYaw;
                    bannerOrientation = 0;
                    break;
                }
                case 3: {
                    switch (bannerLocation) {
                        case 0: {
                            signOrientation = 4 + inwardYaw;
                            bannerOrientation = 4 - inwardYaw;
                            --bannerZOffset;
                            break block4;
                        }
                        case 2: {
                            signOrientation = 0 - inwardYaw;
                            bannerOrientation = 0 + inwardYaw;
                            ++bannerXOffset;
                            break block4;
                        }
                    }
                    signOrientation = this.random.nextBoolean() ? 4 + inwardYaw : 0 - inwardYaw;
                    bannerOrientation = 0;
                }
            }
            signOrientation = (signOrientation + 16) % 16;
            bannerOrientation = (bannerOrientation + 16) % 16;
            int isWellCorner = 0;
            for (int x = i; x < i + 16; ++x) {
                for (int z = k; z < k + 16; ++z) {
                    int y = event.getWorld().func_175645_m(new BlockPos(x, 64, z)).func_177956_o();
                    if (y <= 1) continue;
                    Block id = event.getWorld().func_180495_p(new BlockPos(x, --y, z)).func_177230_c();
                    while (id.isAir(id.func_176194_O().func_177621_b(), (IBlockAccess)event.getWorld(), new BlockPos(x, y, z)) || id.isLeaves(id.func_176194_O().func_177621_b(), (IBlockAccess)event.getWorld(), new BlockPos(x, y, z))) {
                        id = event.getWorld().func_180495_p(new BlockPos(x, --y, z)).func_177230_c();
                    }
                    World world = event.getWorld();
                    BlockPos blockpos1 = new BlockPos(x, y - 4, z);
                    BlockPos blockpos2 = new BlockPos(x, y - 5, z);
                    BlockPos blockpos3 = new BlockPos(x, y - 6, z);
                    if (!id.isNormalCube(id.func_176194_O().func_177621_b(), (IBlockAccess)world, new BlockPos(x, y, z))) continue;
                    id = event.getWorld().func_180495_p(new BlockPos(x, y - 4, z)).func_177230_c();
                    Block id2 = event.getWorld().func_180495_p(new BlockPos(x, y - 5, z)).func_177230_c();
                    Block id3 = event.getWorld().func_180495_p(new BlockPos(x, y - 6, z)).func_177230_c();
                    if (!WellDecorateEvent.isWaterId(world, blockpos1) || !WellDecorateEvent.isWaterId(world, blockpos2) || !WellDecorateEvent.isWaterId(world, blockpos3)) continue;
                    int[] field = new int[]{x, y -= 4, z};
                    int[] field2 = new int[]{x, y - 1, z};
                    int[] field3 = new int[]{x, y - 2, z};
                    List<int[]> listWater = WellDecorateEvent.getBorder(event.getWorld(), id, field);
                    List<int[]> listWater2 = WellDecorateEvent.getBorder(event.getWorld(), id2, field2);
                    List<int[]> listWater3 = WellDecorateEvent.getBorder(event.getWorld(), id3, field3);
                    List<int[]> listOpaque = WellDecorateEvent.getOpaqueBorder(event.getWorld(), field);
                    if (listWater.size() != 3 || listWater2.size() != 3 || listWater3.size() != 3 || listOpaque.size() != 5) continue;
                    if (1 - Math.abs(++isWellCorner / 2 - 1) + (isWellCorner - 1) % 2 * 2 == signLocation) {
                        String[] newVillageName = NameGenerator.newRandomName("Village");
                        String headerTags = newVillageName[0];
                        String namePrefix = newVillageName[1];
                        String nameRoot = newVillageName[2];
                        String nameSuffix = newVillageName[3];
                        Block blockSignPlaceholder = event.getWorld().func_180495_p(new BlockPos(x + signXOffset, y + 2, z + signZOffset)).func_177230_c();
                        if (blockSignPlaceholder.isAir(blockSignPlaceholder.func_176194_O().func_177621_b(), (IBlockAccess)event.getWorld(), new BlockPos(x + signXOffset, y + 2, z + signZOffset)) || blockSignPlaceholder.isLeaves(blockSignPlaceholder.func_176194_O().func_177621_b(), (IBlockAccess)event.getWorld(), new BlockPos(x + signXOffset, y + 2, z + signZOffset))) {
                            MapGenStructureData structureData;
                            Object[] newRandomBanner = BannerGenerator.randomBannerArrays(-1);
                            ArrayList patternArray = (ArrayList)newRandomBanner[0];
                            ArrayList colorArray = (ArrayList)newRandomBanner[1];
                            ItemStack villageBanner = BannerGenerator.makeBanner(patternArray, colorArray);
                            int townColorMeta = 15 - (Integer)colorArray.get(0);
                            int signX = x + signXOffset;
                            int signY = y + 2;
                            int signZ = z + signZOffset;
                            int villageArea = -1;
                            NBTTagCompound nbttagcompound = null;
                            try {
                                structureData = (MapGenStructureData)event.getWorld().getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
                                nbttagcompound = structureData.func_143041_a();
                            }
                            catch (Exception e) {
                                try {
                                    structureData = (MapGenStructureData)event.getWorld().getPerWorldStorage().func_75742_a(MapGenStructureData.class, "OTGVillage");
                                    nbttagcompound = structureData.func_143041_a();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            try {
                                for (Object element0 : nbttagcompound.func_150296_c()) {
                                    NBTBase nbtbase = nbttagcompound.func_74781_a(element0.toString());
                                    if (nbtbase.func_74732_a() != 10) continue;
                                    try {
                                        NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                                        int[] boundingBox = nbttagcompound2.func_74759_k("BB");
                                        if (signX < boundingBox[0] || signY < boundingBox[1] || signZ < boundingBox[2] || signX > boundingBox[3] || signY > boundingBox[4] || signZ > boundingBox[5]) continue;
                                        int ChunkX = nbttagcompound2.func_74762_e("ChunkX");
                                        int ChunkZ = nbttagcompound2.func_74762_e("ChunkZ");
                                        villageArea = (boundingBox[3] - boundingBox[0]) * (boundingBox[3] - boundingBox[0]);
                                        if (GeneralConfig.debugMessages) {
                                            LogHelper.info("Village located at ChunkX: " + ChunkX + ", ChunkZ: " + ChunkZ + " with area " + villageArea);
                                        }
                                        signX = (boundingBox[0] + boundingBox[3]) / 2;
                                        signY = (boundingBox[1] + boundingBox[4]) / 2;
                                        signZ = (boundingBox[2] + boundingBox[5]) / 2;
                                    }
                                    catch (Exception e) {
                                        if (!GeneralConfig.debugMessages) continue;
                                        LogHelper.warn("Village bounding box could not be determined.");
                                    }
                                }
                            }
                            catch (Exception itr0) {
                                // empty catch block
                            }
                            int topLineRand = this.random.nextInt(4);
                            String topLine = "Welcome to";
                            if (topLineRand > 1) {
                                if (villageArea > 12000) {
                                    topLine = "City" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 5000) {
                                    topLine = "Town" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 2083) {
                                    topLine = "Village" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 868) {
                                    topLine = "Hamlet" + (topLineRand % 2 == 0 ? ":" : " of");
                                } else if (villageArea > 0) {
                                    topLine = "Outpost" + (topLineRand % 2 == 0 ? ":" : " of");
                                }
                            }
                            topLine = topLine.replaceAll("\\^", " ");
                            VNWorldDataStructure data = VNWorldDataStructure.forWorld(event.getWorld(), "villagenames3_Village", "NamedStructures");
                            NBTTagCompound tagCompound = data.getData();
                            Set tagmapKeyset = tagCompound.func_150296_c();
                            for (Object element : tagmapKeyset) {
                                int radiussearch;
                                int townZ;
                                int townY;
                                String townSignEntry = element.toString();
                                NBTTagCompound tagList = tagCompound.func_150295_c(townSignEntry, (int)tagCompound.func_74732_a()).func_150305_b(0);
                                int townX = tagList.func_74762_e("signX");
                                if ((signX - townX) * (signX - townX) + (signY - (townY = tagList.func_74762_e("signY"))) * (signY - townY) + (signZ - (townZ = tagList.func_74762_e("signZ"))) * (signZ - townZ) > (radiussearch = 32) * radiussearch) continue;
                                townColorMeta = tagList.func_74762_e("townColor");
                                namePrefix = tagList.func_74779_i("namePrefix");
                                nameRoot = tagList.func_74779_i("nameRoot");
                                nameSuffix = tagList.func_74779_i("nameSuffix");
                                break;
                            }
                            if (GeneralConfig.wellDecorations && GeneralConfig.nameSign && (!Loader.isModLoaded((String)"toroquest") || !GeneralConfig.TQVillageNames)) {
                                event.getWorld().func_175656_a(new BlockPos(x + signXOffset, y + 1, z + signZOffset), Blocks.field_150463_bK.func_176223_P());
                                event.getWorld().func_175656_a(new BlockPos(x + signXOffset, y + 2, z + signZOffset), Blocks.field_150472_an.func_176203_a(signOrientation));
                            }
                            if (GeneralConfig.wellDecorations && GeneralConfig.villageBanners && signLocation != bannerLocation) {
                                BlockPos bannerBasePos = new BlockPos(x + bannerXOffset, y + 1, z + bannerZOffset);
                                event.getWorld().func_175656_a(bannerBasePos, Blocks.field_150463_bK.func_176223_P());
                                event.getWorld().func_175656_a(bannerBasePos.func_177984_a(), Blocks.field_180393_cK.func_176203_a(bannerOrientation));
                                TileEntityBanner tilebanner = new TileEntityBanner();
                                villageBanner.func_151001_c((namePrefix + " " + nameRoot + " " + nameSuffix).trim() + " Banner");
                                tilebanner.func_175112_a(villageBanner, true);
                                event.getWorld().func_175690_a(bannerBasePos.func_177984_a(), (TileEntity)tilebanner);
                            }
                            if (GeneralConfig.wellDecorations && GeneralConfig.wellBoundary) {
                                if (GeneralConfig.concreteWell) {
                                    Block concreteBlock = Blocks.field_192443_dR;
                                    Block roofGlazedBlock = Blocks.field_192427_dB;
                                    switch (townColorMeta) {
                                        case 1: {
                                            roofGlazedBlock = Blocks.field_192428_dC;
                                            break;
                                        }
                                        case 2: {
                                            roofGlazedBlock = Blocks.field_192429_dD;
                                            break;
                                        }
                                        case 3: {
                                            roofGlazedBlock = Blocks.field_192430_dE;
                                            break;
                                        }
                                        case 4: {
                                            roofGlazedBlock = Blocks.field_192431_dF;
                                            break;
                                        }
                                        case 5: {
                                            roofGlazedBlock = Blocks.field_192432_dG;
                                            break;
                                        }
                                        case 6: {
                                            roofGlazedBlock = Blocks.field_192433_dH;
                                            break;
                                        }
                                        case 7: {
                                            roofGlazedBlock = Blocks.field_192434_dI;
                                            break;
                                        }
                                        case 8: {
                                            roofGlazedBlock = Blocks.field_192435_dJ;
                                            break;
                                        }
                                        case 9: {
                                            roofGlazedBlock = Blocks.field_192436_dK;
                                            break;
                                        }
                                        case 10: {
                                            roofGlazedBlock = Blocks.field_192437_dL;
                                            break;
                                        }
                                        case 11: {
                                            roofGlazedBlock = Blocks.field_192438_dM;
                                            break;
                                        }
                                        case 12: {
                                            roofGlazedBlock = Blocks.field_192439_dN;
                                            break;
                                        }
                                        case 13: {
                                            roofGlazedBlock = Blocks.field_192440_dO;
                                            break;
                                        }
                                        case 14: {
                                            roofGlazedBlock = Blocks.field_192441_dP;
                                            break;
                                        }
                                        case 15: {
                                            roofGlazedBlock = Blocks.field_192442_dQ;
                                        }
                                    }
                                    for (int pedY = y - 3; pedY <= y; ++pedY) {
                                        for (int rimi = 2; rimi > -3; --rimi) {
                                            event.getWorld().func_175656_a(new BlockPos(x + signXOffset / 2 * rimi, pedY, z + signZOffset), concreteBlock.func_176203_a(townColorMeta));
                                            event.getWorld().func_175656_a(new BlockPos(x + signXOffset, pedY, z + -signZOffset / 2 * (1 + rimi)), concreteBlock.func_176203_a(townColorMeta));
                                            event.getWorld().func_175656_a(new BlockPos(x - signXOffset * 3 / 2, pedY, z + signZOffset / 2 * rimi), concreteBlock.func_176203_a(townColorMeta));
                                            event.getWorld().func_175656_a(new BlockPos(x + -signXOffset / 2 * (1 + rimi), pedY, z - signZOffset * 3 / 2), concreteBlock.func_176203_a(townColorMeta));
                                        }
                                    }
                                    int metaSpin = this.random.nextInt(4) + 4;
                                    int metaChirality = this.random.nextBoolean() ? 1 : -1;
                                    event.getWorld().func_175656_a(new BlockPos(x, y + 4, z), roofGlazedBlock.func_176203_a(metaSpin % 4));
                                    event.getWorld().func_175656_a(new BlockPos(x, y + 4, z - signZOffset / 2), roofGlazedBlock.func_176203_a((metaSpin + metaChirality) % 4));
                                    event.getWorld().func_175656_a(new BlockPos(x - signXOffset / 2, y + 4, z - signZOffset / 2), roofGlazedBlock.func_176203_a((metaSpin + metaChirality * 2) % 4));
                                    event.getWorld().func_175656_a(new BlockPos(x - signXOffset / 2, y + 4, z), roofGlazedBlock.func_176203_a((metaSpin + metaChirality * 3) % 4));
                                } else {
                                    for (int pedY = y - 3; pedY <= y; ++pedY) {
                                        event.getWorld().func_175656_a(new BlockPos(x + signXOffset, pedY, z + signZOffset), Blocks.field_150406_ce.func_176203_a(townColorMeta));
                                    }
                                }
                            }
                            TileEntitySign signContents = new TileEntitySign();
                            if (namePrefix.length() + 1 + nameRoot.length() > 15) {
                                signContents.field_145915_a[0] = new TextComponentString(headerTags + topLine.trim());
                                signContents.field_145915_a[1] = new TextComponentString(namePrefix.trim());
                                if (nameRoot.length() + 1 + nameSuffix.length() > 15) {
                                    signContents.field_145915_a[2] = new TextComponentString(nameRoot.trim());
                                    signContents.field_145915_a[3] = new TextComponentString(nameSuffix.trim());
                                } else {
                                    signContents.field_145915_a[2] = new TextComponentString((nameRoot + " " + nameSuffix).trim());
                                }
                            } else if (namePrefix.length() + 1 + nameRoot.length() + 1 + nameSuffix.length() <= 15) {
                                signContents.field_145915_a[1] = new TextComponentString(headerTags + topLine);
                                signContents.field_145915_a[2] = new TextComponentString((namePrefix + " " + nameRoot + " " + nameSuffix).trim());
                            } else {
                                signContents.field_145915_a[1] = new TextComponentString(headerTags + topLine.trim());
                                signContents.field_145915_a[2] = new TextComponentString((namePrefix + " " + nameRoot).trim());
                                signContents.field_145915_a[3] = new TextComponentString(nameSuffix.trim());
                            }
                            if (topLine.equals("")) {
                                for (int isign = 0; isign < 3; ++isign) {
                                    signContents.field_145915_a[isign] = signContents.field_145915_a[isign + 1];
                                }
                                signContents.field_145915_a[3] = new TextComponentString("");
                            }
                            if (!Loader.isModLoaded((String)"toroquest") || !GeneralConfig.TQVillageNames) {
                                if (GeneralConfig.wellDecorations && GeneralConfig.nameSign) {
                                    event.getWorld().func_175690_a(new BlockPos(x + signXOffset, y + 2, z + signZOffset), (TileEntity)signContents);
                                }
                                NBTTagList nbttaglist = new NBTTagList();
                                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                                nbttagcompound1.func_74768_a("signX", signX);
                                nbttagcompound1.func_74768_a("signY", signY);
                                nbttagcompound1.func_74768_a("signZ", signZ);
                                nbttagcompound1.func_74768_a("townColor", townColorMeta);
                                nbttagcompound1.func_74778_a("namePrefix", namePrefix);
                                nbttagcompound1.func_74778_a("nameRoot", nameRoot);
                                nbttagcompound1.func_74778_a("nameSuffix", nameSuffix);
                                nbttagcompound1.func_74778_a("sign0", signContents.field_145915_a[0].func_150254_d());
                                nbttagcompound1.func_74778_a("sign1", signContents.field_145915_a[1].func_150254_d());
                                nbttagcompound1.func_74778_a("sign2", signContents.field_145915_a[2].func_150254_d());
                                nbttagcompound1.func_74778_a("sign3", signContents.field_145915_a[3].func_150254_d());
                                nbttagcompound1.func_74782_a("BlockEntityTag", (NBTBase)BannerGenerator.getNBTFromBanner(villageBanner));
                                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                                data.getData().func_74782_a((namePrefix + " " + nameRoot + " " + nameSuffix).trim() + ", x" + signX + " y" + signY + " z" + signZ, (NBTBase)nbttaglist);
                                data.func_76185_a();
                            }
                        } else {
                            int signX = x + signXOffset;
                            int signY = y + 2;
                            int signZ = z + signZOffset;
                            LogHelper.error("Tried to generate a sign inside a well's post at x=" + signX + " y=" + signY + " z=" + signZ);
                        }
                    }
                    if (GeneralConfig.wellDecorations && GeneralConfig.wellSlabs) {
                        field = listOpaque.remove(1);
                        event.getWorld().func_175656_a(new BlockPos(field[0], field[1] + 1, field[2]), Blocks.field_150333_U.func_176223_P());
                        field = listOpaque.remove(2);
                        event.getWorld().func_175656_a(new BlockPos(field[0], field[1] + 1, field[2]), Blocks.field_150333_U.func_176223_P());
                    }
                    while (event.getWorld().func_180495_p(new BlockPos(x, y, z)).func_177230_c() == id) {
                        --y;
                    }
                    field = new int[]{x, y, z};
                    listOpaque = WellDecorateEvent.getOpaqueBorder(event.getWorld(), field);
                }
            }
        }
        if (GeneralConfig.swampHutMushroomPot && !event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0 && event.getWorld().func_180494_b(new BlockPos(event.getChunkX() * 16 + 8, 0, event.getChunkZ() * 16 + 8)) == Biomes.field_76780_h) {
            this.searchHutAndReplacePot(event, 8);
        }
    }

    private static List<int[]> getOpaqueBorder(World world, int[] field) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int x = field[0] - 1; x < field[0] + 2; ++x) {
            for (int z = field[2] - 1; z < field[2] + 2; ++z) {
                Block borderBlock = world.func_180495_p(new BlockPos(x, field[1], z)).func_177230_c();
                if (x == field[0] && z == field[2] || !borderBlock.isNormalCube(borderBlock.func_176194_O().func_177621_b(), (IBlockAccess)world, new BlockPos(x, field[1], z))) continue;
                list.add(new int[]{x, field[1], z});
            }
        }
        return list;
    }

    private static List<int[]> getBorder(World world, Block id, int[] field) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int x = field[0] - 1; x < field[0] + 2; ++x) {
            for (int z = field[2] - 1; z < field[2] + 2; ++z) {
                if (x == field[0] && z == field[2] || world.func_180495_p(new BlockPos(x, field[1], z)).func_177230_c() != id) continue;
                list.add(new int[]{x, field[1], z});
            }
        }
        return list;
    }

    private static boolean isWaterId(World worldIn, BlockPos blockpos) {
        return worldIn.func_180495_p(blockpos).func_185904_a() == Material.field_151586_h;
    }

    public void searchHutAndReplacePot(PopulateChunkEvent.Post event, int buffer) {
        MapGenStructureData structureData = null;
        if (event.getWorld().field_73011_w.getDimension() == 0 && !event.getWorld().field_72995_K) {
            try {
                NBTTagCompound nbttagcompound = null;
                try {
                    structureData = (MapGenStructureData)event.getWorld().getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Temple");
                    nbttagcompound = structureData.func_143041_a();
                }
                catch (Exception e) {
                    try {
                        structureData = (MapGenStructureData)event.getWorld().getPerWorldStorage().func_75742_a(MapGenStructureData.class, "OTGTemple");
                        nbttagcompound = structureData.func_143041_a();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (Object element : nbttagcompound.func_150296_c()) {
                    NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                    if (nbtbase.func_74732_a() != 10) continue;
                    NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbtbase;
                    try {
                        int[] boundingBox = nbttagcompound2.func_74759_k("BB");
                        int xChunkCenter = event.getChunkX() << 4;
                        int zChunkCenter = event.getChunkZ() << 4;
                        if (xChunkCenter < boundingBox[0] - buffer || zChunkCenter < boundingBox[2] - buffer || xChunkCenter > boundingBox[3] + buffer || zChunkCenter > boundingBox[5] + buffer) continue;
                        for (int k = 50; k <= 80; ++k) {
                            for (int i = -16; i < 16; ++i) {
                                for (int j = -16; j < 16; ++j) {
                                    int potmeta;
                                    BlockPos potPos = new BlockPos((event.getChunkX() << 4) + i, k, (event.getChunkZ() << 4) + j);
                                    IBlockState iblockstate = event.getWorld().func_180495_p(potPos);
                                    Block blocktoscan = iblockstate.func_177230_c();
                                    if (blocktoscan != Blocks.field_150457_bL || (potmeta = blocktoscan.func_176201_c(iblockstate)) == 7) continue;
                                    TileEntity flowerPotWithRedMushroom = new BlockFlowerPot().func_149915_a(event.getWorld(), 7);
                                    event.getWorld().func_175656_a(potPos, Blocks.field_150457_bL.func_176223_P());
                                    event.getWorld().func_175690_a(potPos, flowerPotWithRedMushroom);
                                    if (GeneralConfig.debugMessages) {
                                        LogHelper.info("Updating swamp hut mushroom pot at " + (boundingBox[0] + boundingBox[3]) / 2 + " " + (boundingBox[2] + boundingBox[5]) / 2);
                                    }
                                    nbttagcompound2.func_74757_a("VNMushroomPotFixed", true);
                                    structureData.func_76186_a(true);
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!GeneralConfig.debugMessages) continue;
                        LogHelper.warn("Failed to evaluate Temple bounding box");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

