/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.advancements.ModTriggers;
import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.capabilities.ModularSkinProvider;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.handler.AdvancementReward;
import astrotibs.villagenames.handler.EntityInteractHandler;
import astrotibs.villagenames.handler.ReputationHandler;
import astrotibs.villagenames.network.MessageModernVillagerSkin;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import astrotibs.villagenames.network.NetworkHelper;
import astrotibs.villagenames.tracker.ClientInfoTracker;
import astrotibs.villagenames.tracker.EventTracker;
import astrotibs.villagenames.tracker.ServerInfoTracker;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityMonitorHandler {
    protected static int tickRate = 50;
    protected final int failuresToForceAcceptance = 100;

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityVillager && (event.getSource().func_76346_g() instanceof EntityZombieVillager || event.getSource().func_76346_g() instanceof EntityZombie)) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            ServerInfoTracker.add(villager, villager.field_70170_p);
            if (GeneralConfig.debugMessages) {
                LogHelper.info("EntityMonitorHandler > A zombie just killed villager " + (villager.func_95999_t().equals("") || villager.func_95999_t().equals(null) ? "(None)" : villager.func_95999_t()) + " [" + villager.func_145782_y() + "] at [" + new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v) + "], profession [" + villager.func_70946_n() + "]");
            }
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            IModularSkin ims;
            if (event.getTarget() instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)event.getTarget();
                ims = (IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
                NetworkHelper.sendModernVillagerSkinMessage(villager.func_145782_y(), ims, event.getEntityPlayer());
            }
            if (event.getTarget() instanceof EntityZombieVillager && !event.getEntity().field_70170_p.field_72995_K) {
                EntityZombieVillager zombievillager = (EntityZombieVillager)event.getTarget();
                ims = (IModularSkin)zombievillager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
                NetworkHelper.sendZombieVillagerProfessionMessage(zombievillager.func_145782_y(), ims, event.getEntityPlayer());
            } else if (event.getEntity().getClass().toString().substring(6).equals("com.emoniph.witchery.entity.EntityVillageGuard")) {
                EntityLiving guard = (EntityLiving)event.getTarget();
                ims = (IModularSkin)guard.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
                if (guard.hasCapability(ModularSkinProvider.MODULAR_SKIN, null)) {
                    NetworkHelper.sendVillageGuardMessage(guard.func_145782_y(), ims, event.getEntityPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityZombieVillager) {
            EntityZombieVillager zombievillager = (EntityZombieVillager)event.getEntity();
            IModularSkin ims = (IModularSkin)zombievillager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
            if (ims.getBiomeType() < 0) {
                ims.setBiomeType(FunctionsVN.returnBiomeTypeForEntityLocation((EntityLiving)zombievillager));
            }
            if (ims.getSkinTone() == -99) {
                ims.setSkinTone(FunctionsVN.returnSkinToneForEntityLocation((EntityLiving)zombievillager));
            }
            if (event.getWorld().field_72995_K) {
                ClientInfoTracker.SyncZombieMessage(zombievillager);
            } else {
                EventTracker tracked = ServerInfoTracker.seek(ServerInfoTracker.EventType.VILLAGER, new Vec3i(zombievillager.field_70165_t, zombievillager.field_70163_u + 0.5, zombievillager.field_70161_v), zombievillager.field_70170_p);
                if (tracked != null) {
                    if (GeneralConfig.debugMessages) {
                        LogHelper.info("EntityMonitorHandler > Found info on the tracker--must copy to zombie");
                    }
                    tracked.updateZombie(event, ims);
                } else if (ims.getProfession() == -1) {
                    if (GeneralConfig.debugMessages) {
                        LogHelper.info("EntityMonitorHandler > No info on the tracker--assigning a random profession");
                    }
                    int profession = zombievillager.field_70170_p.field_73012_v.nextInt(6);
                    ims.setProfession(profession);
                    ims.setCareer(FunctionsVN.pickRandomCareerForProfession(profession, new Random()));
                }
                if (GeneralConfig.debugMessages) {
                    LogHelper.info("EntityMonitorHandler > Custom name [" + zombievillager.func_95999_t() + "]");
                    LogHelper.info("EntityMonitorHandler > Profession [" + ims.getProfession() + "]");
                    LogHelper.info("EntityMonitorHandler > Career [" + ims.getCareer() + "]");
                    LogHelper.info("EntityMonitorHandler > ProfessionLevel [" + ims.getProfessionLevel() + "]");
                    LogHelper.info("EntityMonitorHandler > BiomeType [" + ims.getBiomeType() + "]");
                }
            }
        } else if (event.getEntity() instanceof EntityVillager) {
            IModularSkin ims;
            EntityVillager villager;
            block28: {
                villager = (EntityVillager)event.getEntity();
                FunctionsVN.modernizeVillagerTrades(villager);
                ims = (IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
                if (event.getWorld().field_72995_K) {
                    ClientInfoTracker.syncModernVillagerMessage(villager);
                } else {
                    MerchantRecipeList buyingList;
                    EventTracker tracked = ServerInfoTracker.seek(ServerInfoTracker.EventType.ZOMBIE, new Vec3i(villager.field_70165_t, villager.field_70163_u + 0.5, villager.field_70161_v), villager.field_70170_p);
                    if (tracked != null) {
                        if (GeneralConfig.debugMessages) {
                            LogHelper.info("EntityMonitorHandler > Found info on the tracker--must copy to villager");
                        }
                        tracked.updateVillager(villager, ims);
                        ServerInfoTracker.endedCuringZombie(tracked.getEntityID(), villager.func_145782_y(), villager.field_70170_p);
                        ServerInfoTracker.removeCuredZombiesFromTracker(event.getWorld(), tracked.getEntityID());
                    }
                    if ((buyingList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"buyingList", "field_70963_i"})) == null || buyingList.size() == 0) {
                        try {
                            Method populateBuyingList_m = ReflectionHelper.findMethod(EntityVillager.class, (String)"populateBuyingList", (String)"func_175554_cu", (Class[])new Class[0]);
                            populateBuyingList_m.invoke((Object)villager, new Object[0]);
                        }
                        catch (Exception e) {
                            if (!GeneralConfig.debugMessages) break block28;
                            LogHelper.warn("Could not invoke EntityVillager.populateBuyingList method");
                        }
                    } else {
                        for (int i = buyingList.size() - 1; i >= 0; --i) {
                            MerchantRecipe merchantrecipe = (MerchantRecipe)buyingList.get(i);
                            if (merchantrecipe.func_77394_a() != null && merchantrecipe.func_77394_a().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a) && merchantrecipe.func_77397_d() != null && merchantrecipe.func_77397_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a)) continue;
                            if (GeneralConfig.debugMessages) {
                                LogHelper.info("Removing illegal trade at index " + i);
                            }
                            buyingList.remove(i);
                        }
                    }
                }
            }
            if (ims.getProfession() == -1) {
                ims.setProfession(villager.func_70946_n());
            }
            if (ims.getCareer() == -1) {
                ims.setCareer((Integer)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"careerId", "field_175563_bv"}));
            }
            if (ims.getProfessionLevel() == -1) {
                ims.setProfessionLevel(0);
            }
            if (ims.getBiomeType() == -1) {
                ims.setBiomeType(FunctionsVN.returnBiomeTypeForEntityLocation((EntityLiving)villager));
            }
            if (ims.getSkinTone() == -99) {
                ims.setSkinTone(FunctionsVN.returnSkinToneForEntityLocation((EntityLiving)villager));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityZombieVillager) {
            EntityZombieVillager zombievillager = (EntityZombieVillager)event.getEntity();
            if (!zombievillager.field_70170_p.field_72995_K && zombievillager.func_82230_o()) {
                double checkfactor = 10.0;
                int vanillaRollbackTicks = 0;
                if ((double)zombievillager.field_70170_p.field_73012_v.nextFloat() < (double)0.01f * checkfactor) {
                    int countedBedsOrBars = 0;
                    for (int k = (int)zombievillager.field_70165_t - 4; k < (int)zombievillager.field_70165_t + 4 && countedBedsOrBars < 14; ++k) {
                        for (int l = (int)zombievillager.field_70163_u - 4; l < (int)zombievillager.field_70163_u + 4 && countedBedsOrBars < 14; ++l) {
                            for (int i1 = (int)zombievillager.field_70161_v - 4; i1 < (int)zombievillager.field_70161_v + 4 && countedBedsOrBars < 14; ++i1) {
                                Block block = zombievillager.field_70170_p.func_180495_p(new BlockPos(k, l, i1)).func_177230_c();
                                if (block != Blocks.field_150411_aY && block != Blocks.field_150324_C) continue;
                                if ((double)zombievillager.field_70170_p.field_73012_v.nextFloat() < (double)0.3f / checkfactor) {
                                    --vanillaRollbackTicks;
                                }
                                ++countedBedsOrBars;
                            }
                        }
                    }
                }
                Map<String, ArrayList> zombieCureCatalysts = GeneralConfig.unpackZombieCureCatalysts(GeneralConfig.zombieCureCatalysts);
                Map<String, ArrayList> zombieCureGroups = GeneralConfig.unpackZombieCureGroups(GeneralConfig.zombieCureGroups);
                int modTickAdjustment = 0;
                if ((double)zombievillager.field_70170_p.field_73012_v.nextFloat() < (double)0.01f * checkfactor) {
                    for (int groupi = 0; groupi < zombieCureGroups.get("Groups").size(); ++groupi) {
                        String group = (String)zombieCureGroups.get("Groups").get(groupi);
                        int groupLimit = (Integer)zombieCureGroups.get("Limits").get(groupi);
                        double groupSpeedup = (Double)zombieCureGroups.get("Speedups").get(groupi) / checkfactor;
                        int speedupSign = groupSpeedup < 0.0 ? -1 : 1;
                        groupSpeedup = Math.abs(groupSpeedup);
                        int countedGroupBlocks = 0;
                        for (int k = (int)zombievillager.field_70165_t - 4; k < (int)zombievillager.field_70165_t + 4 && countedGroupBlocks < groupLimit; ++k) {
                            for (int l = (int)zombievillager.field_70163_u - 4; l < (int)zombievillager.field_70163_u + 4 && countedGroupBlocks < groupLimit; ++l) {
                                block12: for (int i1 = (int)zombievillager.field_70161_v - 4; i1 < (int)zombievillager.field_70161_v + 4 && countedGroupBlocks < groupLimit; ++i1) {
                                    IBlockState blockState = zombievillager.field_70170_p.func_180495_p(new BlockPos(k, l, i1));
                                    Block block = blockState.func_177230_c();
                                    int blockmeta = block.func_176201_c(blockState);
                                    String blockClassPath = block.getClass().toString().substring(6);
                                    String blockUnlocName = block.func_149739_a();
                                    for (int blocki = 0; blocki < zombieCureCatalysts.get("Groups").size(); ++blocki) {
                                        String catalystGroup = (String)zombieCureCatalysts.get("Groups").get(blocki);
                                        String catalystClassPath = (String)zombieCureCatalysts.get("ClassPaths").get(blocki);
                                        String catalystUnlocName = (String)zombieCureCatalysts.get("UnlocNames").get(blocki);
                                        int catalystMeta = (Integer)zombieCureCatalysts.get("Metas").get(blocki);
                                        if (!catalystGroup.equals(group) || !catalystClassPath.equals(blockClassPath) || !catalystUnlocName.equals("") && !catalystUnlocName.equals(blockUnlocName) || catalystMeta != -1 && blockmeta != catalystMeta) continue;
                                        int i = 1;
                                        while ((double)i < groupSpeedup) {
                                            modTickAdjustment += speedupSign;
                                            ++i;
                                        }
                                        if ((double)zombievillager.field_70170_p.field_73012_v.nextFloat() < groupSpeedup % 1.0) {
                                            modTickAdjustment += speedupSign;
                                        }
                                        ++countedGroupBlocks;
                                        continue block12;
                                    }
                                }
                            }
                        }
                    }
                }
                if (GeneralConfig.debugMessages && (vanillaRollbackTicks != 0 || modTickAdjustment != 0)) {
                    LogHelper.info("Total tick adjustment: " + (vanillaRollbackTicks + modTickAdjustment));
                }
                int conversionTime = 0;
                try {
                    conversionTime = (Integer)ReflectionHelper.getPrivateValue(EntityZombieVillager.class, (Object)((EntityZombieVillager)event.getEntity()), (String[])new String[]{"conversionTime", "func_190735_dq"});
                    conversionTime -= vanillaRollbackTicks + modTickAdjustment;
                    conversionTime = MathHelper.func_76125_a((int)conversionTime, (int)1, (int)6000);
                    ReflectionHelper.setPrivateValue(EntityZombieVillager.class, (Object)((EntityZombieVillager)event.getEntity()), (Object)conversionTime, (String[])new String[]{"conversionTime", "func_190735_dq"});
                }
                catch (Exception group) {
                    // empty catch block
                }
                Method getConversionTimeBoost_m = ReflectionHelper.findMethod(EntityZombieVillager.class, (String)"getConversionProgress", (String)"func_190735_dq", (Class[])new Class[0]);
                int getConversionTimeBoost = 0;
                try {
                    getConversionTimeBoost = (Integer)getConversionTimeBoost_m.invoke((Object)((EntityZombieVillager)event.getEntity()), new Object[0]);
                }
                catch (Exception groupSpeedup) {
                    // empty catch block
                }
                int nextConversionTime = conversionTime - getConversionTimeBoost;
                if (GeneralConfig.debugMessages && nextConversionTime <= 500 && nextConversionTime % 20 == 0) {
                    LogHelper.info("EntityMonitorHandler > Zombie [" + zombievillager.func_145782_y() + "] being cured in " + conversionTime + " ticks");
                }
                if (nextConversionTime <= 0 && conversionTime > 0) {
                    if (GeneralConfig.debugMessages) {
                        LogHelper.info("EntityMonitorHandler > Zombie " + zombievillager.toString() + " is about to be cured in tick " + event.getEntity().func_184102_h().func_71259_af());
                    }
                    ServerInfoTracker.add(zombievillager, event.getEntity().field_70170_p);
                }
            }
            if (!zombievillager.field_70170_p.field_72995_K) {
                IModularSkin ims = (IModularSkin)zombievillager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
                if (ims.getBiomeType() == -1) {
                    ims.setBiomeType(FunctionsVN.returnBiomeTypeForEntityLocation((EntityLiving)zombievillager));
                }
                if (ims.getSkinTone() == -1) {
                    ims.setSkinTone(FunctionsVN.returnSkinToneForEntityLocation((EntityLiving)zombievillager));
                }
                zombievillager.func_98053_h(false);
                if (zombievillager.func_190630_a(EntityEquipmentSlot.CHEST)) {
                    zombievillager.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_190931_a));
                }
                if (zombievillager.func_190630_a(EntityEquipmentSlot.FEET)) {
                    zombievillager.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(Items.field_190931_a));
                }
                if (zombievillager.func_190630_a(EntityEquipmentSlot.HEAD)) {
                    zombievillager.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_190931_a));
                }
                if (zombievillager.func_190630_a(EntityEquipmentSlot.LEGS)) {
                    zombievillager.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(Items.field_190931_a));
                }
                if ((zombievillager.field_70173_aa + zombievillager.func_145782_y()) % 5 == 0) {
                    NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(zombievillager.field_71093_bK, zombievillager.field_70142_S, zombievillager.field_70137_T, zombievillager.field_70136_U, 80.0);
                    VillageNames.VNNetworkWrapper.sendToAllAround((IMessage)new MessageZombieVillagerProfession(zombievillager.func_145782_y(), ims.getProfession(), ims.getCareer(), ims.getBiomeType(), ims.getProfessionLevel(), ims.getSkinTone()), targetPoint);
                }
            }
        } else if (Loader.isModLoaded((String)"witchery") && event.getEntity() instanceof EntityLiving && event.getEntity().getClass().toString().substring(6).equals("com.emoniph.witchery.entity.EntityVillageGuard") && ServerInfoTracker.EventType.GUARD.getTracker().size() > 0) {
            EntityLiving guard = (EntityLiving)event.getEntity();
            if (event.getEntity().field_70170_p.field_72995_K) {
                ClientInfoTracker.SyncGuardMessage(guard);
            } else {
                EventTracker tracked = ServerInfoTracker.seek(ServerInfoTracker.EventType.GUARD, new Vec3i(guard.field_70165_t, guard.field_70163_u + 0.5, guard.field_70161_v), guard.field_70170_p);
                IModularSkin ims = (IModularSkin)guard.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
                if (tracked != null) {
                    if (GeneralConfig.debugMessages) {
                        LogHelper.info("EntityMonitorHandler > Found villager info on the tracker--must copy to guard");
                    }
                    tracked.updateGuard(event, ims);
                }
            }
        } else if (event.getEntity().getClass().toString().substring(6).equals("net.minecraft.entity.passive.EntityVillager") && !event.getEntity().field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            IModularSkin ims = (IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
            NBTTagCompound compound = new NBTTagCompound();
            villager.func_70014_b(compound);
            int profession = compound.func_74762_e("Profession");
            int career = compound.func_74762_e("Career");
            int careerLevel = compound.func_74762_e("CareerLevel");
            if (ims.getBiomeType() == -1) {
                ims.setBiomeType(FunctionsVN.returnBiomeTypeForEntityLocation((EntityLiving)villager));
            }
            if (ims.getSkinTone() == -99) {
                ims.setSkinTone(FunctionsVN.returnSkinToneForEntityLocation((EntityLiving)villager));
            }
            if ((villager.field_70173_aa + villager.func_145782_y()) % 5 == 0 && ims.getProfession() >= 0 && (ims.getProfession() <= 5 || GeneralConfig.professionID_a.indexOf(villager.getProfessionForge().getRegistryName().toString()) != -1)) {
                NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(villager.field_71093_bK, villager.field_70142_S, villager.field_70137_T, villager.field_70136_U, 80.0);
                VillageNames.VNNetworkWrapper.sendToAllAround((IMessage)new MessageModernVillagerSkin(villager.func_145782_y(), profession, career, ims.getBiomeType(), careerLevel, ims.getSkinTone()), targetPoint);
            }
        } else if (event.getEntity() instanceof EntityPlayerMP && !event.getEntity().field_70170_p.field_72995_K && event.getEntity().field_71093_bK == 0 && event.getEntity().field_70173_aa % tickRate == 0) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            World world = player.field_70170_p;
            try {
                String villageTopTagPlayerIsIn = ReputationHandler.getVillageTagPlayerIsIn(player);
                Village villageObjPlayerIsIn = world.func_175714_ae().func_176056_a(player.func_180425_c(), EntityInteractHandler.villageRadiusBuffer);
                if (!villageTopTagPlayerIsIn.equals("none") || villageObjPlayerIsIn != null) {
                    int playerRep = ReputationHandler.getVNReputationForPlayer(player, villageTopTagPlayerIsIn, villageObjPlayerIsIn);
                    if (playerRep <= -30 && !player.func_184102_h().func_184103_al().func_192054_h(player).func_192747_a(player.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation("villagenames:minrep"))).func_192105_a()) {
                        ModTriggers.MINREP.trigger(player);
                        AdvancementReward.allFiveAdvancements(player);
                    } else if (playerRep >= 10 && !player.func_184102_h().func_184103_al().func_192054_h(player).func_192747_a(player.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation("villagenames:maxrep"))).func_192105_a()) {
                        ModTriggers.MAXREP.trigger(player);
                        AdvancementReward.allFiveAdvancements(player);
                    }
                    if (tickRate < 50) {
                        tickRate += 2;
                    } else if (tickRate > 50) {
                        tickRate = 50;
                    }
                } else {
                    tickRate = 100;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

