/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class GolemConfigHandler {
    public static Configuration config;
    public static String[] golem_prefix;
    public static String[] golem_root_initial;
    public static String[] golem_root_syllables;
    public static String[] golem_root_terminal;
    public static String[] golem_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            GolemConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        golem_prefix = config.getString("Prefixes", "Golem Syllable Pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        golem_root_initial = config.getString("Root: Initial", "Golem Syllable Pool", "\u00c9, \u0130, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, A, Ae, Ba, Ba, Ba, Bha, Bi, Bri, Bu, Bu, Ca, Cha, Che, Chri, Co, Co, D, Da, Da, Do, Du, Du, E, E, E, E, E, E, E, Ei, Eu, Fe, Fe, Fra, Fre, Fre, Frie, Gau, Ge, Ge, Ge, Geo, Go, Ha, Ha, He, He, He, He, He, Hja, Ho, Hua, I, I, I, Ja, Je, Je, Je, Jea, Jo, Jo, Jo, Jo, Joe, Ju, Jua, Ka, Ka, Kha, Kle, Kro, Ku, L\u00e9, La, La, Lai, Le, Le, Le, Li, Li, Lou, Lou, Lu, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Ma, Me, Mi, Mo, Mu, Na, Naa, Ne, Ne, Ne, Ni, Ni, Ni, No, Nu, O, O, O, Ou, Pe, Po, Ra, Ro, Ro, Sa, Sa, Sa, Sa, Sa, Sa, Se, Shi, Si, Si, Ta, Te, Tha, The, The, Tho, Ti, U, Va, Va, Vai, Ve, Vi, Vi, Vla, Vu, Wa, Wi, Wi, Wi, Wi, Wi, Ya, Ya, Zeu", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        golem_root_syllables = config.getString("Root: Syllables", "Golem Syllable Pool", "be, be, bi, bra, bu, cchu, cho, cky, co, cto, da, de, de, de, dfrey, di, do, dra, dri, dwa, dwi, fre, ge, gha, hai, hi, hla, ho, ho, i, i, i, jo, ka, ke, ktha, la, la, lbe, lbre, lca, ldwi, le, le, lfri, lhe, li, li, li, li, li, li, lla, llia, llie, lma, lo, m\u00f3, ma, ma, ma, ma, mbi, mi, mi, mi, mi, mkhi, mo, my, mya, nchi, nci, nco, nda, ndi, ne, nghi, nri, nri, nry, nsto, nte, nu, o, o, o, o, o, o, o, o, pha, phi, phi, phro, po, po, r'e, ra, ra, ra, ra, ra, rdi, re, re, rga, rghe, ri, ri, ri, rma, rme, rmi, ro, ro, ro, rqui, rthu, rtli, ru, ry, s\u00e9, s\u00fa, sa, sca, se, se, sei, she, shi, shma, sme, sta, ste, ste, sto, su, ta, ta, te, the, ti, tla, to, tto, va, va, va, va, vi, vzi, xto, za, zi, zma, zra, a, a, a, bhbhai, bi, ca, co, de, di, do, do, do, do, e, e, e, e, e, e, e, e, e, e, e, e, fa, ha, hi, hmee, l\u00e9, la, li, llo, lo, lo, lpho, ly, ly, ma, ma, mi, msa, na, na, ngke, ni, ni, ni, ni, ni, ni, nna, o, o, o, ou, phe, po, po, rdi, ri, ri, ri, ri, ri, rta, sa, se, so, ta, tai, thy, ti, ti, try, tzky, ve, xa, xi, za, za, \u00f6, a, a, a, a, be, bha, da, e, e, ki, me, mu, na, nde, o, o, ri, si, te, tta, u, u, she, te, u, kia, sva, kia, ra", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        golem_root_terminal = config.getString("Root: Terminal", "Golem Syllable Pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, b, ch, cht, ck, d, d, d, g, h, h, h, hn, k, k, l, l, l, l, l, l, l, l, l, l, l, l, l, l, l, ld, ld, lls, lm, lt, m, m, m, m, m, m, m, m, m, m, m, mes, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, nd, ne, ng, nne, nne, p, ph, ph, r, r, r, r, r, r, r, r, r, rd, rd, re, rge, rke, rl, rles, rnst, rt, rt, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, s, se, t, t, th, th, x", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        golem_suffix = config.getString("Suffixes", "Golem Syllable Pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("Golem Syllable Pool", "Syllable Count Weighting", NamePiecesEntities.golem_syllable_count_weights, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "Golem Syllable Pool", golem_root_initial.length - 1 <= 0 ? 0.0f : ((float)golem_prefix.length - 1.0f) / (float)(golem_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "Golem Syllable Pool", golem_root_initial.length - 1 <= 0 ? 0.0f : ((float)golem_suffix.length - 1.0f) / (float)(golem_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

