/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.config.pieces;

import astrotibs.villagenames.name.NamePiecesEntities;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class DragonConfigHandler {
    public static Configuration config;
    public static String[] dragon_prefix;
    public static String[] dragon_root_initial;
    public static String[] dragon_root_syllables;
    public static String[] dragon_root_terminal;
    public static String[] dragon_suffix;
    public static float prefix_chance;
    public static float suffix_chance;
    public static int[] syllable_count_weighting;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            DragonConfigHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        dragon_prefix = config.getString("Prefixes", "Dragon Syllable Pool", "", "Prefixes that can occur before the core name.").trim().split("\\s*,\\s*");
        dragon_root_initial = config.getString("Root: Initial", "Dragon Syllable Pool", "A, A, A, A, A, A, A, A, Ai, B, Ba, Ba, Ba, Bo, Boi, Co, Co, Cu, Ddrai, Dr\u00e1, Dra, Dra, Dre, E, E, E, E, E, Fa, Go, Gui, Gyo, Hua, Hy, I, I, I, J\u00f6, Ku, Ku, Ku, L\u00f3, La, La, Le, Li, Lo, Mu, N\u00ed, Na, Nea, No, O, Ou, Pa, Py, Q', Qi, Que, Que, Ry, Ry, S\u00e1, Sei, Sli, Smo, Sy, Te, Te, The, Ti, Ti, Ty, Ve, Vi, Vri, Wy, Wy, Xiu, Ya, Yi, Yo, Za, Zbu, Zi, Zi, Zi, Zmei, Zo", "Core names begin with one of these half-syllables. Use _ to represent a space.").trim().split("\\s*,\\s*");
        dragon_root_syllables = config.getString("Root: Syllables", "Dragon Syllable Pool", "\u00e9, a, a, bi, bzu, ca, co, dh\u00f6, do, do, dra, fni, ga, ga, go, go, ha, jda, jde, ju, kha, ko, ku, ku, ku, la, la, lau, lbe, ldra, lla, llu, lshe, ma, mo, moo, ndwor, nglo, nglo, nri, nu, pa, pe, pho, po, ra, ra, re, re, re, rgo, rk\u00e1, rmu, rne, rni, ro, ro, ry, ryu, sha, shu, ta, ta, tho, tra, tza, tza, u, u, u, ve, ve, vi, vre, vre, za, zhi, _Ce, _Da, _Ja, _We, a, a, bo, chi, chi, dra, g\u00e4, gg, gi, ha, ji, la, lc\u00f3, lco, le, lka, ma, ma, mu, na, na, nga, ngba, nky, nsky, nsu, ny, ny, o, phi, q', rfl\u00f3, rha, ru, ssu, t\u00e1, ta, to, tra, ya, ze, a, a, bre, do, gu, ha, la, le, nd, nka, ro, t, tha, tso, u, wa, a, ka, ma, rmu, t, t", "Core names insert zero or more of these elements to build to their target lengths. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        dragon_root_terminal = config.getString("Root: Terminal", "Dragon Syllable Pool", "^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, ^, c, ch, g, ge, k, k, k, l, l, l, l, l, m, m, n, n, n, n, n, n, n, n, n, n, n, n, n, ng, ng, ng, ng, nt, nt, p, p, q, r, r, r, r, r, r, r, rm, rn, s, s, s, s, sque, t, t, t, t, t, tz", "Core names end with one of these half-syllables. Use _ to represent a space, and ^ for a blank entry.").trim().split("\\s*,\\s*");
        dragon_suffix = config.getString("Suffixes", "Dragon Syllable Pool", "", "Suffixes that can occur after the core name.").trim().split("\\s*,\\s*");
        syllable_count_weighting = config.get("Dragon Syllable Pool", "Syllable Count Weighting", NamePiecesEntities.dragon_syllable_count_weights, "How often core names of various lengths are generated. The number in the Nth row is the weighting for N-syllable names.").getIntList();
        prefix_chance = config.getFloat("Prefix Chance", "Dragon Syllable Pool", dragon_root_initial.length - 1 <= 0 ? 0.0f : ((float)dragon_prefix.length - 1.0f) / (float)(dragon_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a prefix.");
        suffix_chance = config.getFloat("Suffix Chance", "Dragon Syllable Pool", dragon_root_initial.length - 1 <= 0 ? 0.0f : ((float)dragon_suffix.length - 1.0f) / (float)(dragon_root_initial.length - 1), 0.0f, 1.0f, "The fraction of names that include a suffix.");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

