/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.client.model;

import astrotibs.villagenames.client.model.ModelPlane;
import astrotibs.villagenames.config.GeneralConfig;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelVillagerModern
extends ModelVillager {
    public ModelRenderer villagerHeadwear;
    public ModelRenderer villagerHatRimHigh;
    public ModelRenderer villagerHatRimLow;

    public ModelVillagerModern(float headScale) {
        this(headScale, 0.0f, 64, 64);
    }

    public ModelVillagerModern(float scale, float headPivotOffset, int textureFileWidth, int textureFileHeight) {
        super(scale, headPivotOffset, textureFileWidth, textureFileHeight);
        float headscaleOffset = 0.5f;
        this.villagerHeadwear = new ModelRenderer((ModelBase)this).func_78787_b(textureFileWidth, textureFileHeight);
        this.villagerHeadwear.func_78784_a(32, 0).func_78790_a(-4.0f, -10.0f, -4.0f, 8, 10, 8, scale + headscaleOffset);
        this.villagerHeadwear.func_78793_a(0.0f, 0.0f + headPivotOffset, 0.0f);
        this.villagerHatRimHigh = new ModelRenderer((ModelBase)this).func_78787_b(textureFileWidth, textureFileHeight);
        int rimHighTextureOffsetX = 15;
        int rimHighTextureOffsetY = 48;
        this.villagerHatRimHigh.func_78784_a(rimHighTextureOffsetX, rimHighTextureOffsetY);
        this.villagerHatRimHigh.field_78804_l.add(new ModelPlane(this.villagerHatRimHigh, rimHighTextureOffsetX, rimHighTextureOffsetY, -8.0f, -6.0f, -8.0f, 16, 0, 16, 0.0f));
        this.villagerHatRimHigh.func_78793_a(0.0f, 0.0f + headPivotOffset, 0.0f);
        this.villagerHatRimLow = new ModelRenderer((ModelBase)this).func_78787_b(textureFileWidth, textureFileHeight);
        int rimLowTextureOffsetX = 32;
        int rimLowTextureOffsetY = 48;
        this.villagerHatRimLow.func_78784_a(rimLowTextureOffsetX, rimLowTextureOffsetY);
        this.villagerHatRimLow.field_78804_l.add(new ModelPlane(this.villagerHatRimLow, rimLowTextureOffsetX, rimLowTextureOffsetY, -8.0f, -5.0f, -8.0f, 16, 0, 16, 0.0f));
        this.villagerHatRimLow.func_78793_a(0.0f, 0.0f + headPivotOffset, 0.0f);
    }

    public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        super.func_78087_a(f, f1, f2, f3, f4, f5, entity);
        this.villagerHeadwear.field_78796_g = this.field_78191_a.field_78796_g;
        this.villagerHeadwear.field_78795_f = this.field_78191_a.field_78795_f;
        this.villagerHatRimHigh.field_78796_g = this.field_78191_a.field_78796_g;
        this.villagerHatRimHigh.field_78795_f = this.field_78191_a.field_78795_f;
        this.villagerHatRimLow.field_78796_g = this.field_78191_a.field_78796_g;
        this.villagerHatRimLow.field_78795_f = this.field_78191_a.field_78795_f;
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        int prof = ((EntityVillager)entity).func_70946_n();
        String profForge = ((EntityVillager)entity).getProfessionForge().getRegistryName().toString();
        if (entity instanceof EntityVillager) {
            if (!(prof <= 5 || GeneralConfig.moddedVillagerHeadwearWhitelist.contains(profForge) || !GeneralConfig.moddedVillagerHeadwearBlacklist.contains("-" + profForge) && GeneralConfig.moddedVillagerHeadwear)) {
                return;
            }
            this.villagerHeadwear.func_78785_a(f5);
            this.villagerHatRimHigh.func_78785_a(f5);
            this.villagerHatRimLow.func_78785_a(f5);
        }
    }
}

