/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames;

import astrotibs.villagenames.advancements.ModTriggers;
import astrotibs.villagenames.block.ModBlocksVN;
import astrotibs.villagenames.client.renderer.entity.RenderVillagerModern;
import astrotibs.villagenames.client.renderer.entity.RenderZombieVillagerModern;
import astrotibs.villagenames.command.CommandBanner;
import astrotibs.villagenames.command.CommandName;
import astrotibs.villagenames.config.ConfigInit;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.handler.DevVersionWarning;
import astrotibs.villagenames.handler.EntityMonitorHandler;
import astrotibs.villagenames.handler.ReputationHandler;
import astrotibs.villagenames.handler.ServerCleanExpired;
import astrotibs.villagenames.handler.ServerTrackerStarter;
import astrotibs.villagenames.handler.VersionChecker;
import astrotibs.villagenames.handler.VillagerTradeHandler;
import astrotibs.villagenames.init.InventoryRender;
import astrotibs.villagenames.item.ModItems;
import astrotibs.villagenames.nbt.NBTUpdater;
import astrotibs.villagenames.network.MessageModernVillagerSkin;
import astrotibs.villagenames.network.MessageVillageGuard;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import astrotibs.villagenames.network.NetworkHelper;
import astrotibs.villagenames.proxy.CommonProxy;
import astrotibs.villagenames.utility.LogHelper;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="villagenames", name="Village Names", version="3.3.1", guiFactory="astrotibs.villagenames.config.gui.VNGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public final class VillageNames {
    @SidedProxy(clientSide="astrotibs.villagenames.proxy.ClientProxy", serverSide="astrotibs.villagenames.proxy.ServerProxy")
    public static CommonProxy PROXY;
    public static SimpleNetworkWrapper VNNetworkWrapper;
    public static File configDirectory;
    @Mod.Instance(value="villagenames")
    public static VillageNames instance;
    public static String currentConfigFolder;
    public static String[] oldConfigFolders;
    public static VersionChecker versionChecker;
    public static boolean haveWarnedVersionOutOfDate;
    public static boolean devVersionWarned;
    public static int numberStructuresArchaeologist;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDirectory = new File(event.getModConfigurationDirectory(), currentConfigFolder);
        ConfigInit.init(configDirectory);
        for (String oldConfigFolder : oldConfigFolders) {
            if (!new File(event.getModConfigurationDirectory(), oldConfigFolder).exists()) continue;
            LogHelper.warn("ATTENTION! The old configuration folder " + oldConfigFolder + " will NOT BE USED in this version of " + "Village Names" + "! A new " + currentConfigFolder + " folder has been created. Old config values HAVE NOT BEEN COPIED OVER.");
            LogHelper.warn("Remove the " + oldConfigFolder + " folder (save a backup!) to prevent this message in the future.");
            break;
        }
        ModItems.init();
        ModBlocksVN.init();
        MinecraftForge.EVENT_BUS.register((Object)new NBTUpdater());
        MinecraftForge.EVENT_BUS.register((Object)new ServerTrackerStarter());
        MinecraftForge.EVENT_BUS.register((Object)new EntityMonitorHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ServerCleanExpired());
        MinecraftForge.EVENT_BUS.register((Object)new ReputationHandler());
        if (GeneralConfig.versionChecker) {
            MinecraftForge.EVENT_BUS.register((Object)versionChecker);
        }
        if ("3.3.1".contains("DEV")) {
            MinecraftForge.EVENT_BUS.register((Object)new DevVersionWarning());
        }
        VNNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("vnChannel");
        int messageID = 0;
        VNNetworkWrapper.registerMessage(NetworkHelper.ZombieVillagerProfessionHandler.class, MessageZombieVillagerProfession.class, messageID++, Side.CLIENT);
        VNNetworkWrapper.registerMessage(NetworkHelper.VillageGuardHandler.class, MessageVillageGuard.class, messageID++, Side.CLIENT);
        VNNetworkWrapper.registerMessage(NetworkHelper.ModernVillagerSkinHandler.class, MessageModernVillagerSkin.class, messageID++, Side.CLIENT);
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().name = TextFormatting.GOLD + "Village Names";
        event.getModMetadata().version = TextFormatting.YELLOW + "3.3.1";
        event.getModMetadata().credits = TextFormatting.AQUA + "Thanks to Pahimar, MineMaarten, and Jabelar for their tutorials; to Darian Stephens for playtesting; and to whrrgarbl for her help and support.";
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.add(TextFormatting.BLUE + "AstroTibs");
        event.getModMetadata().url = "https://www.curseforge.com/minecraft/mc-mods/village-names";
        event.getModMetadata().description = TextFormatting.GREEN + "Generates random names for villages, villagers, and other structures and entities.";
        event.getModMetadata().logoFile = "assets/villagenames/vn_banner.png";
        if (GeneralConfig.treasureTrades) {
            VillagerRegistry.VillagerProfession professionLibrarian = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:librarian"));
            VillagerRegistry.VillagerCareer careerLibrarian = professionLibrarian.getCareer(0);
            VillagerRegistry.VillagerCareer careerCartographer = professionLibrarian.getCareer(1);
            if (GeneralConfig.treasureTrades && !GeneralConfig.modernVillagerTrades) {
                for (int i = 0; i < 3; ++i) {
                    EntityVillager.ITradeList[] iTradeListArray = new EntityVillager.ITradeList[1];
                    iTradeListArray[0] = new VillagerTradeHandler().new VillagerTradeHandler.LibrarianVN();
                    careerLibrarian.addTrade(i + 7, iTradeListArray);
                    EntityVillager.ITradeList[] iTradeListArray2 = new EntityVillager.ITradeList[1];
                    iTradeListArray2[0] = new VillagerTradeHandler().new VillagerTradeHandler.CartographerVN();
                    careerCartographer.addTrade(i + 4, iTradeListArray2);
                }
            }
        }
        if (GeneralConfig.modernVillagerTrades) {
            VillagerRegistry.VillagerProfession profBlacksmith = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:smith"));
            VillagerRegistry.VillagerCareer carMason = new VillagerRegistry.VillagerCareer(profBlacksmith, "mason");
            EntityVillager.ITradeList[] iTradeListArray = new EntityVillager.ITradeList[1];
            iTradeListArray[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonNovice();
            carMason.addTrade(1, iTradeListArray);
            EntityVillager.ITradeList[] iTradeListArray3 = new EntityVillager.ITradeList[1];
            iTradeListArray3[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonApprentice();
            carMason.addTrade(2, iTradeListArray3);
            EntityVillager.ITradeList[] iTradeListArray4 = new EntityVillager.ITradeList[1];
            iTradeListArray4[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonJourneyman();
            carMason.addTrade(3, iTradeListArray4);
            EntityVillager.ITradeList[] iTradeListArray5 = new EntityVillager.ITradeList[1];
            iTradeListArray5[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonExpert();
            carMason.addTrade(4, iTradeListArray5);
            EntityVillager.ITradeList[] iTradeListArray6 = new EntityVillager.ITradeList[1];
            iTradeListArray6[0] = new VillagerTradeHandler().new VillagerTradeHandler.MasonMaster();
            carMason.addTrade(5, iTradeListArray6);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (event.getSide() == Side.CLIENT) {
            InventoryRender.init();
        }
        ModTriggers.registerTriggers();
        PROXY.init(event);
        if (event.getSide() == Side.CLIENT && GeneralConfig.modernVillagerSkins) {
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.remove(EntityVillager.class);
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.put(EntityVillager.class, new RenderVillagerModern(Minecraft.func_71410_x().func_175598_ae()));
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.remove(EntityZombieVillager.class);
            Minecraft.func_71410_x().func_175598_ae().field_78729_o.put(EntityZombieVillager.class, new RenderZombieVillagerModern(Minecraft.func_71410_x().func_175598_ae()));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandName());
        event.registerServerCommand((ICommand)new CommandBanner());
    }

    static {
        currentConfigFolder = "VillageNames4";
        oldConfigFolders = new String[]{"VillageNames3", "VillageNames"};
        versionChecker = new VersionChecker();
        haveWarnedVersionOutOfDate = false;
        devVersionWarned = false;
        numberStructuresArchaeologist = 7;
    }
}

