/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.beneath;

import com.shinoow.beneath.common.CommonProxy;
import com.shinoow.beneath.common.block.BlockTeleporterDeepDank;
import com.shinoow.beneath.common.block.tile.TileEntityTeleporterDeepDank;
import com.shinoow.beneath.common.command.CommandReload;
import com.shinoow.beneath.common.entity.EntityHand;
import com.shinoow.beneath.common.entity.EntityShadow;
import com.shinoow.beneath.common.handler.BeneathEventHandler;
import com.shinoow.beneath.common.handler.BlockDecorationHandler;
import com.shinoow.beneath.common.handler.OreGenHandler;
import com.shinoow.beneath.common.network.PacketDispatcher;
import com.shinoow.beneath.common.world.WorldProviderDeepDank;
import com.shinoow.beneath.common.world.biome.BiomeDeepDank;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="beneath", name="The Beneath", version="1.7.0", dependencies="required-after:forge@[14.23.0.2491,);after:grue@[1.3.4,)", acceptedMinecraftVersions="[1.12]", guiFactory="com.shinoow.beneath.client.config.BeneathGuiFactory", useMetadata=false, updateJSON="https://raw.githubusercontent.com/Shinoow/The-Beneath/master/version.json", certificateFingerprint="220f10d3a93b3ff5fbaa7434cc629d863d6751b9")
public class Beneath {
    public static final String version = "1.7.0";
    public static final String modid = "beneath";
    public static final String name = "The Beneath";
    @Mod.Metadata(value="beneath")
    public static ModMetadata metadata;
    @Mod.Instance(value="beneath")
    public static Beneath instance;
    @SidedProxy(clientSide="com.shinoow.beneath.client.ClientProxy", serverSide="com.shinoow.beneath.common.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration cfg;
    static int startEntityId;
    public static int dim;
    public static int darkTimer;
    public static int darkDamage;
    public static int dungeonChance;
    public static int shadowSpawnWeight;
    public static int lakeChance;
    public static int stalactiteChance;
    public static int stalagmiteChance;
    public static String mode;
    public static String stoneBlock;
    public static boolean internalOreGen;
    public static boolean keepLoaded;
    public static boolean dimTeleportation;
    public static boolean disableMobSpawning;
    public static boolean useCraftingRecipe;
    public static boolean teleportTorches;
    public static boolean useDecorator;
    public static boolean shadowHand;
    public static boolean otherModWorldgen;
    public static double red;
    public static double green;
    public static double blue;
    public static double damageMultiplier;
    public static double healthMultiplier;
    private static String[] craftingRecipe;
    private static String[] fluidBlocks;
    public static List<Block> fluid_blocks;
    public static Biome deep_dank;
    public static DimensionType deep_dank_dim;
    public static Block teleporter;
    public static DamageSource darkness;
    public static SoundEvent beneath_normal;
    public static SoundEvent beneath_muffled;
    public static SoundEvent beneath_drawnout;
    public static SoundEvent deepdank;
    public static SoundEvent dark1;
    public static SoundEvent dark2;
    public static SoundEvent scream;
    public static final ResourceLocation shadow_loot_table;
    public static IBlockState STONE;
    public static Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        Beneath.metadata.description = Beneath.metadata.description + "\n\n\u00a76Supporters: " + this.getSupporterList() + "\u00a7r";
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new BeneathEventHandler());
        cfg = new Configuration(new File(event.getModConfigurationDirectory(), "/beneath/beneath.cfg"));
        Beneath.syncConfig();
        cfg.setCategoryComment("general", "CONFIG ALL THE THINGS! Any changes take effect after a Minecraft restart (though some can take effect immediately, with weird results).");
        deep_dank = new BiomeDeepDank();
        deep_dank_dim = DimensionType.register((String)name, (String)"_tb", (int)dim, WorldProviderDeepDank.class, (boolean)keepLoaded);
        DimensionManager.registerDimension((int)dim, (DimensionType)deep_dank_dim);
        teleporter = new BlockTeleporterDeepDank();
        GameRegistry.registerTileEntity(TileEntityTeleporterDeepDank.class, (String)"tileEntityTeleporterBeneath");
        beneath_normal = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "beneath.normal")).setRegistryName(new ResourceLocation(modid, "beneath.normal"));
        beneath_muffled = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "beneath.muffled")).setRegistryName(new ResourceLocation(modid, "beneath.muffled"));
        beneath_drawnout = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "beneath.drawnout")).setRegistryName(new ResourceLocation(modid, "beneath.drawnout"));
        deepdank = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "deepdank")).setRegistryName(new ResourceLocation(modid, "deepdank"));
        dark1 = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "dark1")).setRegistryName(new ResourceLocation(modid, "dark1"));
        dark2 = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "dark2")).setRegistryName(new ResourceLocation(modid, "dark2"));
        scream = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "scream")).setRegistryName(new ResourceLocation(modid, "scream"));
        Beneath.registerEntityWithEgg(EntityShadow.class, "shadow", 1, 80, 3, true, 0, 0);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, "hand"), EntityHand.class, (String)"hand", (int)2, (Object)instance, (int)80, (int)3, (boolean)true);
        if (mode.equalsIgnoreCase("grue")) {
            FMLInterModComms.sendMessage((String)"grue", (String)"registerDimensionWhitelistOverride", (String)String.valueOf(dim));
        }
        PacketDispatcher.registerPackets();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (internalOreGen) {
            OreGenHandler.setupOregenFile();
            OreGenHandler.saveOregenFile();
        }
        if (useDecorator) {
            BlockDecorationHandler.setupBlockDecoFile();
            BlockDecorationHandler.saveBlockDecoFile();
        }
        fluid_blocks = Arrays.stream(fluidBlocks).map(s -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s.trim()))).filter(b -> b != null).collect(Collectors.toList());
        this.updateTerrainBlock();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ((BiomeDeepDank)deep_dank).setSpawnLists();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandReload());
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.log(Level.WARN, "Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(modid)) {
            Beneath.syncConfig();
            fluid_blocks = Arrays.stream(fluidBlocks).map(s -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s))).filter(b -> b != null).collect(Collectors.toList());
            this.updateTerrainBlock();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(teleporter.setRegistryName(new ResourceLocation(modid, "teleporterbeneath")));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBlock(teleporter).setRegistryName(new ResourceLocation(modid, "teleporterbeneath")));
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(deep_dank.setRegistryName(new ResourceLocation(modid, "the_beneath")));
        BiomeDictionary.addTypes((Biome)deep_dank, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD});
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry reg = event.getRegistry();
        reg.register((IForgeRegistryEntry)beneath_normal);
        reg.register((IForgeRegistryEntry)beneath_muffled);
        reg.register((IForgeRegistryEntry)beneath_drawnout);
        reg.register((IForgeRegistryEntry)deepdank);
        reg.register((IForgeRegistryEntry)dark1);
        reg.register((IForgeRegistryEntry)dark2);
        reg.register((IForgeRegistryEntry)scream);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (useCraftingRecipe) {
            event.getRegistry().register((IForgeRegistryEntry)this.createCraftingRecipe(craftingRecipe));
        }
    }

    private static void syncConfig() {
        dim = cfg.get("general", "Dimension ID", 10, "Dimension ID for The Beneath.").getInt();
        mode = cfg.get("general", "Mode", Loader.isModLoaded((String)"grue") ? "grue" : "darkness", "What mode The Beneath is set to. Current modes are:\ngrue: Grues spawn in the darkness\ndarkness: You take damage while in dark areas.\nnone: Disables darkness damage\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getString();
        internalOreGen = cfg.get("general", "Internal Ore Generator", true, "Toggles whether or not to use the built-in Ore Generator. Can be disabled if you have another mod that handles Ore Generation.\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        keepLoaded = cfg.get("general", "Keep Loaded", false, "Toggles whether or not The Beneath should be prevented from automatically unloading (might affect performance if enabled).\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        dimTeleportation = cfg.get("general", "Additional Dimension Teleportation", false, "Toggles whether or not to allow teleporting back and forth between the Beneath and dimensions that aren't the Overworld").getBoolean();
        darkTimer = cfg.get("general", "Darkness damage timer", 5, "The amount of seconds before the darkness damages you (when the mode is set to darkness).\n[range: 1 ~ 10, default: 5]", 1, 10).getInt();
        darkDamage = cfg.get("general", "Darkness damage", 2, "The amount of damage (half hearts) you take from the darkness (when the mode is set to darkness).\n[range: 2 ~ 20, default: 2]", 2, 20).getInt();
        dungeonChance = cfg.get("general", "Dungeon spawn chance", 8, "The chance that a dungeon generates in The Beneath (same logic as the vanilla setting). Setting it to 0 stops dungeon generation.\n[range: 0 ~ 100, default: 8]", 0, 100).getInt();
        shadowSpawnWeight = cfg.get("general", "Shadow Spawn Weight", 50, "Spawn Weight for the shadows, increase to increase the chance of them spawning, or decrease to decrease the chance of them spawning.\n[range: 10 ~ 100, default: 50]", 10, 100).getInt();
        disableMobSpawning = cfg.get("general", "Disable Mob Spawning", false, "Toggles whether or not to stop mob spawning inside The Beneath.").getBoolean();
        useCraftingRecipe = cfg.get("general", "Use Crafting Recipe", false, "Toggles whether or not to use the configurable crafting recipe.\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        craftingRecipe = cfg.get("general", "Beneath Teleporter Crafting Recipe", new String[]{"#&#", "&%&", "#&#", "#", "minecraft:stone:*", "&", "cobblestone", "%", "minecraft:nether_star"}, "Configurable crafting recipe for the Beneath Teleporter.\nThe first 3 Strings in the array are the recipe formula, where each symbol represents an Item. The Items are defined by the character being in the array before the Item in question (check the default).\nFormat for Items: modid:name:meta (where meta is optional, and * can be used to speficy the metadata wildcard). The OreDictionary can also be used, where you just specify the ore name (ingotIron for Iron Ingots, stone for Stone)\n" + TextFormatting.RED + "[Only used if Use Crafting Recipe is enabled]" + TextFormatting.RESET).getStringList();
        red = cfg.get("general", "Red Night Vision sky color", 1.1, "Changes the red part of the Beneath sky color while affected by Night Vision. Client side only.\n[range: 0.0 ~ 10.0, default: 1.1]", 0.0, 10.0).getDouble();
        green = cfg.get("general", "Green Night Vision sky color", 0.0, "Changes the green part of the Beneath sky color while affected by Night Vision. Client side only.\n[range: 0.0 ~ 10.0, default: 0.0]", 0.0, 10.0).getDouble();
        blue = cfg.get("general", "Blue Night Vision sky color", 1.5, "Changes the red part of the Beneath sky color while affected by Night Vision. Client side only.\n[range: 0.0 ~ 10.0, default: 1.5]", 0.0, 10.0).getDouble();
        teleportTorches = cfg.get("general", "Teleporter Torches", true, "Whether or not torches should spawn on the platform generated when entering The Beneath.").getBoolean();
        damageMultiplier = cfg.get("general", "Damage Multiplier", 2.0, "Sets how much mob damage is multiplied by inside The Beneath\n[range: 1.0 ~ 10.0, default: 2.0]", 1.0, 10.0).getDouble();
        healthMultiplier = cfg.get("general", "Health Multiplier", 2.0, "Sets how much mob health is multiplied by inside The Beneath\n[range: 1.0 ~ 10.0, default: 2.0]", 1.0, 10.0).getDouble();
        fluidBlocks = cfg.get("general", "Lake Fluid Blocks", new String[]{"minecraft:water", "minecraft:lava"}, "Any fluid blocks added to this list will randomly generate as part of lakes inside The Beneath (format is \"modid:name\")\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getStringList();
        lakeChance = cfg.get("general", "Lake spawn chance", 10, "The chance that a lake generates in The Beneath (same logic as the vanilla setting). Setting it to 0 stops lake generation\n[range: 0 ~ 100, default: 10]", 0, 100).getInt();
        useDecorator = cfg.get("general", "Use Block Decorator", true, "Toggles whether or not to use the built-in Block Decorator (functions like the Ore Generator, except it runs before it, and is intended for things like dirt, gravel, stone types).\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        stalactiteChance = cfg.get("general", "Stalactite spawn chance", 20, "The chance that a stalactite generates in The Beneath (higher number increases the chance, lower decreases it). Setting it to 0 stops stalactite generation\\n[range: 0 ~ 100, default: 20]", 0, 100).getInt();
        stalagmiteChance = cfg.get("general", "Stalagmite spawn chance", 20, "The chance that a stalagmite generates in The Beneath (higher number increases the chance, lower decreases it). Setting it to 0 stops stalagmite generation\\n[range: 0 ~ 100, default: 20]", 0, 100).getInt();
        shadowHand = cfg.get("general", "Shadow Hands", true, "Toggles whether or not shadows will be able to drag you into the dark with their hands.").getBoolean();
        otherModWorldgen = cfg.get("general", "Other Mod World Generation", false, "Toggles whether or not other mods should be able to interfere with the terrain generation of The Beneath.").getBoolean();
        stoneBlock = cfg.get("general", "Terrain Block", "minecraft:stone", "This determines which block the terrain of The Beneath should be made out of. If you want it to be something other than stone, you can change this instead of jerry-rigging the block decorator to replace all stone.\nFormat is \"modid:name:meta\", where meta is optional\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getString();
        darkTimer = MathHelper.func_76125_a((int)darkTimer, (int)1, (int)10);
        darkDamage = MathHelper.func_76125_a((int)darkDamage, (int)2, (int)20);
        shadowSpawnWeight = MathHelper.func_76125_a((int)shadowSpawnWeight, (int)10, (int)100);
        red = MathHelper.func_151237_a((double)red, (double)0.0, (double)10.0);
        green = MathHelper.func_151237_a((double)green, (double)0.0, (double)10.0);
        blue = MathHelper.func_151237_a((double)blue, (double)0.0, (double)10.0);
        damageMultiplier = MathHelper.func_151237_a((double)damageMultiplier, (double)1.0, (double)10.0);
        healthMultiplier = MathHelper.func_151237_a((double)healthMultiplier, (double)1.0, (double)10.0);
        stalactiteChance = MathHelper.func_76125_a((int)stalactiteChance, (int)0, (int)100);
        stalagmiteChance = MathHelper.func_76125_a((int)stalagmiteChance, (int)0, (int)100);
        if (mode.equalsIgnoreCase("grue") && !Loader.isModLoaded((String)"grue")) {
            mode = "darkness";
        }
        if (!(mode.equalsIgnoreCase("grue") || mode.equalsIgnoreCase("darkness") || mode.equalsIgnoreCase("none"))) {
            mode = "darkness";
        }
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private static void registerEntityWithEgg(Class<? extends Entity> entity, String name, int modid, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, name), entity, (String)("beneath." + name), (int)modid, (Object)instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
    }

    private IRecipe createCraftingRecipe(String[] data) {
        Object[] recipe = new Object[data.length];
        recipe[0] = data[0];
        recipe[1] = data[1];
        recipe[2] = data[2];
        for (int i = 3; i < data.length; ++i) {
            recipe[i] = this.getObject(data[i]);
        }
        return (IRecipe)new ShapedOreRecipe(null, teleporter, recipe).setRegistryName(new ResourceLocation(modid, "beneath_teleporter"));
    }

    private Object getObject(String data) {
        if (data.length() == 1) {
            return Character.valueOf(data.charAt(0));
        }
        if (data.lastIndexOf(":") == -1) {
            return data;
        }
        String[] stuff = data.split(":");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
        if (item == null) {
            return null;
        }
        int meta = stuff.length == 3 ? (stuff[2].equals("*") ? Short.MAX_VALUE : Integer.valueOf(stuff[2])) : 0;
        return new ItemStack(item, 1, meta);
    }

    private void updateTerrainBlock() {
        try {
            String[] parts = stoneBlock.split(":");
            STONE = parts.length == 3 ? ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]))).func_176203_a(Integer.valueOf(parts[2]).intValue()) : ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stoneBlock))).func_176223_P();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "{} is not a valid block, defaulting to minecraft:stone", (Object)stoneBlock);
            STONE = Blocks.field_150348_b.func_176223_P();
        }
        Beneath.deep_dank.field_76752_A = STONE;
        Beneath.deep_dank.field_76753_B = STONE;
    }

    private String getSupporterList() {
        String names = "";
        try {
            BufferedReader nameFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/supporters.txt").openStream()));
            names = nameFile.readLine();
            nameFile.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Failed to fetch supporter list, using local version!");
            names = "Tedyhere";
        }
        return names;
    }

    static {
        instance = new Beneath();
        startEntityId = 200;
        fluid_blocks = new ArrayList<Block>();
        darkness = new DamageSource("darkness").func_76348_h();
        shadow_loot_table = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(modid, "entities/shadow"));
        LOGGER = LogManager.getLogger((String)name);
    }
}

