/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public class ECUtils {
    private static final TreeMap<Integer, String> ROMAN_NUMERALS = new TreeMap();

    public static JsonElement getInternalJsonData(String path) throws IOException {
        JsonElement rawData = null;
        try (InputStream inputStream = ECUtils.class.getClassLoader().getResourceAsStream(path);){
            rawData = new JsonParser().parse((Reader)new InputStreamReader(inputStream, "UTF-8"));
        }
        return rawData;
    }

    public static JsonElement getExternalJsonData(String path) throws IOException {
        JsonElement rawData = null;
        try (FileInputStream inputStream = new FileInputStream(new File(path));){
            rawData = new JsonParser().parse((Reader)new InputStreamReader((InputStream)inputStream, "UTF-8"));
        }
        return rawData;
    }

    public static void createExternalJsonFile(String path, JsonElement data) throws IOException {
        try (FileWriter writer = new FileWriter(path);){
            new GsonBuilder().setPrettyPrinting().create().toJson(data, (Appendable)writer);
        }
    }

    public static void createAbsoluteJsonCopy(String path, InputStream source) throws IOException {
        List fileData;
        try (InputStream inputStream = source;){
            fileData = IOUtils.readLines((Reader)new InputStreamReader(inputStream, "UTF-8"));
        }
        if (fileData != null) {
            var4_3 = null;
            try (PrintStream printStream = new PrintStream(new File(path));){
                for (String line : fileData) {
                    printStream.println(line);
                }
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
        }
    }

    public static String toRomanNumeral(int number) {
        if (number == 0) {
            return "0";
        }
        if (number < 0) {
            return "-" + ECUtils.toRomanNumeral(number * -1);
        }
        int l = ROMAN_NUMERALS.floorKey(number);
        if (number == l) {
            return ROMAN_NUMERALS.get(number);
        }
        return ROMAN_NUMERALS.get(l) + ECUtils.toRomanNumeral(number - l);
    }

    static {
        ROMAN_NUMERALS.put(1000, "M");
        ROMAN_NUMERALS.put(900, "CM");
        ROMAN_NUMERALS.put(500, "D");
        ROMAN_NUMERALS.put(400, "CD");
        ROMAN_NUMERALS.put(100, "C");
        ROMAN_NUMERALS.put(90, "XC");
        ROMAN_NUMERALS.put(50, "L");
        ROMAN_NUMERALS.put(40, "XL");
        ROMAN_NUMERALS.put(10, "X");
        ROMAN_NUMERALS.put(9, "IX");
        ROMAN_NUMERALS.put(5, "V");
        ROMAN_NUMERALS.put(4, "IV");
        ROMAN_NUMERALS.put(1, "I");
    }
}

