/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.enchantment;

import austeretony.enchcontrol.common.main.ECMain;
import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class EnchantmentWrapper {
    private static final Map<ResourceLocation, EnchantmentWrapper> WRAPPERS = new HashMap<ResourceLocation, EnchantmentWrapper>();
    public static final Set<EnchantmentWrapper> UNKNOWN = new HashSet<EnchantmentWrapper>();
    public final ResourceLocation registryName;
    public final String modid;
    public final String resourceName;
    private boolean enabled;
    private boolean hideOnItem;
    private boolean hideOnBook;
    private boolean initialized;
    private boolean customEvals;
    private boolean isTreasure;
    private boolean doublePrice;
    private boolean isCurse;
    private boolean isAllowedOnBooks;
    private boolean hasIncompat;
    private boolean hasItemsList;
    private boolean hasDesc;
    private boolean temporaryDesc;
    private String name;
    private String minEnchEval;
    private String maxEnchEval;
    private String rarityStr;
    private String typeStr;
    private int[][] enchantability;
    private Enchantment.Rarity rarity;
    private int minLevel;
    private int maxLevel;
    private int incompatMode;
    private int applicabilityMode;
    private int listMode;
    private EnumEnchantmentType type;
    private EntityEquipmentSlot[] equipmentSlots;
    private Set<ResourceLocation> incompatibleEnchants;
    private Set<ResourceLocation> itemsList;
    private String[] equipmentSlotsStrs;
    private String[] description;
    private Enchantment wrapped;

    private EnchantmentWrapper(ResourceLocation registryName) {
        this.registryName = registryName;
        this.modid = registryName.func_110624_b();
        this.resourceName = registryName.func_110623_a();
        WRAPPERS.put(registryName, this);
    }

    public static EnchantmentWrapper create(ResourceLocation registryName, boolean isEnabled, String name, int minLevel, int maxLevel) {
        EnchantmentWrapper wrapper = new EnchantmentWrapper(registryName);
        wrapper.setEnabled(isEnabled);
        wrapper.setName(name);
        wrapper.setMinLevel(minLevel);
        wrapper.setMaxLevel(maxLevel);
        return wrapper;
    }

    public static Collection<EnchantmentWrapper> getWrappers() {
        return WRAPPERS.values();
    }

    public static EnchantmentWrapper get(Enchantment enchantment) {
        EnchantmentWrapper wrapper;
        ResourceLocation registryName = enchantment.getRegistryName();
        if (!WRAPPERS.containsKey(registryName)) {
            wrapper = EnchantmentWrapper.create(registryName, true, enchantment.func_77320_a(), enchantment.func_77319_d(), enchantment.func_77325_b());
            wrapper.setEquipmentSlots(enchantment.field_185263_a);
            wrapper.setRarity(enchantment.field_77333_a);
            wrapper.setType(enchantment.field_77351_y);
            wrapper.initialized = true;
            wrapper.setMinEnchantabilityEvaluation("1+LVL*10");
            wrapper.setMaxEnchantabilityEvaluation("MIN+5");
            wrapper.setTreasure(enchantment.func_185261_e());
            wrapper.setDoublePrice(enchantment.func_185261_e());
            wrapper.setCurse(enchantment.func_190936_d());
            wrapper.setAllowedOnBooks(enchantment.isAllowedOnBooks());
            wrapper.setEnchantment(enchantment);
            wrapper.calculateEnchantability();
            UNKNOWN.add(wrapper);
            ECMain.LOGGER.info("Unknown enchantment <{}>. Data collected.", (Object)registryName);
        } else {
            wrapper = WRAPPERS.get(registryName);
            if (!wrapper.initialized) {
                EnumEnchantmentType type;
                Enchantment.Rarity rarity;
                wrapper.initialized = true;
                if (!wrapper.isEnabled()) {
                    ECMain.LOGGER.info("Enchantment <{}> disabled! It can't be obtained in survival mode.", (Object)registryName);
                }
                wrapper.setEquipmentSlots(EnchantmentWrapper.initEquipmentSlots(wrapper.getEnumEquipmentSlotsStrings()));
                try {
                    rarity = Enchantment.Rarity.valueOf((String)wrapper.getRarityString());
                }
                catch (IllegalArgumentException exception) {
                    ECMain.LOGGER.error("Unknown enchantment rarity: <{}>! Default value will be used: <{}>.", (Object)wrapper.getRarityString(), (Object)enchantment.field_77333_a);
                    rarity = enchantment.field_77333_a;
                }
                wrapper.setRarity(rarity);
                try {
                    type = EnumEnchantmentType.valueOf((String)wrapper.getTypeString());
                }
                catch (IllegalArgumentException exception) {
                    ECMain.LOGGER.error("Unknown enchantment type: <{}>! Default value will be used: <{}>.", (Object)wrapper.getTypeString(), (Object)(enchantment.field_77351_y == null ? "NULL" : enchantment.field_77351_y));
                    type = enchantment.field_77351_y;
                }
                wrapper.setType(type);
                enchantment.field_185263_a = wrapper.getEquipmentSlots();
                enchantment.field_77333_a = wrapper.getRarity();
                enchantment.field_77351_y = wrapper.getType();
                wrapper.setEnchantment(enchantment);
                wrapper.calculateEnchantability();
                ECMain.LOGGER.info("Initialized enchantment <{}> with config settings.", (Object)registryName);
            }
        }
        return wrapper;
    }

    public static EntityEquipmentSlot[] initEquipmentSlots(String[] slotsStr) {
        if (slotsStr.length == 0) {
            return EntityEquipmentSlot.values();
        }
        EntityEquipmentSlot[] slots = new EntityEquipmentSlot[slotsStr.length];
        int i = 0;
        for (String slotStr : slotsStr) {
            if (slotStr.equals("ALL")) {
                return EntityEquipmentSlot.values();
            }
            try {
                slots[i] = EntityEquipmentSlot.valueOf((String)slotStr);
            }
            catch (IllegalArgumentException exception) {
                ECMain.LOGGER.error("Unknown enchantment equipment slot: <{}>! Default value <MAINHAND> will be used.", (Object)slotStr);
                slots[i] = EntityEquipmentSlot.MAINHAND;
            }
            ++i;
        }
        return slots;
    }

    public static void clearData() {
        WRAPPERS.clear();
        UNKNOWN.clear();
    }

    public Enchantment getEnchantment() {
        return this.wrapped;
    }

    public void setEnchantment(Enchantment enchantment) {
        this.wrapped = enchantment;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public boolean shouldHideOnItem() {
        return this.hideOnItem;
    }

    public void setHideOnItem(boolean flag) {
        this.hideOnItem = flag;
    }

    public boolean shouldHideOnBook() {
        return this.hideOnBook;
    }

    public void setHideOnBook(boolean flag) {
        this.hideOnBook = flag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void calculateEnchantability() {
        this.enchantability = new int[this.maxLevel - this.minLevel + 1][2];
        if (this.customEvals) {
            this.calcMinEnchantabilityCustom(this.minEnchEval);
            this.calcMaxEnchantabilityCustom(this.maxEnchEval);
        } else {
            for (int i = this.minLevel; i <= this.maxLevel; ++i) {
                this.enchantability[i - this.minLevel][0] = this.wrapped.func_77321_a(i);
                this.enchantability[i - this.minLevel][1] = this.wrapped.func_77317_b(i);
            }
        }
    }

    public boolean useCustomEvals() {
        return this.customEvals;
    }

    public void setCustomEvals(boolean flag) {
        this.customEvals = flag;
    }

    public int getMinEnchantability(int enchantmentLevel) {
        return this.enchantability[enchantmentLevel - this.minLevel][0];
    }

    public String getMinEnchantabilityEval() {
        return this.minEnchEval;
    }

    public void setMinEnchantabilityEvaluation(String eval) {
        this.minEnchEval = eval;
    }

    private void calcMinEnchantabilityCustom(String eval) {
        if (eval.isEmpty()) {
            eval = "1+LVL*10";
        }
        for (int i = this.minLevel; i <= this.maxLevel; ++i) {
            BigDecimal currLvl = BigDecimal.valueOf(i);
            BigDecimal result = new Expression(eval).with("LVL", currLvl).eval();
            this.enchantability[i - this.minLevel][0] = result.intValue();
        }
    }

    public int getMaxEnchantability(int enchantmentLevel) {
        return this.enchantability[enchantmentLevel - this.minLevel][1];
    }

    public String getMaxEnchantabilityEval() {
        return this.maxEnchEval;
    }

    public void setMaxEnchantabilityEvaluation(String eval) {
        this.maxEnchEval = eval;
    }

    private void calcMaxEnchantabilityCustom(String eval) {
        if (eval.isEmpty()) {
            eval = "MIN+5";
        }
        for (int i = this.minLevel; i <= this.maxLevel; ++i) {
            BigDecimal minEnch = BigDecimal.valueOf(this.getMinEnchantability(i));
            BigDecimal currLvl = BigDecimal.valueOf(i);
            BigDecimal result = new Expression(eval).with("MIN", minEnch).and("LVL", currLvl).eval();
            this.enchantability[i - this.minLevel][1] = result.intValue();
        }
    }

    public Enchantment.Rarity getRarity() {
        return this.rarity;
    }

    public void setRarity(Enchantment.Rarity rarity) {
        this.rarity = rarity;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public void setMinLevel(int value) {
        this.minLevel = value;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int value) {
        this.maxLevel = value;
    }

    public void initEnumEquipmentSlotsStrings(int size) {
        this.equipmentSlotsStrs = new String[size];
    }

    public String[] getEnumEquipmentSlotsStrings() {
        return this.equipmentSlotsStrs;
    }

    public String getRarityString() {
        return this.rarityStr;
    }

    public void setEnumRarityString(String typeStr) {
        this.rarityStr = typeStr;
    }

    public String getTypeString() {
        return this.typeStr;
    }

    public void setEnumTypeString(String typeStr) {
        this.typeStr = typeStr;
    }

    public EnumEnchantmentType getType() {
        return this.type;
    }

    public void setType(EnumEnchantmentType type) {
        this.type = type;
    }

    public EntityEquipmentSlot[] getEquipmentSlots() {
        return this.equipmentSlots;
    }

    public void setEquipmentSlots(EntityEquipmentSlot[] slots) {
        this.equipmentSlots = slots;
    }

    public int getIncompatMode() {
        return this.incompatMode;
    }

    public void setIncompatMode(int value) {
        this.incompatMode = MathHelper.func_76125_a((int)value, (int)0, (int)1);
    }

    public boolean hasIncompatibleEnchantments() {
        return this.hasIncompat;
    }

    public Set<ResourceLocation> getIncompatibleEnchantments() {
        return this.incompatibleEnchants;
    }

    public void addIncompatibleEnchantment(ResourceLocation registryName) {
        if (!this.hasIncompat) {
            this.hasIncompat = true;
            this.incompatibleEnchants = new HashSet<ResourceLocation>();
        }
        this.incompatibleEnchants.add(registryName);
    }

    private boolean isEnchantmentExist(ResourceLocation registryName) {
        return this.hasIncompat && this.incompatibleEnchants.contains(registryName);
    }

    public boolean isCompatibleWith(Enchantment enchantment) {
        return this.incompatMode == 0 ? this.wrapped.func_191560_c(enchantment) && !this.isEnchantmentExist(enchantment.getRegistryName()) : !this.isEnchantmentExist(enchantment.getRegistryName());
    }

    public int getApplicabilityMode() {
        return this.applicabilityMode;
    }

    public void setApplicabilityMode(int value) {
        this.applicabilityMode = MathHelper.func_76125_a((int)value, (int)0, (int)1);
    }

    public int getListMode() {
        return this.listMode;
    }

    public void setListMode(int value) {
        this.listMode = MathHelper.func_76125_a((int)value, (int)0, (int)1);
    }

    public boolean hasItemList() {
        return this.hasItemsList;
    }

    public Set<ResourceLocation> getItemList() {
        return this.itemsList;
    }

    public void addItem(ResourceLocation registryName) {
        if (!this.hasItemsList) {
            this.hasItemsList = true;
            this.itemsList = new HashSet<ResourceLocation>();
        }
        this.itemsList.add(registryName);
    }

    private boolean isItemExist(ItemStack itemStack) {
        return this.hasItemsList && this.itemsList.contains(itemStack.func_77973_b().getRegistryName());
    }

    public boolean canApply(ItemStack itemStack) {
        return this.applicabilityMode == 0 ? this.wrapped.func_92089_a(itemStack) && (this.listMode > 0 ? this.isItemExist(itemStack) : !this.isItemExist(itemStack)) : (this.listMode > 0 ? this.isItemExist(itemStack) : !this.isItemExist(itemStack));
    }

    public boolean isTreasure() {
        return this.isTreasure;
    }

    public void setTreasure(boolean flag) {
        this.isTreasure = flag;
    }

    public boolean shouldDoublePrice() {
        return this.doublePrice;
    }

    public void setDoublePrice(boolean flag) {
        this.doublePrice = flag;
    }

    public boolean isCurse() {
        return this.isCurse;
    }

    public void setCurse(boolean flag) {
        this.isCurse = flag;
    }

    public boolean isAllowedOnBooks() {
        return this.isAllowedOnBooks;
    }

    public void setAllowedOnBooks(boolean flag) {
        this.isAllowedOnBooks = flag;
    }

    public void initDescription(int size) {
        this.description = new String[size];
        this.hasDesc = true;
    }

    public boolean hasDescription() {
        return this.hasDesc;
    }

    public String[] getDescription() {
        return this.description;
    }

    public boolean isTemporaryDescription() {
        return this.temporaryDesc;
    }

    public void setTemporaryDescription() {
        this.temporaryDesc = true;
    }
}

