/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.core;

import austeretony.enchcontrol.common.config.EnumConfigSettings;
import austeretony.enchcontrol.common.core.ECCorePlugin;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public enum EnumInputClass {
    MC_LOCALE("Minecraft", "Locale", 0, 3),
    MC_ENCHANTMENT("Minecraft", "Enchantment", 0, 3),
    MC_ENCHANTMENT_HELPER("Minecraft", "EnchantmentHelper", 0, 3),
    MC_LIST_ENCHANTED_BOOK_FOR_EMERALDS("Minecraft", "ListEnchantedBookForEmeralds", 0, 3),
    MC_ENCHANT_RANDOMLY("Minecraft", "EnchantRandomly", 0, 3),
    MC_COMMAND_ENCHANT("Minecraft", "CommandEnchant", 0, 3),
    MC_ITEM_ENCHANTED_BOOK("Minecraft", "ItemEnchantedBook", 0, 3),
    MC_CONTAINER_REPAIR("Minecraft", "ContainerRepair", 0, 3),
    MC_ITEM_STACK("Minecraft", "ItemStack", 0, 3),
    TE_ENCHANTER_MANAGER("Thermal Expansion", "EnchanterManager", 0, 3);

    private static final String HOOKS_CLASS = "austeretony/enchcontrol/common/core/ECHooks";
    public final String domain;
    public final String clazz;
    public final int readerFlags;
    public final int writerFlags;

    private EnumInputClass(String domain, String clazz, int readerFlags, int writerFlags) {
        this.domain = domain;
        this.clazz = clazz;
        this.readerFlags = readerFlags;
        this.writerFlags = writerFlags;
    }

    public boolean patch(ClassNode classNode) {
        switch (this) {
            case MC_LOCALE: {
                return this.pathcMCLocale(classNode);
            }
            case MC_ENCHANTMENT: {
                return this.pathcMCEnchantment(classNode);
            }
            case MC_ENCHANTMENT_HELPER: {
                return this.pathcMCEnchantmentHelper(classNode);
            }
            case MC_LIST_ENCHANTED_BOOK_FOR_EMERALDS: {
                return this.pathcMCListEnchantedBookForEmeralds(classNode);
            }
            case MC_ENCHANT_RANDOMLY: {
                return this.pathcMCEnchantRandomly(classNode);
            }
            case MC_COMMAND_ENCHANT: {
                return this.pathcMCCommandEnchant(classNode);
            }
            case MC_ITEM_ENCHANTED_BOOK: {
                return this.pathcMCItemEnchantedBook(classNode);
            }
            case MC_CONTAINER_REPAIR: {
                return this.pathcMCContainerRepair(classNode);
            }
            case MC_ITEM_STACK: {
                return this.pathcMCItemStack(classNode);
            }
            case TE_ENCHANTER_MANAGER: {
                return EnumConfigSettings.SUPPORT_THERMAL_EXPANSION.isEnabled() && this.pathcTEEnchanterManager(classNode);
            }
        }
        return false;
    }

    private boolean pathcMCLocale(ClassNode classNode) {
        String propertiesFieldName = ECCorePlugin.isObfuscated() ? "a" : "properties";
        String loadLocaleDataFilesMethodName = ECCorePlugin.isObfuscated() ? "a" : "loadLocaleDataFiles";
        String localeClassName = ECCorePlugin.isObfuscated() ? "cfb" : "net/minecraft/client/resources/Locale";
        String iResourceManagerClassName = ECCorePlugin.isObfuscated() ? "cep" : "net/minecraft/client/resources/IResourceManager";
        String listClassName = "java/util/List";
        String mapClassName = "java/util/Map";
        boolean isSuccessful = false;
        int invokespecialCount = 0;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(loadLocaleDataFilesMethodName) || !methodNode.desc.equals("(L" + iResourceManagerClassName + ";L" + listClassName + ";)V")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 183 || ++invokespecialCount != 3) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                nodesList.add((AbstractInsnNode)new FieldInsnNode(180, localeClassName, propertiesFieldName, "L" + mapClassName + ";"));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "loadCustomLocalization", "(L" + listClassName + ";L" + mapClassName + ";)V", false));
                methodNode.instructions.insertBefore(currentInsn.getPrevious(), nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean pathcMCEnchantment(ClassNode classNode) {
        String getTranslatedNameMethodName = ECCorePlugin.isObfuscated() ? "d" : "getTranslatedName";
        String enchantmentClassName = ECCorePlugin.isObfuscated() ? "alk" : "net/minecraft/enchantment/Enchantment";
        String stringClassName = "java/lang/String";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(getTranslatedNameMethodName) || !methodNode.desc.equals("(I)L" + stringClassName + ";")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 25) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                nodesList.add((AbstractInsnNode)new VarInsnNode(21, 1));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getTranslatedName", "(L" + enchantmentClassName + ";I)L" + stringClassName + ";", false));
                nodesList.add((AbstractInsnNode)new InsnNode(176));
                methodNode.instructions.insertBefore(currentInsn, nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean pathcMCEnchantmentHelper(ClassNode classNode) {
        String removeIncompatibleMethodName = ECCorePlugin.isObfuscated() ? "a" : "removeIncompatible";
        String getEnchantmentDatasMethodName = ECCorePlugin.isObfuscated() ? "a" : "getEnchantmentDatas";
        String enchantmentDataClassName = ECCorePlugin.isObfuscated() ? "aln" : "net/minecraft/enchantment/EnchantmentData";
        String itemStackClassName = ECCorePlugin.isObfuscated() ? "aip" : "net/minecraft/item/ItemStack";
        String listClassName = "java/util/List";
        boolean isSuccessful0 = false;
        boolean isSuccessful1 = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            InsnList nodesList;
            if (methodNode.name.equals(removeIncompatibleMethodName) && methodNode.desc.equals("(L" + listClassName + ";L" + enchantmentDataClassName + ";)V")) {
                for (AbstractInsnNode currentInsn : methodNode.instructions) {
                    if (currentInsn.getOpcode() != 25) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "removeIncompatible", "(L" + listClassName + ";L" + enchantmentDataClassName + ";)V", false));
                    nodesList.add((AbstractInsnNode)new InsnNode(177));
                    methodNode.instructions.insertBefore(currentInsn, nodesList);
                    isSuccessful0 = true;
                }
            }
            if (!methodNode.name.equals(getEnchantmentDatasMethodName) || !methodNode.desc.equals("(IL" + itemStackClassName + ";Z)L" + listClassName + ";")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 184) continue;
                nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(21, 0));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                nodesList.add((AbstractInsnNode)new VarInsnNode(21, 2));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getEnchantmentDatas", "(IL" + itemStackClassName + ";Z)L" + listClassName + ";", false));
                nodesList.add((AbstractInsnNode)new InsnNode(176));
                methodNode.instructions.insertBefore(currentInsn, nodesList);
                isSuccessful1 = true;
                break block0;
            }
        }
        return isSuccessful0 && isSuccessful1;
    }

    private boolean pathcMCListEnchantedBookForEmeralds(ClassNode classNode) {
        String addMerchantRecipeMethodName = ECCorePlugin.isObfuscated() ? "a" : "addMerchantRecipe";
        String enchantmentClassName = ECCorePlugin.isObfuscated() ? "alk" : "net/minecraft/enchantment/Enchantment";
        String merchantRecipeListClassName = ECCorePlugin.isObfuscated() ? "amh" : "net/minecraft/village/MerchantRecipeList";
        String randomClassName = "java/util/Random";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(addMerchantRecipeMethodName)) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 178) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "addMerchantRecipe", "(L" + merchantRecipeListClassName + ";L" + randomClassName + ";)V", false));
                nodesList.add((AbstractInsnNode)new InsnNode(177));
                methodNode.instructions.insertBefore(currentInsn, nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean pathcMCEnchantRandomly(ClassNode classNode) {
        String enchantmentsFieldName = ECCorePlugin.isObfuscated() ? "b" : "enchantments";
        String loggerFieldName = ECCorePlugin.isObfuscated() ? "a" : "LOGGER";
        String applyMethodName = ECCorePlugin.isObfuscated() ? "a" : "apply";
        String itemStackClassName = ECCorePlugin.isObfuscated() ? "aip" : "net/minecraft/item/ItemStack";
        String enchantRandomlyClassName = ECCorePlugin.isObfuscated() ? "bfx" : "net/minecraft/world/storage/loot/functions/EnchantRandomly";
        String randomClassName = "java/util/Random";
        String listClassName = "java/util/List";
        String loggerClassName = "org/apache/logging/log4j/Logger";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(applyMethodName)) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 25) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                nodesList.add((AbstractInsnNode)new FieldInsnNode(180, enchantRandomlyClassName, enchantmentsFieldName, "L" + listClassName + ";"));
                nodesList.add((AbstractInsnNode)new FieldInsnNode(178, enchantRandomlyClassName, loggerFieldName, "L" + loggerClassName + ";"));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "apply", "(L" + itemStackClassName + ";L" + randomClassName + ";L" + listClassName + ";L" + loggerClassName + ";)L" + itemStackClassName + ";", false));
                nodesList.add((AbstractInsnNode)new InsnNode(176));
                methodNode.instructions.insertBefore(currentInsn, nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean pathcMCCommandEnchant(ClassNode classNode) {
        String executeMethodName = ECCorePlugin.isObfuscated() ? "a" : "execute";
        String minecraftServerClassName = "net/minecraft/server/MinecraftServer";
        String iCommandSenderClassName = ECCorePlugin.isObfuscated() ? "bn" : "net/minecraft/command/ICommandSender";
        String itemStackClassName = ECCorePlugin.isObfuscated() ? "aip" : "net/minecraft/item/ItemStack";
        String enchantmentClassName = ECCorePlugin.isObfuscated() ? "alk" : "net/minecraft/enchantment/Enchantment";
        String entityLivingBaseClassName = ECCorePlugin.isObfuscated() ? "vp" : "net/minecraft/entity/EntityLivingBase";
        String commandEnchantClassName = ECCorePlugin.isObfuscated() ? "cd" : "net/minecraft/command/CommandEnchant";
        String stringClassName = "java/lang/String";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(executeMethodName) || !methodNode.desc.equals("(L" + minecraftServerClassName + ";L" + iCommandSenderClassName + ";[L" + stringClassName + ";)V")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 54) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 4));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 5));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "execute", "(L" + commandEnchantClassName + ";L" + entityLivingBaseClassName + ";L" + enchantmentClassName + ";L" + iCommandSenderClassName + ";[L" + stringClassName + ";)V", false));
                nodesList.add((AbstractInsnNode)new InsnNode(177));
                methodNode.instructions.insertBefore(currentInsn.getPrevious(), nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean pathcMCItemEnchantedBook(ClassNode classNode) {
        String addInformationMethodName = ECCorePlugin.isObfuscated() ? "a" : "addInformation";
        String getSubItemsMethodName = ECCorePlugin.isObfuscated() ? "a" : "getSubItems";
        String creativeTabsClassName = ECCorePlugin.isObfuscated() ? "ahp" : "net/minecraft/creativetab/CreativeTabs";
        String nonNullListClassName = ECCorePlugin.isObfuscated() ? "fi" : "net/minecraft/util/NonNullList";
        String itemStackClassName = ECCorePlugin.isObfuscated() ? "aip" : "net/minecraft/item/ItemStack";
        String worldClassName = ECCorePlugin.isObfuscated() ? "amu" : "net/minecraft/world/World";
        String iTooltipFlagClassName = ECCorePlugin.isObfuscated() ? "akb" : "net/minecraft/client/util/ITooltipFlag";
        String listClassName = "java/util/List";
        boolean isSuccessful0 = false;
        boolean isSuccessful1 = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            InsnList nodesList;
            if (methodNode.name.equals(addInformationMethodName) && methodNode.desc.equals("(L" + itemStackClassName + ";L" + worldClassName + ";L" + listClassName + ";L" + iTooltipFlagClassName + ";)V")) {
                for (AbstractInsnNode currentInsn : methodNode.instructions) {
                    if (currentInsn.getOpcode() != 183) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new InsnNode(3));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                    nodesList.add((AbstractInsnNode)new InsnNode(4));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "modifyItemStackTooltip", "(IL" + itemStackClassName + ";L" + listClassName + ";Z)V", false));
                    nodesList.add((AbstractInsnNode)new InsnNode(177));
                    methodNode.instructions.insert(currentInsn, nodesList);
                    isSuccessful0 = true;
                }
            }
            if (!methodNode.name.equals(getSubItemsMethodName) || !methodNode.desc.equals("(L" + creativeTabsClassName + ";L" + nonNullListClassName + ";)V")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 25) continue;
                nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "getSubItems", "(L" + creativeTabsClassName + ";L" + nonNullListClassName + ";)V", false));
                nodesList.add((AbstractInsnNode)new InsnNode(177));
                methodNode.instructions.insertBefore(currentInsn, nodesList);
                isSuccessful1 = true;
                break block0;
            }
        }
        return isSuccessful0 && isSuccessful1;
    }

    private boolean pathcMCContainerRepair(ClassNode classNode) {
        String updateRepairOutputMethodName = ECCorePlugin.isObfuscated() ? "e" : "updateRepairOutput";
        String enchantmentClassName = ECCorePlugin.isObfuscated() ? "alk" : "net/minecraft/enchantment/Enchantment";
        String itemStackClassName = ECCorePlugin.isObfuscated() ? "aip" : "net/minecraft/item/ItemStack";
        boolean isSuccessful0 = false;
        boolean isSuccessful1 = false;
        boolean isSuccessful2 = false;
        boolean isSuccessful3 = false;
        int istoreCount = 0;
        int ifneCount = 0;
        int invokestaticCount = 0;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(updateRepairOutputMethodName) || !methodNode.desc.equals("()V")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                InsnList nodesList;
                if (currentInsn.getOpcode() == 54) {
                    if (++istoreCount != 22) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 13));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "canApply", "(L" + enchantmentClassName + ";L" + itemStackClassName + ";)Z", false));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(54, 16));
                    methodNode.instructions.insert(currentInsn, nodesList);
                    isSuccessful0 = true;
                    continue;
                }
                if (currentInsn.getOpcode() == 154) {
                    if (++ifneCount != 8) continue;
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 18));
                    nodesList.add((AbstractInsnNode)new VarInsnNode(25, 13));
                    nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isCompatibleWith", "(L" + enchantmentClassName + ";L" + enchantmentClassName + ";)Z", false));
                    methodNode.instructions.insertBefore(currentInsn.getPrevious().getPrevious().getPrevious(), nodesList);
                    methodNode.instructions.remove(currentInsn.getPrevious().getPrevious().getPrevious());
                    methodNode.instructions.remove(currentInsn.getPrevious().getPrevious());
                    methodNode.instructions.remove(currentInsn.getPrevious());
                    isSuccessful1 = true;
                    continue;
                }
                if (currentInsn.getOpcode() == 164) {
                    nodesList = new InsnList();
                    nodesList.add((AbstractInsnNode)new InsnNode(3));
                    nodesList.add((AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)currentInsn).label));
                    methodNode.instructions.insertBefore(currentInsn.getPrevious().getPrevious().getPrevious(), nodesList);
                    isSuccessful2 = true;
                    continue;
                }
                if (currentInsn.getOpcode() != 184 || ++invokestaticCount != 8) continue;
                nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 13));
                nodesList.add((AbstractInsnNode)new VarInsnNode(21, 15));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "ceilMaxLevel", "(L" + enchantmentClassName + ";I)I", false));
                nodesList.add((AbstractInsnNode)new VarInsnNode(54, 15));
                methodNode.instructions.insertBefore(currentInsn.getPrevious().getPrevious().getPrevious(), nodesList);
                isSuccessful3 = true;
                break block0;
            }
        }
        return isSuccessful0 && isSuccessful1 && isSuccessful2 && isSuccessful3;
    }

    private boolean pathcTEEnchanterManager(ClassNode classNode) {
        String addDefaultEnchantmentRecipeMethodName = "addDefaultEnchantmentRecipe";
        String enchantmentClassName = "net/minecraft/enchantment/Enchantment";
        boolean isSuccessful = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(addDefaultEnchantmentRecipeMethodName)) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 199) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "isInvalid", "(L" + enchantmentClassName + ";)Z", false));
                nodesList.add((AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)currentInsn).label));
                methodNode.instructions.insert(currentInsn, nodesList);
                methodNode.instructions.remove(currentInsn.getPrevious());
                methodNode.instructions.remove(currentInsn);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }

    private boolean pathcMCItemStack(ClassNode classNode) {
        String getTooltipMethodName = ECCorePlugin.isObfuscated() ? "a" : "getTooltip";
        String itemStackClassName = ECCorePlugin.isObfuscated() ? "aip" : "net/minecraft/item/ItemStack";
        String entityPlayerClassName = ECCorePlugin.isObfuscated() ? "aed" : "net/minecraft/entity/player/EntityPlayer";
        String iTooltipFlagClassName = ECCorePlugin.isObfuscated() ? "akb" : "net/minecraft/client/util/ITooltipFlag";
        String listClassName = "java/util/List";
        boolean isSuccessful = false;
        int ifneCount = 0;
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals(getTooltipMethodName) || !methodNode.desc.equals("(L" + entityPlayerClassName + ";L" + iTooltipFlagClassName + ";)L" + listClassName + ";")) continue;
            for (AbstractInsnNode currentInsn : methodNode.instructions) {
                if (currentInsn.getOpcode() != 154 || ++ifneCount != 4) continue;
                InsnList nodesList = new InsnList();
                nodesList.add((AbstractInsnNode)new VarInsnNode(21, 5));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                nodesList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                nodesList.add((AbstractInsnNode)new InsnNode(3));
                nodesList.add((AbstractInsnNode)new MethodInsnNode(184, HOOKS_CLASS, "modifyItemStackTooltip", "(IL" + itemStackClassName + ";L" + listClassName + ";Z)V", false));
                nodesList.add((AbstractInsnNode)new InsnNode(3));
                nodesList.add((AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)currentInsn).label));
                methodNode.instructions.insertBefore(currentInsn.getPrevious().getPrevious().getPrevious(), nodesList);
                isSuccessful = true;
                break block0;
            }
        }
        return isSuccessful;
    }
}

