/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.core;

import austeretony.enchcontrol.client.reference.ClientReference;
import austeretony.enchcontrol.common.config.ConfigLoader;
import austeretony.enchcontrol.common.config.EnumConfigSettings;
import austeretony.enchcontrol.common.enchantment.EnchantmentWrapper;
import austeretony.enchcontrol.common.main.ECMain;
import austeretony.enchcontrol.common.util.ECUtils;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandEnchant;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import org.apache.logging.log4j.Logger;

public class ECHooks {
    public static void loadCustomLocalization(List<String> languageList, Map<String, String> properties) {
        ConfigLoader.loadCustomLocalization(languageList, properties);
    }

    public static int ceilMaxLevel(Enchantment enchantment, int level) {
        EnchantmentWrapper wrapper = EnchantmentWrapper.get(enchantment);
        int levelCap = MathHelper.func_76125_a((int)wrapper.getMaxLevel(), (int)wrapper.getMinLevel(), (int)EnumConfigSettings.ANVIL_LEVEL_CAP.getIntValue());
        return level > levelCap ? levelCap : level;
    }

    public static boolean canApply(Enchantment enchantment, ItemStack itemStack) {
        return EnchantmentWrapper.get(enchantment).canApply(itemStack);
    }

    public static boolean isCompatibleWith(Enchantment thisEnch, Enchantment thatEnch) {
        return EnchantmentWrapper.get(thisEnch).isCompatibleWith(thatEnch);
    }

    public static String getTranslatedName(Enchantment enchantment, int level) {
        EnchantmentWrapper wrapper = EnchantmentWrapper.get(enchantment);
        String s = I18n.func_74838_a((String)wrapper.getName());
        if (wrapper.isCurse()) {
            s = TextFormatting.RED + s;
        }
        return level == 1 && wrapper.getMaxLevel() == 1 ? s : s + " " + (EnumConfigSettings.ROMAN_NUMERALS.isEnabled() ? ECUtils.toRomanNumeral(level) : Integer.valueOf(level));
    }

    public static void removeIncompatible(List<EnchantmentData> list, EnchantmentData enchantmentData) {
        Iterator<EnchantmentData> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (EnchantmentWrapper.get(enchantmentData.field_76302_b).isCompatibleWith(iterator.next().field_76302_b)) continue;
            iterator.remove();
        }
    }

    public static List<EnchantmentData> getEnchantmentDatas(int level, ItemStack itemStack, boolean allowTreasure) {
        ArrayList list = Lists.newArrayList();
        Item item = itemStack.func_77973_b();
        boolean flag = itemStack.func_77973_b() == Items.field_151122_aG;
        block0: for (Enchantment enchantment : Enchantment.field_185264_b) {
            int levelCap;
            EnchantmentWrapper wrapper = EnchantmentWrapper.get(enchantment);
            if (!wrapper.isEnabled() || wrapper.isTreasure() && !allowTreasure || !enchantment.canApplyAtEnchantingTable(itemStack) && (!flag || !wrapper.isAllowedOnBooks())) continue;
            for (int i = levelCap = MathHelper.func_76125_a((int)wrapper.getMaxLevel(), (int)wrapper.getMinLevel(), (int)EnumConfigSettings.ENCHANTMENT_TABLE_LEVEL_CAP.getIntValue()); i > wrapper.getMinLevel() - 1; --i) {
                if (level < wrapper.getMinEnchantability(i) || level > wrapper.getMaxEnchantability(i)) continue;
                list.add(new EnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    public static Enchantment getRandomEnchantment(Random random) {
        Enchantment enchantment = null;
        for (int i = 0; i < Enchantment.field_185264_b.func_148742_b().size(); ++i) {
            enchantment = (Enchantment)Enchantment.field_185264_b.func_186801_a(random);
            if (!EnchantmentWrapper.get(enchantment).isEnabled()) continue;
            return enchantment;
        }
        return enchantment;
    }

    public static void addMerchantRecipe(MerchantRecipeList recipeList, Random random) {
        Enchantment enchantment = ECHooks.getRandomEnchantment(random);
        EnchantmentWrapper wrapper = EnchantmentWrapper.get(enchantment);
        int levelCap = MathHelper.func_76125_a((int)wrapper.getMaxLevel(), (int)wrapper.getMinLevel(), (int)EnumConfigSettings.MERCHANT_DEALS_LEVEL_CAP.getIntValue());
        int i = MathHelper.func_76136_a((Random)random, (int)wrapper.getMinLevel(), (int)levelCap);
        ItemStack itemstack = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i));
        int j = 2 + random.nextInt(5 + i * 10) + 3 * i;
        if (wrapper.shouldDoublePrice()) {
            j *= 2;
        }
        if (j > 64) {
            j = 64;
        }
        recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151122_aG), new ItemStack(Items.field_151166_bC, j), itemstack));
    }

    public static ItemStack apply(ItemStack itemStack, Random rand, List<Enchantment> enchantments, Logger logger) {
        Enchantment enchantment;
        EnchantmentWrapper wrapper;
        if (enchantments.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (Enchantment enchantment1 : Enchantment.field_185264_b) {
                wrapper = EnchantmentWrapper.get(enchantment1);
                if (!wrapper.isEnabled() || itemStack.func_77973_b() != Items.field_151122_aG && !wrapper.canApply(itemStack)) continue;
                list.add(enchantment1);
            }
            if (list.isEmpty()) {
                logger.warn("Couldn't find a compatible enchantment for {}", (Object)itemStack);
                return itemStack;
            }
            enchantment = (Enchantment)list.get(rand.nextInt(list.size()));
        } else {
            enchantment = enchantments.get(rand.nextInt(enchantments.size()));
        }
        wrapper = EnchantmentWrapper.get(enchantment);
        int levelCap = MathHelper.func_76125_a((int)wrapper.getMaxLevel(), (int)wrapper.getMinLevel(), (int)EnumConfigSettings.DUNGEON_LOOT_LEVEL_CAP.getIntValue());
        int i = MathHelper.func_76136_a((Random)rand, (int)wrapper.getMinLevel(), (int)levelCap);
        if (itemStack.func_77973_b() == Items.field_151122_aG) {
            itemStack = new ItemStack(Items.field_151134_bR);
            ItemEnchantedBook.func_92115_a((ItemStack)itemStack, (EnchantmentData)new EnchantmentData(enchantment, i));
        } else {
            itemStack.func_77966_a(enchantment, i);
        }
        return itemStack;
    }

    public static void execute(CommandEnchant command, EntityLivingBase livingBase, Enchantment enchantment, ICommandSender sender, String ... args) throws CommandException {
        EnchantmentWrapper wrapper = EnchantmentWrapper.get(enchantment);
        int i = 1;
        ItemStack itemStack = livingBase.func_184614_ca();
        if (itemStack.func_190926_b()) {
            throw new CommandException("commands.enchant.noItem", new Object[0]);
        }
        if (!wrapper.canApply(itemStack)) {
            throw new CommandException("commands.enchant.cantEnchant", new Object[0]);
        }
        if (args.length >= 3) {
            i = CommandBase.func_175764_a((String)args[2], (int)wrapper.getMinLevel(), (int)wrapper.getMaxLevel());
        }
        if (itemStack.func_77942_o()) {
            NBTTagList nbttaglist = itemStack.func_77986_q();
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                Enchantment enchantment1;
                short k = nbttaglist.func_150305_b(j).func_74765_d("id");
                if (Enchantment.func_185262_c((int)k) == null || wrapper.isCompatibleWith(enchantment1 = Enchantment.func_185262_c((int)k))) continue;
                throw new CommandException("commands.enchant.cantCombine", new Object[]{enchantment.func_77316_c(i), enchantment1.func_77316_c((int)nbttaglist.func_150305_b(j).func_74765_d("lvl"))});
            }
        }
        itemStack.func_77966_a(enchantment, i);
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"commands.enchant.success", (Object[])new Object[0]);
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, 1);
    }

    public static void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        block4: {
            block3: {
                if (tab != CreativeTabs.field_78027_g) break block3;
                for (Enchantment enchantment : Enchantment.field_185264_b) {
                    EnchantmentWrapper wrapper = EnchantmentWrapper.get(enchantment);
                    int levelCap = MathHelper.func_76125_a((int)wrapper.getMaxLevel(), (int)wrapper.getMinLevel(), (int)EnumConfigSettings.CREATIVE_TAB_LEVEL_CAP.getIntValue());
                    if (enchantment.field_77351_y == null) continue;
                    for (int i = wrapper.getMinLevel(); i <= levelCap; ++i) {
                        items.add((Object)ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i)));
                    }
                }
                break block4;
            }
            if (tab.func_111225_m().length == 0) break block4;
            for (Enchantment enchantment1 : Enchantment.field_185264_b) {
                if (!tab.func_111226_a(enchantment1.field_77351_y)) continue;
                items.add((Object)ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment1, EnchantmentWrapper.get(enchantment1).getMaxLevel())));
            }
        }
    }

    public static boolean isInvalid(Enchantment enchantment) {
        if (enchantment == null) {
            return true;
        }
        return !EnchantmentWrapper.get(enchantment).isEnabled();
    }

    public static void modifyItemStackTooltip(int flag, ItemStack itemStack, List<String> tooltip, boolean enchantedBook) {
        if ((flag & 1) == 0 || enchantedBook) {
            NBTTagList tagList = enchantedBook ? ItemEnchantedBook.func_92110_g((ItemStack)itemStack) : itemStack.func_77986_q();
            for (int j = 0; j < tagList.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound = tagList.func_150305_b(j);
                short k = nbttagcompound.func_74765_d("id");
                short l = nbttagcompound.func_74765_d("lvl");
                Enchantment enchantment = Enchantment.func_185262_c((int)k);
                if (enchantment == null) continue;
                EnchantmentWrapper wrapper = EnchantmentWrapper.get(enchantment);
                boolean curseMarked = false;
                if (!enchantedBook && wrapper.shouldHideOnItem() || enchantedBook && wrapper.shouldHideOnBook()) continue;
                if (!wrapper.isCurse() || !EnumConfigSettings.HIDE_CURSES.isEnabled()) {
                    if (EnumConfigSettings.DESCRIPTIONS.isEnabled() && EnumConfigSettings.DESCRIPTIONS_LOCATION.getIntValue() == 0 && (!enchantedBook && EnumConfigSettings.DESCRIPTIONS_FOR_ITEMS.isEnabled() || enchantedBook && EnumConfigSettings.DESCRIPTIONS_FOR_BOOKS.isEnabled())) {
                        ClientReference.getGameSettings();
                        if (GameSettings.func_100015_a((KeyBinding)ClientReference.getGameSettings().field_74311_E)) {
                            if (j > 0 && !EnumConfigSettings.DESCRIPTIONS_SEPARATOR.getStrValue().isEmpty()) {
                                tooltip.add(EnumConfigSettings.DESCRIPTIONS_SEPARATOR.getStrValue());
                            }
                            tooltip.add(enchantment.func_77316_c((int)l));
                            if (wrapper.hasDescription()) {
                                for (String s : wrapper.getDescription()) {
                                    tooltip.add(" " + ChatFormatting.ITALIC + net.minecraft.client.resources.I18n.func_135052_a((String)s, (Object[])new Object[0]));
                                }
                            } else {
                                tooltip.add(" " + ChatFormatting.ITALIC + net.minecraft.client.resources.I18n.func_135052_a((String)"ec.tooltip.noDesc", (Object[])new Object[0]));
                            }
                            if (!EnumConfigSettings.DESCRIPTIONS_SHOW_DOMAIN.isEnabled()) continue;
                            tooltip.add(" " + net.minecraft.client.resources.I18n.func_135052_a((String)"ec.tooltip.addedBy", (Object[])new Object[0]) + ": " + ChatFormatting.AQUA + ECMain.MODS_NAMES.get(wrapper.modid));
                            continue;
                        }
                        tooltip.add(enchantment.func_77316_c((int)l));
                        continue;
                    }
                    tooltip.add(enchantment.func_77316_c((int)l));
                    continue;
                }
                if (curseMarked) continue;
                curseMarked = true;
                if (!EnumConfigSettings.NOTIFY_CURSED.isEnabled()) continue;
                tooltip.add(ChatFormatting.RED + net.minecraft.client.resources.I18n.func_135052_a((String)"ec.tooltip.cursed", (Object[])new Object[0]));
            }
        }
    }
}

