/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.core;

import austeretony.enchcontrol.common.core.EnumInputClass;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ECClassTransformer
implements IClassTransformer {
    public static final Logger CORE_LOGGER = LogManager.getLogger((String)"EC Core Plugin");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.client.resources.Locale": {
                return this.patch(basicClass, EnumInputClass.MC_LOCALE);
            }
            case "net.minecraft.enchantment.Enchantment": {
                return this.patch(basicClass, EnumInputClass.MC_ENCHANTMENT);
            }
            case "net.minecraft.enchantment.EnchantmentHelper": {
                return this.patch(basicClass, EnumInputClass.MC_ENCHANTMENT_HELPER);
            }
            case "net.minecraft.entity.passive.EntityVillager$ListEnchantedBookForEmeralds": {
                return this.patch(basicClass, EnumInputClass.MC_LIST_ENCHANTED_BOOK_FOR_EMERALDS);
            }
            case "net.minecraft.world.storage.loot.functions.EnchantRandomly": {
                return this.patch(basicClass, EnumInputClass.MC_ENCHANT_RANDOMLY);
            }
            case "net.minecraft.command.CommandEnchant": {
                return this.patch(basicClass, EnumInputClass.MC_COMMAND_ENCHANT);
            }
            case "net.minecraft.item.ItemEnchantedBook": {
                return this.patch(basicClass, EnumInputClass.MC_ITEM_ENCHANTED_BOOK);
            }
            case "net.minecraft.inventory.ContainerRepair": {
                return this.patch(basicClass, EnumInputClass.MC_CONTAINER_REPAIR);
            }
            case "net.minecraft.item.ItemStack": {
                return this.patch(basicClass, EnumInputClass.MC_ITEM_STACK);
            }
            case "cofh.thermalexpansion.util.managers.machine.EnchanterManager": {
                return this.patch(basicClass, EnumInputClass.TE_ENCHANTER_MANAGER);
            }
        }
        return basicClass;
    }

    private byte[] patch(byte[] basicClass, EnumInputClass enumInput) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, enumInput.readerFlags);
        if (enumInput.patch(classNode)) {
            CORE_LOGGER.info("{} <{}.class> patched!", (Object)enumInput.domain, (Object)enumInput.clazz);
        } else {
            CORE_LOGGER.error("{} <{}.class> patch FAILED!", (Object)enumInput.domain, (Object)enumInput.clazz);
        }
        ClassWriter writer = new ClassWriter(enumInput.writerFlags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

