/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.config;

import austeretony.enchcontrol.common.config.EnumConfigSettings;
import austeretony.enchcontrol.common.config.EnumEnchantmentListType;
import austeretony.enchcontrol.common.config.EnumEnchantmentsKey;
import austeretony.enchcontrol.common.enchantment.EnchantmentWrapper;
import austeretony.enchcontrol.common.main.ECMain;
import austeretony.enchcontrol.common.reference.CommonReference;
import austeretony.enchcontrol.common.util.ECUtils;
import com.google.common.collect.HashMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class ConfigLoader {
    private static final String EXT_CONFIGURATION_FILE = CommonReference.getGameFolder() + "/config/enchcontrol/config.json";
    private static final String EXT_DATA_FILE = CommonReference.getGameFolder() + "/config/enchcontrol/enchantments.json";
    private static final String EXT_LOCALIZATION_FILE = CommonReference.getGameFolder() + "/config/enchcontrol/localization.json";
    private static final String LIST_ALL_FILE = CommonReference.getGameFolder() + "/config/enchcontrol/all_enchantments.txt";
    private static final String LIST_UNKNOWN_FILE = CommonReference.getGameFolder() + "/config/enchcontrol/unknown_enchantments.txt";
    public static final String MIN_ENCH_DEFAULT_EVAL = "1+LVL*10";
    public static final String MAX_ENCH_DEFAULT_EVAL = "MIN+5";
    public static boolean runningAtDedicatedServer;
    private static final DateFormat BACKUP_DATE_FORMAT;
    private static Map<String, String> localization;

    public static void load() {
        ECMain.LOGGER.info("Loading configuration...");
        try {
            JsonObject internalConfig = ECUtils.getInternalJsonData("assets/enchcontrol/config.json").getAsJsonObject();
            JsonArray internalSettings = ECUtils.getInternalJsonData("assets/enchcontrol/enchantments.json").getAsJsonArray();
            EnumConfigSettings.EXTERNAL_CONFIG.initByType(internalConfig);
            if (EnumConfigSettings.EXTERNAL_CONFIG.isEnabled()) {
                ConfigLoader.loadExternalConfig(internalConfig, internalSettings);
            } else {
                ConfigLoader.loadData(internalConfig, internalSettings);
            }
        }
        catch (IOException exception) {
            ECMain.LOGGER.error("Internal configuration files damaged!");
            exception.printStackTrace();
        }
    }

    private static void loadExternalConfig(JsonObject internalConfig, JsonArray internalSettings) {
        Path configPath = Paths.get(EXT_CONFIGURATION_FILE, new String[0]);
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                ConfigLoader.loadData(ConfigLoader.updateConfig(internalConfig), ECUtils.getExternalJsonData(EXT_DATA_FILE).getAsJsonArray());
            }
            catch (IOException exception) {
                ECMain.LOGGER.error("External configuration file damaged!");
                exception.printStackTrace();
            }
        } else {
            try {
                Path dataPath = Paths.get(EXT_DATA_FILE, new String[0]);
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.createDirectories(dataPath.getParent(), new FileAttribute[0]);
                ConfigLoader.createExternalCopyAndLoad(internalConfig, internalSettings);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private static JsonObject updateConfig(JsonObject internalConfig) throws IOException {
        try {
            JsonObject externalConfigOld = ECUtils.getExternalJsonData(EXT_CONFIGURATION_FILE).getAsJsonObject();
            JsonElement versionElement = externalConfigOld.get("version");
            if (versionElement == null || ConfigLoader.isOutdated(versionElement.getAsString(), "1.1.5:beta:0")) {
                ECMain.LOGGER.info("Updating external config file...");
                JsonObject externalConfigNew = new JsonObject();
                externalConfigNew.add("version", (JsonElement)new JsonPrimitive("1.1.5:beta:0"));
                LinkedHashMap internalData = new LinkedHashMap();
                HashMap externlDataOld = new HashMap();
                for (Map.Entry entry : internalConfig.entrySet()) {
                    internalData.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : externalConfigOld.entrySet()) {
                    externlDataOld.put(entry.getKey(), entry.getValue());
                }
                for (String key : internalData.keySet()) {
                    LinkedHashMap internalGroup = new LinkedHashMap();
                    HashMap externlGroupOld = new HashMap();
                    JsonObject externalGroupNew = new JsonObject();
                    for (Map.Entry entry : ((JsonElement)internalData.get(key)).getAsJsonObject().entrySet()) {
                        internalGroup.put(entry.getKey(), entry.getValue());
                    }
                    if (externlDataOld.containsKey(key)) {
                        for (Map.Entry entry : ((JsonElement)externlDataOld.get(key)).getAsJsonObject().entrySet()) {
                            externlGroupOld.put(entry.getKey(), entry.getValue());
                        }
                        for (String k : internalGroup.keySet()) {
                            if (externlGroupOld.containsKey(k)) {
                                externalGroupNew.add(k, (JsonElement)externlGroupOld.get(k));
                                continue;
                            }
                            externalGroupNew.add(k, (JsonElement)internalGroup.get(k));
                        }
                    } else {
                        for (String k : internalGroup.keySet()) {
                            externalGroupNew.add(k, (JsonElement)internalGroup.get(k));
                        }
                    }
                    externalConfigNew.add(key, (JsonElement)externalGroupNew);
                    ECUtils.createExternalJsonFile(EXT_CONFIGURATION_FILE, (JsonElement)externalConfigNew);
                }
                return externalConfigNew;
            }
            ECMain.LOGGER.info("External config up-to-date!");
            return externalConfigOld;
        }
        catch (IOException exception) {
            ECMain.LOGGER.error("External configuration file damaged!");
            exception.printStackTrace();
            return null;
        }
    }

    private static void createExternalCopyAndLoad(JsonObject internalConfig, JsonArray internalSettings) {
        try {
            ECUtils.createExternalJsonFile(EXT_CONFIGURATION_FILE, (JsonElement)internalConfig);
            ECUtils.createExternalJsonFile(EXT_DATA_FILE, (JsonElement)internalSettings);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        ConfigLoader.loadData(internalConfig, internalSettings);
    }

    private static void loadData(JsonObject configFile, JsonArray settingsFile) {
        ECMain.LOGGER.info("Loading data...");
        EnumConfigSettings.initAll(configFile);
        int i = 0;
        for (JsonElement enchElement : settingsFile) {
            JsonObject enchObject = enchElement.getAsJsonObject();
            EnchantmentWrapper wrapper = EnchantmentWrapper.create(new ResourceLocation(enchObject.get(EnumEnchantmentsKey.ID.key).getAsString()), enchObject.get(EnumEnchantmentsKey.ENABLED.key).getAsBoolean(), enchObject.get(EnumEnchantmentsKey.UNLOCALIZED_NAME.key).getAsString(), enchObject.get(EnumEnchantmentsKey.MIN_LEVEL.key).getAsInt(), enchObject.get(EnumEnchantmentsKey.MAX_LEVEL.key).getAsInt());
            wrapper.setHideOnItem(enchObject.get(EnumEnchantmentsKey.HIDE_ON_ITEM.key).getAsBoolean());
            wrapper.setHideOnBook(enchObject.get(EnumEnchantmentsKey.HIDE_ON_BOOK.key).getAsBoolean());
            JsonArray slotsArray = enchObject.get(EnumEnchantmentsKey.EQUIPMENT_SLOTS.key).getAsJsonArray();
            wrapper.initEnumEquipmentSlotsStrings(slotsArray.size());
            i = 0;
            for (JsonElement e : slotsArray) {
                wrapper.getEnumEquipmentSlotsStrings()[i++] = e.getAsString();
            }
            wrapper.setEnumRarityString(enchObject.get(EnumEnchantmentsKey.RARITY.key).getAsString());
            wrapper.setEnumTypeString(enchObject.get(EnumEnchantmentsKey.TYPE.key).getAsString());
            wrapper.setTreasure(enchObject.get(EnumEnchantmentsKey.TREASURE.key).getAsBoolean());
            wrapper.setDoublePrice(enchObject.get(EnumEnchantmentsKey.DOUBLE_PRICE.key).getAsBoolean());
            wrapper.setCurse(enchObject.get(EnumEnchantmentsKey.CURSE.key).getAsBoolean());
            wrapper.setAllowedOnBooks(enchObject.get(EnumEnchantmentsKey.ALLOWED_ON_BOOKS.key).getAsBoolean());
            wrapper.setCustomEvals(enchObject.get(EnumEnchantmentsKey.CUSTOM_EVALUATIONS.key).getAsBoolean());
            wrapper.setMinEnchantabilityEvaluation(enchObject.get(EnumEnchantmentsKey.MIN_ENCH_EVAL.key).getAsString());
            wrapper.setMaxEnchantabilityEvaluation(enchObject.get(EnumEnchantmentsKey.MAX_ENCH_EVAL.key).getAsString());
            wrapper.setIncompatMode(enchObject.get(EnumEnchantmentsKey.INCOMPAT_MODE.key).getAsInt());
            for (JsonElement incompatElement : enchObject.get(EnumEnchantmentsKey.INCOMPATIBLE_ENCHANTMENTS.key).getAsJsonArray()) {
                wrapper.addIncompatibleEnchantment(new ResourceLocation(incompatElement.getAsString()));
            }
            wrapper.setApplicabilityMode(enchObject.get(EnumEnchantmentsKey.APPLICABILITY_MODE.key).getAsInt());
            wrapper.setListMode(enchObject.get(EnumEnchantmentsKey.ITEMS_LIST_MODE.key).getAsInt());
            for (JsonElement incompatElement : enchObject.get(EnumEnchantmentsKey.ITEMS_LIST.key).getAsJsonArray()) {
                wrapper.addItem(new ResourceLocation(incompatElement.getAsString()));
            }
            JsonArray descArray = enchObject.get(EnumEnchantmentsKey.DESCRIPTION.key).getAsJsonArray();
            if (descArray.size() <= 0) continue;
            wrapper.initDescription(descArray.size());
            i = 0;
            for (JsonElement lineElement : descArray) {
                wrapper.getDescription()[i++] = lineElement.getAsString();
            }
        }
    }

    public static void loadCustomLocalization(List<String> languageList, Map<String, String> properties) {
        localization = properties;
        if (EnumConfigSettings.CUSTOM_LOCALIZATION.isEnabled()) {
            Path localizationPath = Paths.get(EXT_LOCALIZATION_FILE, new String[0]);
            if (Files.exists(localizationPath, new LinkOption[0])) {
                try {
                    ConfigLoader.loadLocalization(ECUtils.getExternalJsonData(EXT_LOCALIZATION_FILE).getAsJsonObject(), languageList, properties);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            try {
                Files.createDirectories(localizationPath.getParent(), new FileAttribute[0]);
                ECUtils.createAbsoluteJsonCopy(EXT_LOCALIZATION_FILE, ConfigLoader.class.getClassLoader().getResourceAsStream("assets/enchcontrol/localization.json"));
                ConfigLoader.loadLocalization(ECUtils.getInternalJsonData("assets/enchcontrol/localization.json").getAsJsonObject(), languageList, properties);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void loadLocalization(JsonObject localizationFile, List<String> languageList, Map<String, String> properties) {
        ECMain.LOGGER.info("Searching for custom localization...");
        for (String lang : languageList) {
            JsonElement entriesElement = localizationFile.get(lang.toLowerCase());
            if (entriesElement != null) {
                ECMain.LOGGER.info("Loading custom <{}> localization...", (Object)lang);
                JsonArray entries = entriesElement.getAsJsonArray();
                for (JsonElement entryElement : entries) {
                    JsonObject entryObject = entryElement.getAsJsonObject();
                    if (!entryObject.has("key") || !entryObject.has("value")) continue;
                    properties.put(entryObject.get("key").getAsString(), entryObject.get("value").getAsString());
                }
                continue;
            }
            ECMain.LOGGER.error("Custom localization for <{}> undefined!", (Object)lang);
        }
    }

    public static void processEnchantmentDescriptionsSupport() {
        boolean uploadDesc;
        boolean edLoaded = Loader.isModLoaded((String)"enchdesc");
        boolean loadDesc = EnumConfigSettings.DESCRIPTIONS.isEnabled() && EnumConfigSettings.LOAD_ED_DESC.isEnabled();
        boolean bl = uploadDesc = !EnumConfigSettings.DESCRIPTIONS.isEnabled() && EnumConfigSettings.UPLOAD_DESC_TO_ED.isEnabled();
        if (loadDesc || uploadDesc) {
            for (EnchantmentWrapper wrapper : EnchantmentWrapper.getWrappers()) {
                String formattedKey = "enchantment." + wrapper.modid + "." + wrapper.resourceName + ".desc";
                if (loadDesc && !wrapper.hasDescription() && localization.containsKey(formattedKey)) {
                    wrapper.initDescription(1);
                    wrapper.getDescription()[0] = formattedKey;
                    wrapper.setTemporaryDescription();
                }
                if (!uploadDesc || !edLoaded || !wrapper.hasDescription() || localization.containsKey(formattedKey)) continue;
                localization.put(formattedKey, I18n.func_135052_a((String)wrapper.getDescription()[0], (Object[])new Object[0]));
            }
        }
    }

    public static void clear() {
        try (PrintStream printStream = new PrintStream(new File(EXT_DATA_FILE));){
            printStream.println("[]");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void backup() {
        try {
            ECUtils.createExternalJsonFile(CommonReference.getGameFolder() + "/config/enchcontrol/enchantments-" + BACKUP_DATE_FORMAT.format(new Date()) + ".json", ECUtils.getExternalJsonData(EXT_DATA_FILE));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonArray enchsArray = new JsonArray();
        for (EnchantmentWrapper wrapper : EnchantmentWrapper.getWrappers()) {
            JsonObject enchObject = new JsonObject();
            JsonArray equipArray = new JsonArray();
            JsonArray incompatArray = new JsonArray();
            JsonArray itemsArray = new JsonArray();
            JsonArray descArray = new JsonArray();
            enchObject.add(EnumEnchantmentsKey.ID.key, (JsonElement)new JsonPrimitive(wrapper.registryName.toString()));
            enchObject.add(EnumEnchantmentsKey.UNLOCALIZED_NAME.key, (JsonElement)new JsonPrimitive(wrapper.getName()));
            enchObject.add(EnumEnchantmentsKey.ENABLED.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.isEnabled())));
            enchObject.add(EnumEnchantmentsKey.HIDE_ON_ITEM.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.shouldHideOnItem())));
            enchObject.add(EnumEnchantmentsKey.HIDE_ON_BOOK.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.shouldHideOnBook())));
            enchObject.add(EnumEnchantmentsKey.RARITY.key, (JsonElement)new JsonPrimitive(wrapper.getRarity().toString()));
            enchObject.add(EnumEnchantmentsKey.TREASURE.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.isTreasure())));
            enchObject.add(EnumEnchantmentsKey.DOUBLE_PRICE.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.shouldDoublePrice())));
            enchObject.add(EnumEnchantmentsKey.CURSE.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.isCurse())));
            enchObject.add(EnumEnchantmentsKey.ALLOWED_ON_BOOKS.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.isAllowedOnBooks())));
            enchObject.add(EnumEnchantmentsKey.MIN_LEVEL.key, (JsonElement)new JsonPrimitive((Number)wrapper.getMinLevel()));
            enchObject.add(EnumEnchantmentsKey.MAX_LEVEL.key, (JsonElement)new JsonPrimitive((Number)wrapper.getMaxLevel()));
            enchObject.add(EnumEnchantmentsKey.CUSTOM_EVALUATIONS.key, (JsonElement)new JsonPrimitive(Boolean.valueOf(wrapper.useCustomEvals())));
            enchObject.add(EnumEnchantmentsKey.MIN_ENCH_EVAL.key, (JsonElement)new JsonPrimitive(wrapper.getMinEnchantabilityEval()));
            enchObject.add(EnumEnchantmentsKey.MAX_ENCH_EVAL.key, (JsonElement)new JsonPrimitive(wrapper.getMaxEnchantabilityEval()));
            enchObject.add(EnumEnchantmentsKey.TYPE.key, (JsonElement)new JsonPrimitive(wrapper.getType() == null ? "NULL" : wrapper.getType().toString()));
            for (EntityEquipmentSlot equipment : wrapper.getEquipmentSlots()) {
                equipArray.add((JsonElement)new JsonPrimitive(equipment.toString()));
            }
            enchObject.add(EnumEnchantmentsKey.EQUIPMENT_SLOTS.key, (JsonElement)equipArray);
            enchObject.add(EnumEnchantmentsKey.INCOMPAT_MODE.key, (JsonElement)new JsonPrimitive((Number)wrapper.getIncompatMode()));
            if (wrapper.hasIncompatibleEnchantments()) {
                for (ResourceLocation regName : wrapper.getIncompatibleEnchantments()) {
                    incompatArray.add((JsonElement)new JsonPrimitive(regName.toString()));
                }
            }
            enchObject.add(EnumEnchantmentsKey.INCOMPATIBLE_ENCHANTMENTS.key, (JsonElement)incompatArray);
            enchObject.add(EnumEnchantmentsKey.APPLICABILITY_MODE.key, (JsonElement)new JsonPrimitive((Number)wrapper.getApplicabilityMode()));
            enchObject.add(EnumEnchantmentsKey.ITEMS_LIST_MODE.key, (JsonElement)new JsonPrimitive((Number)wrapper.getListMode()));
            if (wrapper.hasItemList()) {
                for (ResourceLocation regName : wrapper.getItemList()) {
                    itemsArray.add((JsonElement)new JsonPrimitive(regName.toString()));
                }
            }
            enchObject.add(EnumEnchantmentsKey.ITEMS_LIST.key, (JsonElement)itemsArray);
            if (wrapper.hasDescription() && !wrapper.isTemporaryDescription()) {
                for (String line : wrapper.getDescription()) {
                    descArray.add((JsonElement)new JsonPrimitive(line));
                }
            }
            enchObject.add(EnumEnchantmentsKey.DESCRIPTION.key, (JsonElement)descArray);
            enchsArray.add((JsonElement)enchObject);
        }
        try (FileWriter writer = new FileWriter(EXT_DATA_FILE);){
            gson.toJson((JsonElement)enchsArray, (Appendable)writer);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void createEnchantmentsListFile(EnumEnchantmentListType enumType) {
        ArrayList<String> data = new ArrayList<String>();
        data.add("mod name - enchantment name - enchantment registry name");
        TreeSet<String> sortedModNames = new TreeSet<String>();
        HashMultimap wrappersByModNames = HashMultimap.create();
        for (EnchantmentWrapper enchantmentWrapper : enumType == EnumEnchantmentListType.ALL ? EnchantmentWrapper.getWrappers() : EnchantmentWrapper.UNKNOWN) {
            String modName = ECMain.MODS_NAMES.get(enchantmentWrapper.modid);
            modName = modName == null ? "Undefined" : modName;
            sortedModNames.add(modName);
            wrappersByModNames.put((Object)modName, (Object)enchantmentWrapper);
        }
        for (String s : sortedModNames) {
            for (EnchantmentWrapper w : wrappersByModNames.get((Object)s)) {
                StringBuilder stringBuilder = new StringBuilder().append(s).append(" - ").append(I18n.func_135052_a((String)w.getName(), (Object[])new Object[0])).append(" - ").append(w.registryName.toString());
                data.add(stringBuilder.toString());
            }
        }
        try (PrintWriter printWriter = new PrintWriter(enumType == EnumEnchantmentListType.ALL ? LIST_ALL_FILE : LIST_UNKNOWN_FILE);){
            for (String line : data) {
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isOutdated(String currentVersion, String availableVersion) {
        try {
            String[] cSplitted = currentVersion.split("[:]");
            String[] aSplitted = availableVersion.split("[:]");
            String cVer = cSplitted[0];
            String cType = cSplitted[1];
            String cRev = cSplitted[2];
            String aVer = aSplitted[0];
            String aType = aSplitted[1];
            String aRev = aSplitted[2];
            String[] cVerSplitted = cVer.split("[.]");
            String[] aVerSplitted = aVer.split("[.]");
            for (int i = 0; i < 3; ++i) {
                int verDiff = Integer.parseInt(aVerSplitted[i]) - Integer.parseInt(cVerSplitted[i]);
                if (verDiff > 0) {
                    return true;
                }
                if (verDiff >= 0) continue;
                return false;
            }
            if (aType.equals("release") && (cType.equals("beta") || cType.equals("alpha"))) {
                return true;
            }
            if (aType.equals("beta") && cType.equals("alpha")) {
                return true;
            }
            int revDiff = Integer.parseInt(aRev) - Integer.parseInt(cRev);
            if (revDiff > 0) {
                return true;
            }
            if (revDiff < 0) {
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            ECMain.LOGGER.error("Versions comparison failed!");
            exception.printStackTrace();
            return true;
        }
    }

    static {
        BACKUP_DATE_FORMAT = new SimpleDateFormat("yy_MM_dd-HH-mm-ss");
    }
}

