/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.command;

import austeretony.enchcontrol.common.command.EnumCommandArg;
import austeretony.enchcontrol.common.config.ConfigLoader;
import austeretony.enchcontrol.common.config.EnumConfigSettings;
import austeretony.enchcontrol.common.config.EnumEnchantmentListType;
import austeretony.enchcontrol.common.enchantment.EnchantmentWrapper;
import austeretony.enchcontrol.common.main.ECMain;
import austeretony.enchcontrol.common.main.EnumChatMessage;
import austeretony.enchcontrol.common.reference.CommonReference;
import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class CommandEC
extends CommandBase {
    public static final String NAME = "ec";
    public static final String USAGE = "/ec <arg>, type </ec help> for available arguments.";

    public String func_71517_b() {
        return NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return USAGE;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayerMP && CommonReference.isOpped((EntityPlayer)((EntityPlayerMP)sender));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EnumCommandArg arg = EnumCommandArg.get(args);
        if (arg == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandEC.func_71521_c((ICommandSender)sender);
        switch (arg) {
            case HELP: {
                EnumChatMessage.COMMAND_EC_HELP.sendMessage((EntityPlayer)player, new String[0]);
                break;
            }
            case LIST_ALL: {
                if (!this.validAction((EntityPlayer)player, false, false, false, false)) break;
                EnumChatMessage.COMMAND_EC_LIST_ALL.sendMessage((EntityPlayer)player, arg.getProcessingArgument(args));
                break;
            }
            case FILE_ALL: {
                if (!this.validAction((EntityPlayer)player, true, false, false, true)) break;
                ConfigLoader.createEnchantmentsListFile(EnumEnchantmentListType.ALL);
                EnumChatMessage.COMMAND_EC_FILE_ALL.sendMessage((EntityPlayer)player, new String[0]);
                break;
            }
            case LIST_UNKNOWN: {
                if (!this.validAction((EntityPlayer)player, false, false, true, false)) break;
                EnumChatMessage.COMMAND_EC_LIST_UNKNOWN.sendMessage((EntityPlayer)player, arg.getProcessingArgument(args));
                break;
            }
            case FILE_UNKNOWN: {
                if (!this.validAction((EntityPlayer)player, true, false, true, true)) break;
                ConfigLoader.createEnchantmentsListFile(EnumEnchantmentListType.UNKNOWN);
                EnumChatMessage.COMMAND_EC_FILE_UNKNOWN.sendMessage((EntityPlayer)player, new String[0]);
                break;
            }
            case CLEAR: {
                if (!this.validAction((EntityPlayer)player, true, true, false, true)) break;
                ConfigLoader.clear();
                EnumChatMessage.COMMAND_EC_CLEAR.sendMessage((EntityPlayer)player, new String[0]);
                break;
            }
            case RELOAD: {
                if (!this.validAction((EntityPlayer)player, true, true, false, true)) break;
                EnchantmentWrapper.clearData();
                ConfigLoader.load();
                this.wrap();
                EnumChatMessage.COMMAND_EC_RELOAD.sendMessage((EntityPlayer)player, new String[0]);
                break;
            }
            case BACKUP: {
                if (!this.validAction((EntityPlayer)player, true, true, false, true)) break;
                ConfigLoader.backup();
                EnumChatMessage.COMMAND_EC_BACKUP.sendMessage((EntityPlayer)player, new String[0]);
                break;
            }
            case UPDATE: {
                if (!this.validAction((EntityPlayer)player, true, true, true, true)) break;
                ConfigLoader.save();
                EnumChatMessage.COMMAND_EC_UPDATE.sendMessage((EntityPlayer)player, new String[0]);
                break;
            }
            case INFO: {
                if (!this.validAction((EntityPlayer)player, false, false, false, false)) break;
                EnumChatMessage.COMMAND_EC_INFO.sendMessage((EntityPlayer)player, arg.getProcessingArgument(args));
                break;
            }
            case EVAL: {
                if (!this.validAction((EntityPlayer)player, false, false, false, false)) break;
                this.calculate((EntityPlayer)player, arg.getProcessingArgument(args));
            }
        }
    }

    private boolean validAction(EntityPlayer player, boolean checkExternalConfig, boolean checkDebugMode, boolean checkUnknown, boolean checkDedicatedServer) {
        if (checkExternalConfig && !EnumConfigSettings.EXTERNAL_CONFIG.isEnabled()) {
            EnumChatMessage.COMMAND_EC_ERR_EXTERNAL_CONFIG_DISABLED.sendMessage(player, new String[0]);
            return false;
        }
        if (checkDebugMode && !EnumConfigSettings.DEBUG_MODE.isEnabled()) {
            EnumChatMessage.COMMAND_EC_ERR_DEBUG_MODE_DISABLED.sendMessage(player, new String[0]);
            return false;
        }
        if (checkUnknown && EnchantmentWrapper.UNKNOWN.isEmpty()) {
            EnumChatMessage.COMMAND_EC_ERR_NO_UNKNOWN_ENCHANTMENTS.sendMessage(player, new String[0]);
            return false;
        }
        if (checkDedicatedServer && ConfigLoader.runningAtDedicatedServer) {
            EnumChatMessage.COMMAND_EC_ERR_RUNNING_AT_DEDICATED_SERVER.sendMessage(player, new String[0]);
            return false;
        }
        return true;
    }

    private void wrap() {
        ECMain.LOGGER.info("Applying enchantments settings...");
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            EnchantmentWrapper.get(enchantment);
        }
    }

    private void calculate(EntityPlayer player, String eval) {
        try {
            BigDecimal result = new Expression(eval).eval();
            EnumChatMessage.COMMAND_EC_EVAL.sendMessage(player, eval, String.valueOf(result.intValue()));
        }
        catch (Exception exception) {
            EnumChatMessage.COMMAND_EC_ERR_WRONG_EXPRESSION.sendMessage(player, eval);
        }
    }
}

