/*
 * Decompiled with CFR 0.152.
 */
package mcjty.fxcontrol;

import java.util.HashMap;
import java.util.Map;
import mcjty.fxcontrol.FxControl;
import mcjty.fxcontrol.RulesManager;
import mcjty.fxcontrol.rules.EffectRule;
import mcjty.fxcontrol.rules.HarvestRule;
import mcjty.fxcontrol.rules.LeftClickRule;
import mcjty.fxcontrol.rules.PlaceRule;
import mcjty.fxcontrol.rules.RightClickRule;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class ForgeEventHandlers {
    public static boolean debug = false;
    public static Map<Integer, Integer> tickCounters = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public void onRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        int i = 0;
        for (RightClickRule rule : RulesManager.rightclickRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    FxControl.setup.getLogger().log(Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntityPlayer().func_70005_c_() + " y: " + event.getPos().func_177956_o() + " biome: " + event.getWorld().func_180494_b((BlockPos)event.getPos()).field_76791_y);
                }
                rule.action(event);
                event.setUseBlock(result);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onLeftClickEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        int i = 0;
        for (LeftClickRule rule : RulesManager.leftclickRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    FxControl.setup.getLogger().log(Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntityPlayer().func_70005_c_() + " y: " + event.getPos().func_177956_o() + " biome: " + event.getWorld().func_180494_b((BlockPos)event.getPos()).field_76791_y);
                }
                rule.action(event);
                event.setUseBlock(result);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onBlockPaceEvent(BlockEvent.PlaceEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        int i = 0;
        for (PlaceRule rule : RulesManager.placeRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    FxControl.setup.getLogger().log(Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getPlayer().func_70005_c_() + " y: " + event.getPos().func_177956_o() + " biome: " + event.getWorld().func_180494_b((BlockPos)event.getPos()).field_76791_y);
                }
                rule.action(event);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        int i = 0;
        for (HarvestRule rule : RulesManager.harvestRules) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    FxControl.setup.getLogger().log(Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getPlayer().func_70005_c_() + " y: " + event.getPos().func_177956_o() + " biome: " + event.getWorld().func_180494_b((BlockPos)event.getPos()).field_76791_y);
                }
                rule.action(event);
                if (result == Event.Result.DENY) {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        int id = event.player.func_145782_y();
        if (!tickCounters.containsKey(id)) {
            tickCounters.put(id, 0);
        }
        int tickCounter = tickCounters.get(id) + 1;
        tickCounters.put(id, tickCounter);
        int i = 0;
        for (EffectRule rule : RulesManager.effectRules) {
            if (tickCounter % rule.getTimeout() == 0 && rule.match(event)) {
                if (debug) {
                    FxControl.setup.getLogger().log(Level.INFO, "Join Rule " + i + " entity: " + event.player.func_70005_c_() + " y: " + event.player.func_180425_c().func_177956_o());
                }
                rule.action(event);
                return;
            }
            ++i;
        }
    }
}

