/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.spawning;

import c4.corpsecomplex.network.NetworkHandler;
import c4.corpsecomplex.network.TeleportEffectMessage;
import c4.corpsecomplex.network.TeleportSoundMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ScrollTeleporter {
    public static void sendTeleportEffect(World world, BlockPos pos) {
        NetworkHandler.INSTANCE.sendToAllAround((IMessage)new TeleportEffectMessage(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
    }

    public static void teleportToPosition(EntityPlayer player, BlockPos pos, EnumFacing facing, int dimensionId) {
        ScrollTeleporter.sendTeleportEffect(player.field_70170_p, new BlockPos((Entity)player));
        if (dimensionId != player.func_130014_f_().field_73011_w.getDimension()) {
            MinecraftServer server = player.field_70170_p.func_73046_m();
            if (server != null) {
                ScrollTeleporter.transferPlayerToDimension((EntityPlayerMP)player, dimensionId, server.func_184103_al());
            }
        } else {
            if (player.func_184207_aI()) {
                player.func_184226_ay();
            }
            if (player.func_184218_aH()) {
                player.func_184210_p();
            }
        }
        player.field_70177_z = ScrollTeleporter.getRotationYaw(facing);
        pos = new BlockPos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        ScrollTeleporter.sendTeleportEffect(player.field_70170_p, pos);
        if (player instanceof EntityPlayerMP) {
            NetworkHandler.INSTANCE.sendTo((IMessage)new TeleportSoundMessage(), (EntityPlayerMP)player);
        }
    }

    private static float getRotationYaw(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    private static void transferPlayerToDimension(EntityPlayerMP player, int dimension, PlayerList manager) {
        int oldDim = player.field_71093_bK;
        WorldServer worldserver = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer worldserver1 = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)player);
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        player.field_70128_L = false;
        ScrollTeleporter.transferEntityToWorld((Entity)player, worldserver, worldserver1);
        manager.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        manager.func_72354_b(player, worldserver1);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }

    private static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        WorldProvider oldWorldProvider = oldWorld.field_73011_w;
        WorldProvider newWorldProvider = newWorld.field_73011_w;
        double moveFactor = oldWorldProvider.getMovementFactor() / newWorldProvider.getMovementFactor();
        double x = entity.field_70165_t * moveFactor;
        double z = entity.field_70161_v * moveFactor;
        oldWorld.field_72984_F.func_76320_a("placing");
        x = MathHelper.func_151237_a((double)x, (double)-2.9999872E7, (double)2.9999872E7);
        z = MathHelper.func_151237_a((double)z, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        oldWorld.field_72984_F.func_76319_b();
        entity.func_70029_a((World)newWorld);
    }
}

