/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.effects;

import c4.corpsecomplex.common.modules.effects.MoriModule;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoriPotion
extends Potion {
    private static final String name = "Memento Mori";
    private static final double intIncrement = 1.0;
    private static final double percentIncrement = 0.05;
    private ResourceLocation icon;
    private static Map<IAttribute, Double> changeAmountMap = Maps.newHashMap();
    private static Map<IAttribute, AttributeModifier> attributeModifierMap = Maps.newHashMap();
    private static double tickHealth;
    private static double tickArmor;
    private static double tickTough;
    private static double tickMove;
    private static double tickSpeed;
    private static double tickDamage;

    public MoriPotion() {
        super(true, 1);
        this.setRegistryName("mori");
        this.func_76390_b("effect.corpsecomplex.mori");
        this.icon = new ResourceLocation("corpsecomplex", "textures/icons/mori.png");
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration < MoriModule.duration * 20 && MoriModule.doRecover && this.isChangeTick(duration);
    }

    public void func_76394_a(@Nonnull EntityLivingBase entityLivingBaseIn, int amplifier) {
        int duration = entityLivingBaseIn.func_70660_b((Potion)MoriModule.moriPotion).func_76459_b();
        if (MoriModule.modHealth != 0.0 && (double)duration % tickHealth == 0.0) {
            this.incrementRecover(entityLivingBaseIn, SharedMonsterAttributes.field_111267_a);
            if (entityLivingBaseIn.func_110143_aJ() > entityLivingBaseIn.func_110138_aP()) {
                entityLivingBaseIn.func_70606_j(entityLivingBaseIn.func_110138_aP());
            }
        }
        if (MoriModule.modArmor != 0.0 && (double)duration % tickArmor == 0.0) {
            this.incrementRecover(entityLivingBaseIn, SharedMonsterAttributes.field_188791_g);
        }
        if (MoriModule.modToughness != 0.0 && (double)duration % tickTough == 0.0) {
            this.incrementRecover(entityLivingBaseIn, SharedMonsterAttributes.field_189429_h);
        }
        if (MoriModule.modMove != 0.0 && (double)duration % tickMove == 0.0) {
            this.incrementRecover(entityLivingBaseIn, SharedMonsterAttributes.field_111263_d);
        }
        if (MoriModule.modSpeed != 0.0 && (double)duration % tickSpeed == 0.0) {
            this.incrementRecover(entityLivingBaseIn, SharedMonsterAttributes.field_188790_f);
        }
        if (MoriModule.modDamage != 0.0 && (double)duration % tickDamage == 0.0) {
            this.incrementRecover(entityLivingBaseIn, SharedMonsterAttributes.field_111264_e);
        }
    }

    public static void setModifiers() {
        attributeModifierMap.put(SharedMonsterAttributes.field_111267_a, new AttributeModifier(UUID.fromString("ca572ca7-d11e-4054-b225-f4c797cdf69b"), name, MoriModule.modHealth, 0));
        attributeModifierMap.put(SharedMonsterAttributes.field_188791_g, new AttributeModifier(UUID.fromString("b3bd0150-1953-4971-a822-8445953c4195"), name, MoriModule.modArmor, 0));
        attributeModifierMap.put(SharedMonsterAttributes.field_189429_h, new AttributeModifier(UUID.fromString("5113ef1e-5200-4d6a-a898-946f0e4b5d26"), name, MoriModule.modToughness, 0));
        attributeModifierMap.put(SharedMonsterAttributes.field_111263_d, new AttributeModifier(UUID.fromString("f9a9495d-89b5-4676-8345-bc2e92936821"), name, MoriModule.modMove, 2));
        attributeModifierMap.put(SharedMonsterAttributes.field_188790_f, new AttributeModifier(UUID.fromString("9fe627b8-3477-4ccf-9587-87776259172f"), name, MoriModule.modSpeed, 2));
        attributeModifierMap.put(SharedMonsterAttributes.field_111264_e, new AttributeModifier(UUID.fromString("ae5b003a-65f3-41f2-b104-4c71a2261d5b"), name, MoriModule.modDamage, 0));
        tickHealth = MoriPotion.setIncrement(SharedMonsterAttributes.field_111267_a, MoriModule.modHealth, false);
        tickArmor = MoriPotion.setIncrement(SharedMonsterAttributes.field_188791_g, MoriModule.modArmor, false);
        tickTough = MoriPotion.setIncrement(SharedMonsterAttributes.field_189429_h, MoriModule.modToughness, false);
        tickMove = MoriPotion.setIncrement(SharedMonsterAttributes.field_111263_d, MoriModule.modMove, true);
        tickSpeed = MoriPotion.setIncrement(SharedMonsterAttributes.field_188790_f, MoriModule.modSpeed, true);
        tickDamage = MoriPotion.setIncrement(SharedMonsterAttributes.field_111264_e, MoriModule.modDamage, false);
    }

    private boolean isChangeTick(int duration) {
        return (double)duration % tickHealth == 0.0 || (double)duration % tickArmor == 0.0 || (double)duration % tickTough == 0.0 || (double)duration % tickMove == 0.0 || (double)duration % tickSpeed == 0.0 || (double)duration % tickDamage == 0.0;
    }

    private void incrementRecover(EntityLivingBase entityIn, IAttribute attribute) {
        IAttributeInstance iAttributeInstance = entityIn.func_110140_aT().func_111151_a(attribute);
        AttributeModifier attributeModifier = iAttributeInstance.func_111127_a(attributeModifierMap.get(attribute).func_111167_a());
        if (attributeModifier == null || entityIn.func_130014_f_().field_72995_K) {
            return;
        }
        iAttributeInstance.func_111124_b(attributeModifier);
        double changeAmount = changeAmountMap.get(attribute);
        iAttributeInstance.func_111121_a(new AttributeModifier(attributeModifier.func_111167_a(), attributeModifier.func_111166_b(), attributeModifier.func_111164_d() + changeAmount, attributeModifier.func_111169_c()));
    }

    private static double setIncrement(IAttribute attribute, double amount, boolean isPercent) {
        double changeAmount;
        if (amount == 0.0) {
            return 0.0;
        }
        double sign = Math.signum(amount) * -1.0;
        double changeTick = Math.abs((double)MoriModule.duration / amount) * 20.0;
        if (isPercent) {
            changeAmount = sign * 0.05;
            changeTick *= 0.05;
        } else {
            changeAmount = sign * 1.0;
            changeTick *= 1.0;
        }
        if (changeTick >= 1.0) {
            changeTick = Math.floor(changeTick);
        } else if (isPercent) {
            changeAmount = sign * (1.0 / changeTick);
            changeTick = 1.0;
        } else {
            changeAmount = sign * Math.floor(1.0 / changeTick);
            changeTick = 1.0;
        }
        changeAmountMap.put(attribute, changeAmount);
        return changeTick;
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : attributeModifierMap.entrySet()) {
            IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(entry.getKey());
            if (iattributeinstance == null) continue;
            iattributeinstance.func_111124_b(entry.getValue());
        }
    }

    public void func_111185_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : attributeModifierMap.entrySet()) {
            IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(entry.getKey());
            if (iattributeinstance == null) continue;
            AttributeModifier attributemodifier = entry.getValue();
            iattributeinstance.func_111124_b(attributemodifier);
            iattributeinstance.func_111121_a(new AttributeModifier(attributemodifier.func_111167_a(), attributemodifier.func_111166_b(), attributemodifier.func_111164_d(), attributemodifier.func_111169_c()));
        }
    }

    public boolean func_76400_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (mc.field_71462_r != null) {
            mc.func_110434_K().func_110577_a(this.icon);
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        mc.func_110434_K().func_110577_a(this.icon);
        Gui.func_146110_a((int)(x + 4), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
    }
}

