/*
 * Decompiled with CFR 0.152.
 */
package ru.socol.advancedliftingmethods.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.socol.advancedliftingmethods.registry.ModItems;

public class BlockPoweredLadder
extends Block {
    protected static final AxisAlignedBB LADDER_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB LADDER_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    public EnumFacing facing;

    public BlockPoweredLadder(EnumFacing facing) {
        super(Material.field_151594_q);
        this.facing = facing;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (this.facing) {
            case NORTH: {
                return LADDER_NORTH_AABB;
            }
            case SOUTH: {
                return LADDER_SOUTH_AABB;
            }
            case WEST: {
                return LADDER_WEST_AABB;
            }
        }
        return LADDER_EAST_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(side.func_176734_d()));
        boolean flag = BlockPoweredLadder.func_193382_c((Block)iblockstate.func_177230_c());
        return !flag && side == this.facing && super.func_176196_c(worldIn, pos) && iblockstate.func_193401_d((IBlockAccess)worldIn, pos.func_177972_a(side.func_176734_d()), side) == BlockFaceShape.SOLID && !iblockstate.func_185897_m();
    }

    private boolean canAttachTo(World world, BlockPos pos, EnumFacing face) {
        IBlockState iblockstate = world.func_180495_p(pos);
        boolean flag = BlockPoweredLadder.func_193382_c((Block)iblockstate.func_177230_c());
        return !flag && iblockstate.func_193401_d((IBlockAccess)world, pos, face) == BlockFaceShape.SOLID && !iblockstate.func_185897_m();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ModItems.POWERED_LADDER, 1);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canAttachTo(worldIn, pos.func_177972_a(this.facing.func_176734_d()), this.facing)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        } else {
            int power = worldIn.func_175687_A(pos);
            BlockPos upPos = pos.func_177984_a();
            BlockPos downPos = pos.func_177977_b();
            IBlockState upState = worldIn.func_180495_p(upPos);
            IBlockState downState = worldIn.func_180495_p(downPos);
            int upPower = 0;
            int downPower = 0;
            if (upState.func_177230_c() == this) {
                upPower = (Integer)upState.func_177229_b((IProperty)POWER);
            }
            if (downState.func_177230_c() == this) {
                downPower = (Integer)downState.func_177229_b((IProperty)POWER);
            }
            power = Math.max(0, Math.max(power, Math.max(upPower, downPower) - 1));
            int currentPower = (Integer)state.func_177229_b((IProperty)POWER);
            if (currentPower != power) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power)), 3);
            }
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        if (!entity.func_70093_af() && (Integer)state.func_177229_b((IProperty)POWER) != 0 && entity.field_70181_x < 0.4) {
            entity.field_70181_x = Math.min((double)0.4f, entity.field_70181_x + (double)0.1f);
        }
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.POWERED_LADDER;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            state.func_189546_a(worldIn, pos, (Block)this, pos);
        }
    }
}

