/*
 * Decompiled with CFR 0.152.
 */
package com.animania.manual.groups;

import com.animania.common.handler.AddonHandler;
import com.animania.manual.groups.ManualPage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import scala.actors.threadpool.Arrays;

public class ManualTopic {
    private List<ManualPage> pages = new ArrayList<ManualPage>();
    private ResourceLocation id;
    private boolean isFirstPage;
    private String requiredModid = "animania";
    private String name;

    public ManualTopic(ResourceLocation id, boolean firstPage, String name, ManualPage ... pages) {
        this.pages = Arrays.asList((Object[])pages);
        this.id = id;
        this.isFirstPage = firstPage;
        this.name = name;
    }

    public ManualTopic(ResourceLocation id, boolean firstPage, String name, List<ManualPage> components) {
        this.pages = components;
        this.id = id;
        this.isFirstPage = firstPage;
        this.name = name;
    }

    public ManualTopic(ResourceLocation id, String name, ManualPage ... components) {
        this(id, false, name, components);
    }

    public List<ManualPage> getPages() {
        return this.pages;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    public String getRequiredModid() {
        return this.requiredModid;
    }

    public void setRequiredModid(String requiredModid) {
        this.requiredModid = requiredModid;
    }

    public boolean isPermitted() {
        return Loader.isModLoaded((String)this.requiredModid) || AddonHandler.isAddonLoaded(this.requiredModid);
    }

    public static boolean isPermitted(String requiredModid) {
        return Loader.isModLoaded((String)requiredModid) || AddonHandler.isAddonLoaded(requiredModid);
    }

    public String getName() {
        return this.name;
    }
}

