/*
 * Decompiled with CFR 0.152.
 */
package com.animania.manual.components;

import com.animania.manual.components.IManualComponent;
import com.animania.manual.gui.GuiManual;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class ItemComponent
implements IManualComponent {
    private ItemStack[] stacks;
    private GuiManual manual;
    private int x;
    private int y;
    private int absoluteX;
    private int absoluteY;
    private int objectWidth;
    private int objectHeight;
    private Minecraft mc;
    private static final int ITEM_OFFSET = 3;

    public ItemComponent(int x, int y, ItemStack[] stacks) {
        this.stacks = stacks;
        this.manual = GuiManual.INSTANCE;
        this.absoluteX = x + 36;
        this.absoluteY = y + 16;
        this.x = x;
        this.y = y;
        this.mc = Minecraft.func_71410_x();
        this.objectHeight = 16;
        this.objectWidth = 0;
        for (int i = 0; i < stacks.length; ++i) {
            this.objectWidth += 16;
            if (i == stacks.length - 1) continue;
            this.objectWidth += 3;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        int border = (114 - this.objectWidth) / 2;
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack stack = this.stacks[i];
            int posX = this.absoluteX + this.manual.guiLeft + border + i * 19;
            int posY = this.absoluteY + this.manual.guiTop;
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            this.manual.drawItemStack(stack, posX, posY, null);
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void drawLater(int mouseX, int mouseY, float partialTicks) {
        int border = (114 - this.objectWidth) / 2;
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack stack = this.stacks[i];
            int posX = this.absoluteX + this.manual.guiLeft + border + i * 19;
            int posY = this.absoluteY + this.manual.guiTop;
            if (mouseX <= posX || mouseX >= posX + 16 || mouseY <= posY || mouseY >= posY + 16) continue;
            GlStateManager.func_179094_E();
            this.manual.func_146285_a(stack, mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
        }
    }

    private boolean isHovering(int mouseX, int mouseY) {
        return mouseX > this.absoluteX + this.manual.guiLeft && mouseX < this.absoluteX + this.manual.guiLeft + this.objectWidth && mouseY > this.absoluteY + this.manual.guiTop && mouseY < this.absoluteY + this.manual.guiTop + this.objectHeight;
    }

    @Override
    public void onLeftClick() {
    }

    @Override
    public void onRightClick() {
    }

    @Override
    public int getObjectWidth() {
        return this.objectWidth;
    }

    @Override
    public int getObjectHeight() {
        return this.objectHeight;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public IManualComponent setX(int x) {
        this.x = x;
        this.absoluteX = x + 36;
        return this;
    }

    @Override
    public IManualComponent setY(int y) {
        this.y = y;
        this.absoluteY = y + 16;
        return this;
    }
}

