/*
 * Decompiled with CFR 0.152.
 */
package com.animania.manual.components;

import com.animania.Animania;
import com.animania.client.render.item.RenderAnimatedEgg;
import com.animania.manual.components.IManualComponent;
import com.animania.manual.gui.GuiManual;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityComponent
implements IManualComponent {
    private GuiManual manual = GuiManual.INSTANCE;
    private int x;
    private int y;
    private int absoluteX;
    private int absoluteY;
    private int objectWidth = 110;
    private int objectHeight = 35;
    private ResourceLocation[] entityLoc;
    private Minecraft mc;
    private float[] multiplier;
    private Entity[] entities;
    public static int renderTimer = 0;
    private int index = 0;
    private Entity currentEntity;

    public EntityComponent(int x, int y, ResourceLocation ... entities) {
        this.absoluteX = x + 36;
        this.absoluteY = y + 16;
        this.x = x;
        this.y = y;
        this.entityLoc = entities;
        this.entities = new Entity[entities.length];
        this.multiplier = new float[entities.length];
        this.mc = Minecraft.func_71410_x();
    }

    @Override
    public void init() {
        for (int i = 0; i < this.entityLoc.length; ++i) {
            try {
                WorldClient world = this.mc.field_71441_e;
                Entity e = EntityList.func_188429_b((ResourceLocation)this.entityLoc[i], (World)world);
                if (e == null) continue;
                float height = e.field_70131_O;
                float width = e.field_70130_N;
                float size = width * height;
                this.multiplier[i] = height > width ? (float)(17.5 / (double)height) : (width > height ? (float)(17.5 / (double)width) : (float)(17.5 / Math.sqrt(size)));
                e.func_70107_b(-2.0, -2.0, -2.0);
                this.entities[i] = e;
                continue;
            }
            catch (Exception e) {
                Animania.LOGGER.error((Object)e);
            }
        }
        this.currentEntity = this.entities[0];
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        if (this.currentEntity != null) {
            int border = (114 - this.objectWidth) / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            RenderHelper.func_74519_b();
            int size = 10;
            GlStateManager.func_179152_a((float)this.multiplier[this.index], (float)this.multiplier[this.index], (float)this.multiplier[this.index]);
            GlStateManager.func_179109_b((float)((float)(this.manual.guiLeft + this.absoluteX + 114 / 2) / this.multiplier[this.index]), (float)((float)(this.manual.guiTop + this.absoluteY + 27) / this.multiplier[this.index]), (float)2.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(360.0f * RenderAnimatedEgg.renderTimer), (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderEntityStatic(this.currentEntity);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179121_F();
        }
    }

    private void updateRenderEntity() {
        if (!GuiScreen.func_146272_n()) {
            if (renderTimer >= 79) {
                ++this.index;
                if (this.index == this.entityLoc.length) {
                    this.index = 0;
                }
            }
            this.currentEntity = this.entities[this.index];
        }
    }

    @Override
    public void update() {
        this.updateRenderEntity();
    }

    @Override
    public void drawLater(int mouseX, int mouseY, float partialTicks) {
        if (this.manual.isHovering(this, mouseX, mouseY)) {
            GlStateManager.func_179094_E();
            this.manual.func_146279_a(I18n.func_74838_a((String)("entity." + this.entityLoc[this.index] + ".name")), mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void onLeftClick() {
        this.init();
    }

    @Override
    public void onRightClick() {
    }

    @Override
    public int getObjectWidth() {
        return this.objectWidth;
    }

    @Override
    public int getObjectHeight() {
        return this.objectHeight;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public IManualComponent setX(int x) {
        this.x = x;
        this.absoluteX = x + 36;
        return this;
    }

    @Override
    public IManualComponent setY(int y) {
        this.y = y;
        this.absoluteY = y + 16;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderEntityStatic(Entity entity) {
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
    }

    @SideOnly(value=Side.CLIENT)
    private int getBrightnessForRender(Entity entity, EntityPlayer player) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v));
        if (entity.field_70170_p.func_175667_e((BlockPos)blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.func_185336_p(MathHelper.func_76128_c((double)(player.field_70163_u + (double)entity.func_70047_e())));
            return entity.field_70170_p.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void setLightmapDisabled(boolean disabled) {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        if (disabled) {
            GlStateManager.func_179090_x();
        } else {
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

