/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.handler;

import com.animania.Animania;
import com.animania.addons.template.TemplateAddon;
import com.animania.api.addons.AnimaniaAddon;
import com.animania.api.addons.LoadAddon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.MultipleModsErrored;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.DependencyParser;
import net.minecraftforge.fml.relauncher.Side;

public class AddonHandler {
    private static HashMap<String, AnimaniaAddon> loadedAddons = new HashMap();
    private static List<MissingModsException> missingModsExceptions = new ArrayList<MissingModsException>();

    public static void preInitCommon() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.preInitCommon();
        }
    }

    public static void initCommon() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.initCommon();
        }
    }

    public static void preInitClient() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.preInitClient();
        }
    }

    public static void initClient() {
        for (AnimaniaAddon a : loadedAddons.values()) {
            a.initClient();
        }
    }

    public static void loadAddons(ASMDataTable table) {
        Set asmData = table.getAll(LoadAddon.class.getCanonicalName());
        asmData.forEach(asm -> {
            try {
                Class<AnimaniaAddon> clazz = Class.forName(asm.getClassName()).asSubclass(AnimaniaAddon.class);
                AnimaniaAddon a = clazz.newInstance();
                if (loadedAddons.containsKey(a.getAddonID())) {
                    throw new RuntimeException("The addon with the id " + a.getAddonID() + " is already installed!");
                }
                loadedAddons.put(a.getAddonID(), a);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Animania.LOGGER.error((Object)e);
            }
        });
        loadedAddons.values().forEach(addon -> AddonHandler.register(addon));
    }

    public static void throwErrors() {
        if (!missingModsExceptions.isEmpty()) {
            MultipleModsErrored errors = new MultipleModsErrored(Collections.EMPTY_LIST, missingModsExceptions);
            Animania.proxy.throwCustomModLoadingErrorDisplayException(errors);
        }
    }

    public static boolean isAddonLoaded(String addonID) {
        return loadedAddons.get(addonID) != null;
    }

    private static void register(AnimaniaAddon addon) {
        if (addon == null) {
            return;
        }
        if (addon instanceof TemplateAddon) {
            return;
        }
        Map loadedMods = Loader.instance().getIndexedModList();
        DependencyParser parser = new DependencyParser(addon.getAddonID(), Side.SERVER);
        DependencyParser.DependencyInfo info = parser.parseDependencies(addon.getDependencies());
        for (ArtifactVersion dependency : info.dependencies) {
            ArtifactVersion modVersion;
            String modid = dependency.getLabel();
            if (modid == null) {
                throw new RuntimeException("Modid Dependency for " + addon.getAddonID() + " cannot be null.");
            }
            ModContainer container = (ModContainer)loadedMods.get(modid);
            if (container == null) {
                if (AddonHandler.isAddonLoaded(modid)) {
                    AnimaniaAddon depAddon = loadedAddons.get(modid);
                    DefaultArtifactVersion addonVersion = new DefaultArtifactVersion(modid, depAddon.getVersion());
                    if (!dependency.containsVersion((ArtifactVersion)addonVersion)) {
                        MissingModsException ex = new MissingModsException(addon.getAddonID(), addon.getAddonName());
                        ex.addMissingMod(dependency, (ArtifactVersion)addonVersion, true);
                        ex.missingMods.add(dependency);
                        missingModsExceptions.add(ex);
                        continue;
                    }
                } else {
                    MissingModsException ex = new MissingModsException(addon.getAddonID(), addon.getAddonName());
                    ex.addMissingMod(dependency, null, true);
                    ex.missingMods.add(dependency);
                    missingModsExceptions.add(ex);
                    continue;
                }
            }
            if (dependency.containsVersion(modVersion = container.getProcessedVersion())) continue;
            MissingModsException ex = new MissingModsException(addon.getAddonID(), addon.getAddonName());
            ex.addMissingMod(dependency, modVersion, true);
            ex.missingMods.add(dependency);
            missingModsExceptions.add(ex);
        }
        AddonHandler.addAddonResourcePack(addon);
        Animania.LOGGER.info("Loaded Addon " + addon.getAddonName() + " with id " + addon.getAddonID() + " and Class " + addon.getClass().getName());
    }

    private static void addAddonResourcePack(AnimaniaAddon addon) {
        Animania.proxy.addAddonResourcePack(addon);
    }
}

