/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.Animania;
import com.animania.api.interfaces.IFoodEating;
import com.animania.api.interfaces.IImpregnable;
import com.animania.api.interfaces.IMateable;
import com.animania.api.interfaces.ISleeping;
import com.animania.api.interfaces.ISterilizable;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.World;

public class GenericAIMate<T extends EntityCreature & IFoodEating, O extends EntityCreature & IFoodEating & IImpregnable>
extends EntityAIBase {
    private final T entity;
    World theWorld;
    private O targetMate;
    int courtshipTimer;
    double moveSpeed;
    private int delayCounter;
    private Class female;
    private Class child;
    private Class base;

    public GenericAIMate(T animal, double speedIn, Class other, Class child, Class base) {
        this.entity = animal;
        this.theWorld = ((EntityCreature)animal).field_70170_p;
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
        this.courtshipTimer = 20;
        this.delayCounter = 0;
        this.female = other;
        this.child = child;
        this.base = base;
    }

    public boolean func_75250_a() {
        ++this.delayCounter;
        if (this.delayCounter > AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            if (this.entity instanceof ISterilizable && ((ISterilizable)this.entity).getSterilized()) {
                this.delayCounter = 0;
                return false;
            }
            if (((ISleeping)this.entity).getSleeping()) {
                this.delayCounter = 0;
                return false;
            }
            if (this.child.isInstance(this.entity) || this.female.isInstance(this.entity) || this.entity.func_70090_H()) {
                this.delayCounter = 0;
                return false;
            }
            List similarAnimalsInRange = AnimaniaHelper.getEntitiesInRange(this.base, (double)AnimaniaConfig.gameRules.animalCapSearchRange, this.theWorld, this.entity);
            if (similarAnimalsInRange.size() + 1 >= AnimaniaConfig.careAndFeeding.entityBreedingLimit) {
                this.delayCounter = 0;
                return false;
            }
            if (AnimaniaConfig.gameRules.requireAnimalInteractionForAI && !((IFoodEating)this.entity).getInteracted()) {
                this.delayCounter = 0;
                return false;
            }
            if (AnimaniaConfig.careAndFeeding.feedToBreed && !((IFoodEating)this.entity).getHandFed()) {
                this.delayCounter = 0;
                return false;
            }
            if (!((IFoodEating)this.entity).getFed() || !((IFoodEating)this.entity).getWatered()) {
                this.delayCounter = 0;
                return false;
            }
            this.targetMate = this.getNearbyMate();
            if (this.targetMate != null && Animania.RANDOM.nextInt(20) == 0) {
                this.delayCounter = 0;
                this.func_75251_c();
                return false;
            }
            return this.targetMate != null;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.targetMate != null) {
            return this.targetMate.func_70089_S();
        }
        return false;
    }

    public void func_75251_c() {
        this.targetMate = null;
    }

    public void func_75246_d() {
        if (this.targetMate != null) {
            boolean uuidbool;
            UUID targetMateUUID = ((IMateable)this.targetMate).getMateUniqueId();
            boolean preg = ((IImpregnable)this.targetMate).getPregnant();
            boolean fertile = ((IImpregnable)this.targetMate).getFertile();
            boolean bl = targetMateUUID == null ? false : (uuidbool = !targetMateUUID.equals(this.entity.func_110124_au()));
            if (uuidbool || preg || !fertile) {
                this.targetMate.func_70661_as().func_75499_g();
                this.courtshipTimer = 200;
                this.func_75251_c();
                this.entity.func_70661_as().func_75499_g();
                return;
            }
            --this.courtshipTimer;
            if (this.courtshipTimer >= 0) {
                double distance;
                if (this.courtshipTimer % 20 == 0) {
                    this.entity.func_70671_ap().func_75651_a(this.targetMate, 10.0f, (float)this.entity.func_70646_bf());
                    this.entity.func_70661_as().func_75497_a(this.targetMate, this.moveSpeed);
                    this.targetMate.func_70671_ap().func_75651_a(this.entity, 10.0f, (float)this.targetMate.func_70646_bf());
                    this.targetMate.func_70661_as().func_75497_a(this.entity, this.moveSpeed);
                }
                if ((distance = (double)this.entity.func_70032_d(this.targetMate)) <= 1.8) {
                    ((IMateable)this.entity).setInLove(null);
                    ((IMateable)this.entity).setMateUniqueId(this.targetMate.getPersistentID());
                    ((IMateable)this.targetMate).setInLove(null);
                    ((IImpregnable)this.targetMate).setPregnant(true);
                    ((IImpregnable)this.targetMate).setFertile(false);
                    ((IFoodEating)this.targetMate).setHandFed(false);
                    ((IFoodEating)this.targetMate).setInteracted(((IFoodEating)this.entity).getInteracted());
                    ((IMateable)this.targetMate).setMateUniqueId(this.entity.getPersistentID());
                    this.targetMate.func_70661_as().func_75499_g();
                    this.courtshipTimer = 200;
                    this.func_75251_c();
                    this.entity.func_70661_as().func_75499_g();
                }
            } else {
                this.targetMate.func_70661_as().func_75499_g();
                this.courtshipTimer = 200;
                this.func_75251_c();
                this.entity.func_70661_as().func_75499_g();
                this.delayCounter = -2000;
            }
        }
    }

    private O getNearbyMate() {
        T male = this.entity;
        UUID mateID = null;
        if (((IMateable)male).getMateUniqueId() != null) {
            mateID = ((IMateable)male).getMateUniqueId();
        }
        if (AnimaniaConfig.careAndFeeding.malesMateMultipleFemales) {
            mateID = null;
        }
        if (mateID != null) {
            List entities = AnimaniaHelper.getEntitiesInRange(this.female, 5.0, ((EntityCreature)this.entity).field_70170_p, this.entity);
            for (int k = 0; k <= entities.size() - 1; ++k) {
                EntityCreature female = (EntityCreature)entities.get(k);
                if (female == null) continue;
                boolean allowBreeding = true;
                if (AnimaniaConfig.careAndFeeding.feedToBreed && female instanceof IFoodEating && !((IFoodEating)female).getHandFed()) {
                    allowBreeding = false;
                }
                if (!female.getPersistentID().equals(mateID) || !((IImpregnable)female).getFertile() || !(female instanceof ISleeping) || ((ISleeping)female).getSleeping() || ((IImpregnable)female).getPregnant() || !allowBreeding || !female.func_70685_l(male) || !((IFoodEating)female).getWatered() || !((IFoodEating)female).getFed()) continue;
                this.courtshipTimer = 200;
                return (O)female;
            }
        } else {
            List entities = AnimaniaHelper.getEntitiesInRange(this.female, 8.0, ((EntityCreature)this.entity).field_70170_p, this.entity);
            for (int k = 0; k <= entities.size() - 1; ++k) {
                EntityCreature female = (EntityCreature)entities.get(k);
                boolean allowBreeding = true;
                if (AnimaniaConfig.careAndFeeding.feedToBreed && !((IFoodEating)female).getHandFed()) {
                    allowBreeding = false;
                }
                --this.courtshipTimer;
                if (!(AnimaniaConfig.careAndFeeding.malesMateMultipleFemales ? ((IMateable)female).getMateUniqueId() == null || ((IMateable)female).getMateUniqueId().equals(this.entity.getPersistentID()) : ((IMateable)female).getMateUniqueId() == null) || !((IImpregnable)female).getFertile() || ((ISleeping)female).getSleeping() || ((IImpregnable)female).getPregnant() || !allowBreeding || !female.func_70685_l(male) || !((IFoodEating)female).getWatered() || !((IFoodEating)female).getFed()) continue;
                this.courtshipTimer = 200;
                return (O)female;
            }
        }
        this.delayCounter = 0;
        return null;
    }
}

