/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.chickens.ai;

import com.animania.common.entities.chickens.ChickenLeghorn;
import com.animania.common.entities.chickens.ChickenOrpington;
import com.animania.common.entities.chickens.ChickenPlymouthRock;
import com.animania.common.entities.chickens.ChickenRhodeIslandRed;
import com.animania.common.entities.chickens.ChickenWyandotte;
import com.animania.common.entities.chickens.EntityAnimaniaChicken;
import com.animania.common.entities.chickens.EntityHenBase;
import com.animania.common.handler.BlockHandler;
import com.animania.common.handler.ItemHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.TileEntityNest;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIFindNest
extends EntityAIBase {
    private final EntityAnimaniaChicken temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private EntityPlayer temptingPlayer;
    private boolean isRunning;
    private int delayTemptCounter;

    public EntityAIFindNest(EntityAnimaniaChicken temptedEntityIn, double speedIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.func_75248_a(3);
        this.delayTemptCounter = 0;
    }

    public boolean func_75250_a() {
        ++this.delayTemptCounter;
        if (this.delayTemptCounter < AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            return false;
        }
        if (this.delayTemptCounter > AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            EntityHenBase entity;
            if (!this.temptedEntity.field_70170_p.func_72935_r() || this.temptedEntity.getSleeping()) {
                this.delayTemptCounter = 0;
                return false;
            }
            if (!(!(this.temptedEntity instanceof EntityHenBase) || (entity = (EntityHenBase)this.temptedEntity).getWatered() && entity.getFed())) {
                this.delayTemptCounter = 0;
                return false;
            }
            if (this.temptedEntity.func_70681_au().nextInt(100) == 0) {
                Vec3d vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.temptedEntity, (int)20, (int)4);
                if (vec3d != null) {
                    this.delayTemptCounter = 0;
                    this.func_75251_c();
                    this.temptedEntity.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.speed);
                    this.temptedEntity.func_70671_ap().func_75650_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.0f, 0.0f);
                }
                return false;
            }
            BlockPos currentpos = new BlockPos(this.temptedEntity.field_70165_t, this.temptedEntity.field_70163_u, this.temptedEntity.field_70161_v);
            Block poschk = this.temptedEntity.field_70170_p.func_180495_p(currentpos).func_177230_c();
            if (poschk == BlockHandler.blockNest) {
                TileEntityNest te = (TileEntityNest)this.temptedEntity.field_70170_p.func_175625_s(currentpos);
                if (te.itemHandler.getStackInSlot(0).func_190916_E() >= 3) {
                    this.delayTemptCounter = 0;
                    return false;
                }
                if (this.temptedEntity instanceof ChickenLeghorn.EntityHenLeghorn || this.temptedEntity instanceof ChickenOrpington.EntityHenOrpington || this.temptedEntity instanceof ChickenPlymouthRock.EntityHenPlymouthRock) {
                    EntityHenBase entity2 = (EntityHenBase)this.temptedEntity;
                    if (!(te == null || te.getNestContent() != TileEntityNest.NestContent.EMPTY && te.getNestContent() != TileEntityNest.NestContent.CHICKEN_WHITE || entity2.getLaid() || te.getNestContent() == TileEntityNest.NestContent.CHICKEN_WHITE && entity2.type != te.birdType || !te.insertItem(new ItemStack(Items.field_151110_aK)))) {
                        entity2.setLaid(true);
                        te.birdType = entity2.type;
                        this.func_75251_c();
                        te.func_70296_d();
                    }
                } else if (this.temptedEntity instanceof ChickenRhodeIslandRed.EntityHenRhodeIslandRed || this.temptedEntity instanceof ChickenWyandotte.EntityHenWyandotte) {
                    EntityHenBase hen = (EntityHenBase)this.temptedEntity;
                    if (!(te == null || te.getNestContent() != TileEntityNest.NestContent.EMPTY && te.getNestContent() != TileEntityNest.NestContent.CHICKEN_BROWN || hen.getLaid() || te.getNestContent() == TileEntityNest.NestContent.CHICKEN_BROWN && hen.type != te.birdType || !te.insertItem(new ItemStack(ItemHandler.brownEgg)))) {
                        hen.setLaid(true);
                        te.birdType = hen.type;
                        this.func_75251_c();
                        te.func_70296_d();
                    }
                }
                this.delayTemptCounter = 0;
                return false;
            }
            double x = this.temptedEntity.field_70165_t;
            double y = this.temptedEntity.field_70163_u;
            double z = this.temptedEntity.field_70161_v;
            boolean nestFound = false;
            BlockPos pos = new BlockPos(x, y, z);
            for (int i = -10; i < 10; ++i) {
                for (int j = -3; j < 3; ++j) {
                    for (int k = -10; k < 10; ++k) {
                        TileEntityNest te;
                        TileEntityNest.NestContent nestType;
                        pos = new BlockPos(x + (double)i, y + (double)j, z + (double)k);
                        Block blockchk = this.temptedEntity.field_70170_p.func_180495_p(pos).func_177230_c();
                        List<EntityHenBase> others = AnimaniaHelper.getEntitiesInRange(EntityHenBase.class, 3.0, this.temptedEntity.field_70170_p, pos);
                        if (blockchk != BlockHandler.blockNest || others.size() != 0 || (nestType = (te = (TileEntityNest)this.temptedEntity.field_70170_p.func_175625_s(pos)).getNestContent()) != TileEntityNest.NestContent.CHICKEN_BROWN && nestType != TileEntityNest.NestContent.CHICKEN_WHITE && nestType != TileEntityNest.NestContent.EMPTY) continue;
                        if (this.temptedEntity instanceof ChickenLeghorn.EntityHenLeghorn && (nestType == TileEntityNest.NestContent.CHICKEN_WHITE ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                            nestFound = true;
                            return true;
                        }
                        if (this.temptedEntity instanceof ChickenOrpington.EntityHenOrpington && (nestType == TileEntityNest.NestContent.CHICKEN_WHITE ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                            nestFound = true;
                            return true;
                        }
                        if (this.temptedEntity instanceof ChickenPlymouthRock.EntityHenPlymouthRock && (nestType == TileEntityNest.NestContent.CHICKEN_WHITE ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                            nestFound = true;
                            return true;
                        }
                        if (this.temptedEntity instanceof ChickenRhodeIslandRed.EntityHenRhodeIslandRed && (nestType == TileEntityNest.NestContent.CHICKEN_BROWN ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                            nestFound = true;
                            return true;
                        }
                        if (!(this.temptedEntity instanceof ChickenWyandotte.EntityHenWyandotte) || !(nestType == TileEntityNest.NestContent.CHICKEN_BROWN ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) continue;
                        nestFound = true;
                        return true;
                    }
                }
            }
            if (!nestFound) {
                this.delayTemptCounter = 0;
                return false;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.temptedEntity.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.isRunning = false;
    }

    public void func_75249_e() {
        double x = this.temptedEntity.field_70165_t;
        double y = this.temptedEntity.field_70163_u;
        double z = this.temptedEntity.field_70161_v;
        BlockPos currentpos = new BlockPos(x, y, z);
        Block poschk = this.temptedEntity.field_70170_p.func_180495_p(currentpos).func_177230_c();
        if (poschk != BlockHandler.blockNest) {
            boolean nestFound = false;
            int loc = 24;
            int newloc = 24;
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos nestPos = new BlockPos(x, y, z);
            for (int i = -10; i < 10; ++i) {
                for (int j = -3; j < 3; ++j) {
                    for (int k = -10; k < 10; ++k) {
                        BlockPos nestPoschk;
                        Block nestBlockchk;
                        pos = new BlockPos(x + (double)i, y + (double)j, z + (double)k);
                        Block blockchk = this.temptedEntity.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (blockchk != BlockHandler.blockNest || this.temptedEntity.func_70781_l()) continue;
                        TileEntityNest te = (TileEntityNest)this.temptedEntity.field_70170_p.func_175625_s(pos);
                        TileEntityNest.NestContent nestType = te.getNestContent();
                        if (nestType == TileEntityNest.NestContent.CHICKEN_BROWN || nestType == TileEntityNest.NestContent.CHICKEN_WHITE || nestType == TileEntityNest.NestContent.EMPTY) {
                            if (this.temptedEntity instanceof ChickenLeghorn.EntityHenLeghorn && (nestType == TileEntityNest.NestContent.CHICKEN_WHITE ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                                nestFound = true;
                            } else if (this.temptedEntity instanceof ChickenOrpington.EntityHenOrpington && (nestType == TileEntityNest.NestContent.CHICKEN_WHITE ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                                nestFound = true;
                            } else if (this.temptedEntity instanceof ChickenPlymouthRock.EntityHenPlymouthRock && (nestType == TileEntityNest.NestContent.CHICKEN_WHITE ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                                nestFound = true;
                            } else if (this.temptedEntity instanceof ChickenRhodeIslandRed.EntityHenRhodeIslandRed && (nestType == TileEntityNest.NestContent.CHICKEN_BROWN ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                                nestFound = true;
                            } else if (this.temptedEntity instanceof ChickenWyandotte.EntityHenWyandotte && (nestType == TileEntityNest.NestContent.CHICKEN_BROWN ? ((EntityHenBase)this.temptedEntity).type == te.birdType : nestType == TileEntityNest.NestContent.EMPTY)) {
                                nestFound = true;
                            }
                        }
                        if (!nestFound || (newloc = Math.abs(i) + Math.abs(j) + Math.abs(k)) >= loc) continue;
                        loc = newloc;
                        if (this.temptedEntity.field_70165_t < (double)nestPos.func_177958_n() && (nestBlockchk = this.temptedEntity.field_70170_p.func_180495_p(nestPoschk = new BlockPos(x + (double)i + 1.0, y + (double)j, z + (double)k)).func_177230_c()) == BlockHandler.blockNest) {
                            ++i;
                        }
                        if (this.temptedEntity.field_70161_v < (double)nestPos.func_177952_p() && (nestBlockchk = this.temptedEntity.field_70170_p.func_180495_p(nestPoschk = new BlockPos(x + (double)i, y + (double)j, z + (double)k + 1.0)).func_177230_c()) == BlockHandler.blockNest) {
                            ++k;
                        }
                        nestPos = new BlockPos(x + (double)i, y + (double)j, z + (double)k);
                    }
                }
            }
            if (nestFound) {
                Block nestBlockchk = this.temptedEntity.field_70170_p.func_180495_p(nestPos).func_177230_c();
                List nestClear = this.temptedEntity.field_70170_p.func_72839_b((Entity)this.temptedEntity, this.temptedEntity.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0));
                if (nestBlockchk == BlockHandler.blockNest && nestClear.isEmpty()) {
                    this.temptedEntity.func_70661_as().func_75492_a((double)nestPos.func_177958_n() + 0.5, (double)nestPos.func_177956_o(), (double)nestPos.func_177952_p() + 0.5, this.speed);
                    this.temptedEntity.func_70671_ap().func_75650_a((double)nestPos.func_177958_n(), (double)nestPos.func_177956_o(), (double)nestPos.func_177952_p(), 10.0f, 10.0f);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

