/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.chickens;

import com.animania.client.models.ModelChick;
import com.animania.client.render.layer.LayerBlinking;
import com.animania.common.entities.chickens.EntityAnimaniaChicken;
import com.animania.common.entities.chickens.EntityChickBase;
import com.animania.common.handler.BlockHandler;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderChickBase<T extends EntityChickBase>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    LayerBlinking blinkingLayer = new LayerBlinking(this, new ResourceLocation("animania:textures/entity/chickens/chick_blink.png"), 0);

    public RenderChickBase(RenderManager rm) {
        super(rm, (ModelBase)new ModelChick(), 0.2f);
        this.func_177094_a(this.blinkingLayer);
    }

    protected float handleRotationFloat(T livingBase, float partialTicks) {
        float f = ((EntityChickBase)livingBase).field_70888_h + (((EntityChickBase)livingBase).field_70886_e - ((EntityChickBase)livingBase).field_70888_h) * partialTicks;
        float f1 = ((EntityChickBase)livingBase).field_70884_g + (((EntityChickBase)livingBase).field_70883_f - ((EntityChickBase)livingBase).field_70884_g) * partialTicks;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected void preRenderCallback(T entityliving, float f) {
        this.preRenderScale(entityliving, f);
        this.blinkingLayer.setColors(((EntityChickBase)entityliving).lidCol, ((EntityChickBase)entityliving).lidCol);
    }

    protected void preRenderScale(T entity, float f) {
        float age = entity.getEntityAge();
        GL11.glScalef((float)(1.0f + age / ((EntityChickBase)entity).getSizeDividend()), (float)(1.0f + age / ((EntityChickBase)entity).getSizeDividend()), (float)(1.0f + age / ((EntityChickBase)entity).getSizeDividend()));
        double x = ((EntityChickBase)entity).field_70165_t;
        double y = ((EntityChickBase)entity).field_70163_u;
        double z = ((EntityChickBase)entity).field_70161_v;
        BlockPos pos = new BlockPos(x, y, z);
        Block blockchk = ((EntityChickBase)entity).field_70170_p.func_180495_p(pos).func_177230_c();
        T entityChk = entity;
        if (blockchk == BlockHandler.blockNest || entityChk.getSleeping()) {
            this.field_76989_e = 0.0f;
            GlStateManager.func_179109_b((float)-0.25f, (float)0.1f, (float)-0.25f);
        } else {
            this.field_76989_e = 0.2f;
            entityChk.setSleeping(false);
        }
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return ((EntityAnimaniaChicken)entity).getResourceLocation();
    }

    static class Factory<T extends EntityChickBase>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderChickBase(manager);
        }
    }
}

