/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import betterwithaddons.item.ItemTeaCup;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.ItemUtil;
import betterwithaddons.util.NabeResult;
import betterwithaddons.util.StackResult;
import betterwithaddons.util.TeaType;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public class NabeResultTea
extends NabeResult {
    public int doses;
    public int maxDoses;
    public ArrayList<PotionEffect> effects = new ArrayList();
    public TeaType mainType;
    public int strength;
    public int milk;
    public int sugar;
    public boolean isCeremonial;

    public NabeResultTea() {
        super(new ResourceLocation("betterwithaddons", "blocks/nabe_liquid"), 0);
    }

    public NabeResultTea(int color, int doses, int maxDoses) {
        super(new ResourceLocation("betterwithaddons", "blocks/nabe_liquid"), color);
        this.doses = doses;
        this.maxDoses = maxDoses;
    }

    @Override
    public float getFillRatio() {
        return (float)this.doses / (float)this.maxDoses;
    }

    @Override
    public boolean isFull() {
        return this.doses >= this.maxDoses;
    }

    @Override
    public StackResult take(ItemStack container) {
        if (this.doses <= 0) {
            return new StackResult(false, container);
        }
        if (container.func_77973_b() == ModItems.TEA_CUP && !ItemTeaCup.isFilled(container)) {
            container.func_190918_g(1);
            --this.doses;
            return new StackResult(true, container, ModItems.TEA_CUP.getFilled(this));
        }
        return new StackResult(false, container);
    }

    @Override
    public NabeResult copy() {
        NabeResultTea result = new NabeResultTea(this.color, this.doses, this.maxDoses);
        result.mainType = this.mainType;
        result.strength = this.strength;
        result.milk = this.milk;
        result.sugar = this.sugar;
        result.effects.addAll(this.effects);
        return result;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a("teaType", this.mainType.getName());
        compound.func_74768_a("doses", this.doses);
        compound.func_74768_a("maxDoses", this.maxDoses);
        compound.func_74768_a("strength", this.strength);
        compound.func_74768_a("milk", this.milk);
        compound.func_74768_a("sugar", this.sugar);
        compound.func_74782_a("effects", (NBTBase)ItemUtil.serializePotionEffects(this.effects));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.mainType = TeaType.getType(compound.func_74779_i("teaType"));
        this.doses = compound.func_74762_e("doses");
        this.maxDoses = compound.func_74762_e("maxDoses");
        this.strength = compound.func_74762_e("strength");
        this.milk = compound.func_74762_e("milk");
        this.sugar = compound.func_74762_e("sugar");
        this.effects.addAll(ItemUtil.deserializePotionEffects(compound.func_150295_c("effects", 10)));
    }
}

