/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import betterwithaddons.util.IHasSize;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtil {
    public static ItemArmor.ArmorMaterial getArmorMaterial(Item item) {
        try {
            if (item instanceof ItemArmor) {
                return ((ItemArmor)item).func_82812_d();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Item.ToolMaterial getToolMaterial(Item item) {
        try {
            if (item instanceof ItemTool) {
                return ((ItemTool)item).field_77862_b;
            }
            if (item instanceof ItemSword) {
                return ((ItemSword)item).field_150933_b;
            }
            if (item instanceof ItemHoe) {
                return ((ItemHoe)item).field_77843_a;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean matchesOreDict(ItemStack stack, String oreDictName) {
        if (stack.func_190926_b()) {
            return false;
        }
        int checkid = OreDictionary.getOreID((String)oreDictName);
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (id != checkid) continue;
            return true;
        }
        return false;
    }

    public static boolean areItemStackContentEqual(ItemStack is1, ItemStack is2) {
        if (is1.func_190926_b() || is2.func_190926_b()) {
            return false;
        }
        if (is1.func_77973_b() != is2.func_77973_b()) {
            return false;
        }
        if (!ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2)) {
            return false;
        }
        return is1.func_77952_i() == is2.func_77952_i();
    }

    public static boolean areOreDictionaried(ItemStack is1, ItemStack is2) {
        if (is1.func_190926_b() || is2.func_190926_b()) {
            return false;
        }
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)is1);
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)is2);
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTool(Item item) {
        return item instanceof ItemTool || item instanceof ItemArmor || item instanceof ItemSword || item instanceof ItemShears || item instanceof ItemBow || item instanceof ItemHoe;
    }

    public static boolean consumeItem(List<EntityItem> inv, Ingredient ingredient) {
        int amount = ingredient instanceof IHasSize ? ((IHasSize)ingredient).getSize() : 1;
        for (EntityItem ent : inv) {
            ItemStack item = ent.func_92059_d();
            if (!ingredient.apply(item)) continue;
            amount -= ItemUtil.consumeItem(ent, amount);
        }
        return amount <= 0;
    }

    public static int consumeItem(EntityItem item, int n) {
        ItemStack entstack = item.func_92059_d().func_77946_l();
        int removed = Math.min(n, entstack.func_190916_E());
        entstack.func_190918_g(removed);
        if (entstack.func_190916_E() <= 0) {
            item.func_70106_y();
        } else {
            item.func_92058_a(entstack);
        }
        return removed;
    }

    public static NBTTagList serializePotionEffects(List<PotionEffect> effects) {
        NBTTagList potionList = new NBTTagList();
        for (PotionEffect effect : effects) {
            potionList.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
        }
        return potionList;
    }

    public static List<PotionEffect> deserializePotionEffects(NBTTagList potionList) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (int i = 0; i < potionList.func_74745_c(); ++i) {
            effects.add(PotionEffect.func_82722_b((NBTTagCompound)potionList.func_150305_b(i)));
        }
        return effects;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPotionEffectTooltip(List<PotionEffect> list, List<String> lores, float durationFactor) {
        ArrayList attributeModifiers = Lists.newArrayList();
        if (list.isEmpty()) {
            String s = I18n.func_135052_a((String)"effect.none", (Object[])new Object[0]).trim();
            lores.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = I18n.func_135052_a((String)potioneffect.func_76453_d(), (Object[])new Object[0]).trim();
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        attributeModifiers.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + I18n.func_135052_a((String)("potion.potency." + potioneffect.func_76458_c()), (Object[])new Object[0]).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)potioneffect, (float)durationFactor) + ")";
                }
                if (potion.func_76398_f()) {
                    lores.add(TextFormatting.RED + s1);
                    continue;
                }
                lores.add(TextFormatting.BLUE + s1);
            }
        }
        if (!attributeModifiers.isEmpty()) {
            lores.add("");
            lores.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"potion.whenDrank", (Object[])new Object[0]));
            for (Tuple tuple : attributeModifiers) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add(TextFormatting.BLUE + I18n.func_135052_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add(TextFormatting.RED + I18n.func_135052_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_135052_a((String)("attribute.name." + (String)tuple.func_76341_a()), (Object[])new Object[0])}));
            }
        }
    }
}

