/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.entity.EntityArtifactFrame;
import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.item.ModItems;
import betterwithaddons.tileentity.QueueItemStackHandler;
import betterwithaddons.tileentity.TileEntityBase;
import betterwithaddons.util.IDirtyHandler;
import betterwithaddons.util.ItemUtil;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLegendarium
extends TileEntityBase
implements ITickable {
    private long lastClick = 0L;
    private long lastTurnIn = 0L;
    private CanvasType canvasType = CanvasType.Normal;
    QueueItemStackHandler migrationQueue;
    IItemHandler readonlyHandler = new IItemHandler(){

        public int getSlots() {
            IItemHandler queue = TileEntityLegendarium.this.getInventory();
            return queue.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            IItemHandler queue = TileEntityLegendarium.this.getInventory();
            return queue.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            IItemHandler queue = TileEntityLegendarium.this.getInventory();
            return queue.getSlotLimit(slot);
        }
    };

    public CanvasType getCanvasType() {
        return this.canvasType;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        if (this.migrationQueue != null) {
            compound.func_74782_a("Queue", (NBTBase)this.migrationQueue.serializeNBT());
        }
        compound.func_74772_a("LastTurnIn", this.lastTurnIn);
        compound.func_74768_a("CanvasType", this.canvasType.ordinal());
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Queue")) {
            this.migrationQueue = new QueueItemStackHandler(null);
            this.migrationQueue.deserializeNBT(compound.func_74775_l("Queue"));
        }
        this.lastTurnIn = compound.func_74763_f("LastTurnIn");
        this.canvasType = CanvasType.values()[compound.func_74762_e("CanvasType")];
    }

    private void migrate() {
        LegendariumData data = LegendariumData.getInstance(this.field_145850_b);
        while (this.migrationQueue.getSlots() > 0) {
            ItemStack stack = this.migrationQueue.extractItem(0, 1, false);
            data.queue.insertItem(0, stack, false);
        }
        this.migrationQueue = null;
    }

    public ItemStack insertItem(EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
            Block block = itemBlock.func_179223_d();
            IBlockState state = block.func_176223_P();
            boolean changed = false;
            Material material = state.func_185904_a();
            if (block instanceof BlockPane && material == Material.field_151592_s) {
                this.canvasType = this.canvasType != CanvasType.Invisible ? CanvasType.Invisible : CanvasType.Normal;
                changed = true;
            } else if (block instanceof BlockCarpet && (material == Material.field_151593_r || material == Material.field_151580_n)) {
                this.canvasType = this.canvasType != CanvasType.Flat ? CanvasType.Flat : CanvasType.Normal;
                changed = true;
            }
            if (changed) {
                this.func_70296_d();
                this.syncTE();
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.legendarium.canvas_changed." + this.canvasType.name().toLowerCase(), new Object[0]), true);
            }
            return stack;
        }
        if (stack.func_77973_b() == ModItems.ARTIFACT_FRAME) {
            if (this.cleanItemFrames() == 0) {
                this.populateItemFrames();
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.legendarium.frames_populated", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.legendarium.frames_cleared", new Object[0]), true);
            }
            return stack;
        }
        String analysis = this.analyzeItem(stack);
        if (analysis != null) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.legendarium." + analysis, new Object[0]), true);
            return stack;
        }
        long timeUntilNextTurnIn = this.lastTurnIn + (long)InteractionBWA.LEGENDARIUM_TURN_IN_DELAY - this.field_145850_b.func_82737_E();
        if (timeUntilNextTurnIn > 0L) {
            long days = timeUntilNextTurnIn / 24000L;
            long hours = timeUntilNextTurnIn % 24000L / 1000L;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.legendarium.not_now", new Object[]{days, hours}), true);
            return stack;
        }
        IItemHandler queue = this.getInventory();
        ItemStack retain = queue.insertItem(0, ModItems.BROKEN_ARTIFACT.makeFrom(stack), false);
        if (retain.func_190926_b()) {
            this.lastTurnIn = this.field_145850_b.func_82737_E();
        }
        if (queue.getSlots() >= InteractionBWA.LEGENDARIUM_MIN_QUEUE_SIZE) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.legendarium.ready", new Object[0]), true);
        }
        return retain;
    }

    public String analyzeItem(ItemStack stack) {
        double maxDamage;
        if (stack.func_190926_b()) {
            return "not_item";
        }
        if (!ItemUtil.isTool(stack.func_77973_b())) {
            return "not_tool";
        }
        if (!stack.func_82837_s() && InteractionBWA.LEGENDARIUM_MUST_BE_NAMED) {
            return "not_artifact";
        }
        if (!stack.func_77948_v() && InteractionBWA.LEGENDARIUM_MUST_BE_ENCHANTED) {
            return "not_artifact";
        }
        int actualDamage = stack.func_77958_k() - stack.func_77952_i();
        if ((double)actualDamage > (maxDamage = (double)stack.func_77958_k() * InteractionBWA.LEGENDARIUM_MIN_DAMAGE + (double)InteractionBWA.LEGENDARIUM_DAMAGE_PAD)) {
            return "not_broken";
        }
        if (stack.func_82838_A() <= 30 && InteractionBWA.LEGENDARIUM_MUST_BE_LIMIT) {
            return "not_at_limit";
        }
        return null;
    }

    public ItemStack retrieveItem(EntityPlayer player) {
        long time = this.field_145850_b.func_82737_E();
        IItemHandler queue = this.getInventory();
        if (queue.getSlots() < InteractionBWA.LEGENDARIUM_MIN_QUEUE_SIZE) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.legendarium.not_enough_artifacts", new Object[0]), true);
            return ItemStack.field_190927_a;
        }
        if (time - this.lastClick > 3L && queue.getSlots() >= InteractionBWA.LEGENDARIUM_MIN_QUEUE_SIZE) {
            this.lastClick = time;
            ItemStack retrieved = queue.extractItem(0, 1, false);
            this.populateItemFrames();
            return retrieved;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.readonlyHandler);
        }
        return super.getCapability(capability, facing);
    }

    public IItemHandler getInventory() {
        LegendariumData data = LegendariumData.getInstance(this.field_145850_b);
        return data.queue;
    }

    private void populateItemFrames() {
        int posterRange = InteractionBWA.LEGENDARIUM_POSTER_RANGE;
        AxisAlignedBB posterArea = new AxisAlignedBB(this.field_174879_c.func_177982_a(-posterRange, -posterRange, -posterRange), this.field_174879_c.func_177982_a(posterRange, posterRange, posterRange));
        List frames = this.field_145850_b.func_175647_a(EntityArtifactFrame.class, posterArea, frame -> !frame.isLinked());
        frames.sort(Comparator.comparingDouble(o -> o.func_174818_b(this.func_174877_v())));
        int i = 0;
        for (EntityArtifactFrame frame2 : frames) {
            frame2.link(this, i);
            ++i;
        }
    }

    private int cleanItemFrames() {
        int posterRange = InteractionBWA.LEGENDARIUM_POSTER_RANGE;
        AxisAlignedBB posterArea = new AxisAlignedBB(this.field_174879_c.func_177982_a(-posterRange, -posterRange, -posterRange), this.field_174879_c.func_177982_a(posterRange, posterRange, posterRange));
        List frames = this.field_145850_b.func_175647_a(EntityArtifactFrame.class, posterArea, frame -> frame.isLinked());
        int ret = 0;
        for (EntityArtifactFrame frame2 : frames) {
            frame2.unlink();
            ++ret;
        }
        return ret;
    }

    public void func_73660_a() {
        if (this.migrationQueue != null) {
            this.migrate();
        }
    }

    public static class LegendariumData
    extends WorldSavedData
    implements IDirtyHandler {
        public static final String ID = "LegendariumInfo";
        QueueItemStackHandler queue = new QueueItemStackHandler(this);

        public LegendariumData(String id) {
            super(id);
        }

        public void func_76184_a(NBTTagCompound compound) {
            this.queue.deserializeNBT(compound.func_74775_l("Queue"));
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            compound.func_74782_a("Queue", (NBTBase)this.queue.serializeNBT());
            return compound;
        }

        public static LegendariumData getInstance(World world) {
            if (world != null) {
                WorldSavedData handler = world.getPerWorldStorage().func_75742_a(LegendariumData.class, ID);
                if (handler == null) {
                    handler = new LegendariumData(ID);
                    world.getPerWorldStorage().func_75745_a(ID, handler);
                }
                return (LegendariumData)handler;
            }
            return null;
        }
    }

    public static enum CanvasType {
        Normal,
        Flat,
        Invisible;

    }
}

