/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.BlockBannerDetector;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.tileentity.TileEntityBase;
import betterwithaddons.util.BannerUtil;
import betterwithaddons.util.InventoryUtil;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileEntityBannerDetector
extends TileEntityBase
implements ITickable {
    boolean powered;
    int maxdist = 7;
    InventoryBasic bannerInventory = new InventoryBasic("tile.bannerDetector", false, 1);

    public void func_73660_a() {
        boolean newPowered;
        if (!this.field_145850_b.field_72995_K && (newPowered = this.checkSupposedPoweredState()) != this.powered) {
            this.powered = newPowered;
            this.syncTE();
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)ModBlocks.BANNER_DETECTOR, true);
        }
    }

    private boolean checkSupposedPoweredState() {
        final ItemStack filter = this.bannerInventory.func_70301_a(0);
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockBannerDetector.FACING);
        boolean detected = false;
        BlockPos lastPos = null;
        if (!filter.func_190926_b() && filter.func_77973_b() instanceof ItemBanner) {
            for (int i = 1; i <= this.maxdist; ++i) {
                BlockPos nextPos;
                lastPos = nextPos = new BlockPos((Vec3i)this.field_174879_c.func_177967_a(facing, i));
                if (!this.field_145850_b.func_175667_e(nextPos)) continue;
                IBlockState nextState = this.field_145850_b.func_180495_p(nextPos);
                if (nextState.func_185914_p()) break;
                detected = this.checkBanner(nextPos, filter, BlockBanner.class);
                if (!detected) {
                    detected = this.checkBanner(nextPos.func_177984_a(), filter, BlockBanner.BlockBannerHanging.class);
                }
                if (!detected) {
                    detected = this.checkBanner(nextPos.func_177977_b(), filter, BlockBanner.BlockBannerStanding.class);
                }
                if (detected) break;
            }
            if (!detected && this.maxdist > 0) {
                List entityList = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c, lastPos.func_177982_a(1, 1, 1)), (Predicate)new Predicate<Entity>(){

                    public boolean apply(Entity input) {
                        return BannerUtil.isSameBanner(filter, input);
                    }
                });
                detected = entityList != null && entityList.size() > 0;
            }
        }
        return detected;
    }

    private boolean checkBanner(BlockPos pos, ItemStack filter, Class type) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        if (type.isInstance(state.func_177230_c())) {
            BlockBanner bannerblock = (BlockBanner)state.func_177230_c();
            ItemStack banner = bannerblock.func_185473_a(this.field_145850_b, pos, state);
            return BannerUtil.isSameBanner(filter, banner);
        }
        return false;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74757_a("powered", this.powered);
        NBTTagCompound inventoryCompound = new NBTTagCompound();
        InventoryUtil.writeInventoryToCompound(inventoryCompound, (IInventory)this.bannerInventory);
        compound.func_74782_a("inventory", (NBTBase)inventoryCompound);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.powered = compound.func_74767_n("powered");
        NBTTagCompound inventoryCompound = compound.func_74775_l("inventory");
        if (inventoryCompound != null) {
            InventoryUtil.readInventoryFromCompound(inventoryCompound, (IInventory)this.bannerInventory);
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public IInventory getInventory() {
        return this.bannerInventory;
    }
}

