/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.util.IDirtyHandler;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class QueueItemStackHandler
extends ItemStackHandler {
    private IDirtyHandler handler;

    public QueueItemStackHandler(IDirtyHandler handler) {
        super(NonNullList.func_191196_a());
        this.handler = handler;
    }

    public void setSize(int size) {
        NonNullList oldstacks = this.stacks;
        this.stacks = NonNullList.func_191196_a();
        for (int i = 0; i < size; ++i) {
            if (i < oldstacks.size()) {
                this.stacks.add(oldstacks.get(i));
                continue;
            }
            this.stacks.add((Object)ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        int limit = this.getStackLimit(slot, stack);
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            this.stacks.add((Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            this.onContentsChanged(this.stacks.size() - 1);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || this.stacks.size() == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = (ItemStack)this.stacks.get(0);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.remove(0);
                this.onContentsChanged(0);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(0, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(0);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected void onContentsChanged(int slot) {
        if (this.handler != null) {
            this.handler.markDirty();
        }
    }
}

