/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.item.rbdtools;

import betterwithaddons.item.rbdtools.ItemPickaxeConvenient;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMasonPick
extends ItemPickaxeConvenient {
    public ItemMasonPick(Item.ToolMaterial material) {
        super(material);
    }

    @Override
    public boolean canCollect(ItemStack stack, IBlockState state) {
        return ItemMasonPick.isMasonry(stack, state);
    }

    @Override
    public boolean canPlace(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemMasonPick.isItemMasonry(stack, player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public float getEfficiency(ItemStack stack, IBlockState state) {
        return ItemMasonPick.isMasonry(stack, state) ? 1.5f : 0.25f;
    }

    public static boolean isItemMasonry(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).func_179223_d();
            IBlockState state = block.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, stack.func_77960_j(), (EntityLivingBase)player, hand);
            return ItemMasonPick.isMasonry(stack, state);
        }
        return false;
    }

    public static boolean isMasonry(ItemStack tool, IBlockState state) {
        return state.func_185904_a() == Material.field_151576_e && (!state.func_185917_h() || !ItemMasonPick.isOre(tool, state));
    }

    public static boolean isOre(ItemStack tool, IBlockState state) {
        Block block = state.func_177230_c();
        ItemStack oreItem = new ItemStack(block.func_180660_a(state, new Random(), 0), 1, block.func_180651_a(state));
        return ItemMasonPick.isItemOre(oreItem);
    }

    public static boolean isItemOre(ItemStack ore) {
        if (ore.func_190926_b()) {
            return false;
        }
        if (ore.func_77973_b() instanceof ItemBlock) {
            for (int oreid : OreDictionary.getOreIDs((ItemStack)ore)) {
                if (!OreDictionary.getOreName((int)oreid).startsWith("ore")) continue;
                return true;
            }
        }
        return false;
    }
}

