/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.crafting.conditions.ConditionModule;
import betterwithaddons.crafting.recipes.ThreshingRecipe;
import betterwithaddons.handler.WheatHandler;
import betterwithaddons.interaction.Interaction;
import betterwithaddons.item.ModItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockRawPastry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.ForgeRegistry;

public class InteractionWheat
extends Interaction {
    public static boolean ENABLED = false;
    public static boolean CHANGE_HAY_BALES = true;
    public static boolean REPLACE_WHEAT_DROPS = true;
    public static boolean THRESH_WHEAT = true;
    public static boolean THRESH_WHEAT_MILL = true;
    public static boolean MILL_GRAIN = true;
    public static boolean DIG_UP_CROPS = true;
    public static boolean TEXTURE_CHANGES = true;

    @Override
    protected String getName() {
        return "addons.BetterWithWheat";
    }

    @Override
    void setupConfig() {
        ENABLED = this.loadPropBool("Enabled", "Whether the Better With Wheat module is on. DISABLING THIS WILL DISABLE THE WHOLE MODULE.", ENABLED);
        MILL_GRAIN = this.loadPropBool("MillGrain", "Instead of milling wheat into flour, wheat seeds must be milled instead.", MILL_GRAIN);
        REPLACE_WHEAT_DROPS = this.loadPropBool("ReplaceWheatDrops", "Wheat, when harvested, will drop wheat and hay instead.", REPLACE_WHEAT_DROPS);
        CHANGE_HAY_BALES = this.loadPropBool("ChangeHayBales", "Haybales require hay instead of wheat.", CHANGE_HAY_BALES);
        THRESH_WHEAT = this.loadPropBool("ThreshWheat", "Wheat can be threshed into seeds using shovels.", THRESH_WHEAT);
        THRESH_WHEAT_MILL = this.loadPropBool("ThreshWheatMill", "Wheat can be threshed into seeds using a millstone.", THRESH_WHEAT_MILL);
        DIG_UP_CROPS = this.loadPropBool("DigUpCrops", "Carrots and Potatoes cannot be instantly harvested, and instead have a breaktime and a preferred tool (hoe)", DIG_UP_CROPS);
        TEXTURE_CHANGES = this.loadPropBool("ChangeTextures", "Changes textures of Wheat and Wheat Seeds.", TEXTURE_CHANGES);
    }

    @Override
    public boolean isActive() {
        return ENABLED;
    }

    @Override
    public void setEnabled(boolean active) {
        ENABLED = active;
        super.setEnabled(active);
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register(WheatHandler.class);
        ConditionModule.MODULES.put("HayBales", () -> CHANGE_HAY_BALES);
    }

    @Override
    void modifyRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry reg = (ForgeRegistry)event.getRegistry();
        if (THRESH_WHEAT) {
            event.getRegistry().register(new ThreshingRecipe(new ResourceLocation("betterwithaddons", "thresh_wheat"), new ItemStack(Items.field_151014_N), (Ingredient)new OreIngredient("cropWheat")).setRegistryName(new ResourceLocation("betterwithaddons", "thresh_wheat")));
        }
        if (CHANGE_HAY_BALES) {
            Block thatch;
            this.removeRecipeByOutput((ForgeRegistry<IRecipe>)reg, new ItemStack(Blocks.field_150407_cf), "minecraft");
            this.removeRecipeByOutput((ForgeRegistry<IRecipe>)reg, new ItemStack(Items.field_151015_O, 9), "minecraft");
            if (Loader.isModLoaded((String)"quark") && (thatch = Block.func_149684_b((String)"quark:thatch")) != null) {
                this.removeRecipeByOutput((ForgeRegistry<IRecipe>)reg, new ItemStack(thatch), "quark");
                this.removeRecipeByOutput((ForgeRegistry<IRecipe>)reg, new ItemStack(Items.field_151015_O, 4), "quark");
            }
        }
    }

    @Override
    void init() {
        OreDictionary.registerOre((String)"hay", (ItemStack)ModItems.MATERIAL_WHEAT.getMaterial("hay"));
        if (TEXTURE_CHANGES) {
            Items.field_151014_N.func_77655_b("seed_grain");
            ModItems.MATERIAL_BAG.subItemUnlocalizedNames[0] = "grain";
        }
        if (DIG_UP_CROPS) {
            Blocks.field_150469_bN.func_149711_c(1.0f).setHarvestLevel("hoe", 0);
            Blocks.field_150459_bM.func_149711_c(1.0f).setHarvestLevel("hoe", 0);
            Blocks.field_185773_cZ.func_149711_c(1.0f).setHarvestLevel("hoe", 0);
        }
        if (MILL_GRAIN) {
            BWRegistry.MILLSTONE.remove((List)Lists.newArrayList((Object[])new ItemStack[]{BlockRawPastry.getStack((BlockRawPastry.EnumType)BlockRawPastry.EnumType.BREAD)}));
            BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151014_N), BlockRawPastry.getStack((BlockRawPastry.EnumType)BlockRawPastry.EnumType.BREAD));
        }
        if (THRESH_WHEAT_MILL) {
            BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Items.field_151015_O), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151014_N), ModItems.MATERIAL_WHEAT.getMaterial("hay")}));
        }
    }

    @Override
    void preInitEnd() {
        if (TEXTURE_CHANGES) {
            BetterWithAddons.proxy.addResourceOverride("textures", "items", "seeds_wheat", "png");
            BetterWithAddons.proxy.addResourceOverride("textures", "items", "wheat", "png");
            BetterWithAddons.proxy.addResourceOverride("betterwithaddons", "textures", "items", "bag_seed", "png");
        }
    }
}

