/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.interaction.InteractionBWR;
import betterwithmods.common.BWMBlocks;
import betterwithmods.util.DirUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RedstoneBoilHandler {
    HashMap<World, WorldRedstoneScheduler> schedulers = new HashMap();

    @SubscribeEvent
    public void redstoneUpdate(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        if (state.func_177230_c() != Blocks.field_150488_af) {
            return;
        }
        if (!this.willRedstoneBoil(world, pos)) {
            return;
        }
        if ((Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) > 0) {
            return;
        }
        this.scheduleRedstone(world, pos, 9);
    }

    public void scheduleRedstone(World world, BlockPos pos, int delay) {
        if (!this.schedulers.containsKey(world)) {
            this.schedulers.put(world, new WorldRedstoneScheduler());
        }
        this.schedulers.get(world).schedule(pos, world.func_82737_E() + (long)delay);
    }

    @SubscribeEvent
    public void redstoneTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (this.schedulers.containsKey(world)) {
            this.schedulers.get(world).tick(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void redstonePlace(BlockEvent.PlaceEvent event) {
        if (event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getPlacedBlock();
        if (state.func_177230_c() == Blocks.field_150488_af) {
            this.scheduleRedstone(world, pos, 100);
        }
    }

    public boolean willRedstoneBoil(World world, BlockPos pos) {
        IBlockState lens = world.func_180495_p(pos.func_177984_a());
        return world.field_73011_w.func_191066_m() && lens.func_177230_c() == BWMBlocks.LENS && lens.func_177229_b((IProperty)DirUtils.FACING) == EnumFacing.DOWN && world.func_72935_r() && !world.func_72896_J() && world.func_175678_i(pos.func_177981_b(2));
    }

    private void boilRedstone(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150488_af) {
            return;
        }
        if ((Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) <= world.field_73012_v.nextInt(128)) {
            return;
        }
        if (!this.willRedstoneBoil(world, pos)) {
            return;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        if (world.field_73012_v.nextDouble() < InteractionBWR.REDSTONE_BOILING_CHANCE) {
            EntityItem result = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack(Items.field_151114_aO));
            result.func_174869_p();
            world.func_72838_d((Entity)result);
            world.func_175698_g(pos);
        } else {
            world.func_175685_c(pos, state.func_177230_c(), true);
        }
    }

    private class WorldRedstoneScheduler {
        TreeSet<ScheduledTick> sortedUpdates = new TreeSet();
        HashSet<ScheduledTick> updates = new HashSet();

        private WorldRedstoneScheduler() {
        }

        public void schedule(BlockPos pos, long tick) {
            ScheduledTick nexttick = new ScheduledTick(pos, tick);
            if (!this.updates.contains(nexttick)) {
                this.updates.add(nexttick);
                this.sortedUpdates.add(nexttick);
            }
        }

        public void tick(World world) {
            long currenttick = world.func_82737_E();
            if (this.sortedUpdates.size() != this.updates.size()) {
                this.sortedUpdates.clear();
                this.updates.clear();
            }
            if (this.sortedUpdates.size() == 0) {
                return;
            }
            ScheduledTick nexttick = this.sortedUpdates.first();
            while (nexttick.tick <= currenttick) {
                RedstoneBoilHandler.this.boilRedstone(world, nexttick.getPos());
                this.updates.remove(nexttick);
                this.sortedUpdates.remove(nexttick);
                if (this.sortedUpdates.size() == 0) break;
                nexttick = this.sortedUpdates.first();
            }
        }

        protected class ScheduledTick
        implements Comparable<ScheduledTick> {
            private long tick;
            private BlockPos pos;

            protected ScheduledTick(BlockPos pos, long tick) {
                this.pos = pos;
                this.tick = tick;
            }

            public long getTick() {
                return this.tick;
            }

            public BlockPos getPos() {
                return this.pos;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ScheduledTick) {
                    return this.pos.equals((Object)((ScheduledTick)obj).pos);
                }
                return false;
            }

            public int hashCode() {
                return this.pos.hashCode();
            }

            @Override
            public int compareTo(ScheduledTick o) {
                if (this.tick != o.tick) {
                    return Long.compare(this.tick, o.tick);
                }
                return this.pos.compareTo((Vec3i)o.pos);
            }
        }
    }
}

