/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.interaction.InteractionBWA;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HorseFoodHandler {
    @SubscribeEvent
    public void onHorseEat(LivingEvent.LivingUpdateEvent event) {
        if (!InteractionBWA.HORSES_BREED_HAYBALE_PLACED) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && entity instanceof AbstractHorse) {
            boolean hasPotentialMate;
            AbstractHorse horse = (AbstractHorse)entity;
            if (!HorseFoodHandler.canHorseBreed(horse)) {
                return;
            }
            Random random = horse.func_70681_au();
            BlockPos randPos = horse.func_180425_c().func_177982_a(random.nextInt(3) - 1, random.nextInt(2) - 1, random.nextInt(3) - 1);
            IBlockState state = world.func_180495_p(randPos);
            double distance = 16.0;
            boolean bl = hasPotentialMate = !world.func_175674_a((Entity)horse, horse.func_174813_aQ().func_72321_a(distance, distance, distance), otherEntity -> {
                AbstractHorse otherHorse;
                return otherEntity instanceof AbstractHorse && (otherHorse = (AbstractHorse)otherEntity).func_70880_s() && !otherHorse.func_110205_ce();
            }).isEmpty();
            if (state.func_177230_c() == Blocks.field_150407_cf) {
                if (horse.func_110204_cc() && (random.nextDouble() < 0.1 || hasPotentialMate)) {
                    horse.func_146082_f(null);
                    world.func_175718_b(2001, randPos, Block.func_176210_f((IBlockState)state));
                    world.func_175698_g(randPos);
                } else if (!horse.func_110204_cc() && !horse.func_184207_aI() && (random.nextDouble() < 0.01 || hasPotentialMate)) {
                    horse.func_110227_p(true);
                    horse.func_70671_ap().func_75650_a((double)randPos.func_177958_n() + 0.5, (double)randPos.func_177956_o() + 0.5, (double)randPos.func_177952_p() + 0.5, 30.0f, 30.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onHorseUnmount(EntityMountEvent event) {
        Entity ridden = event.getEntityBeingMounted();
        if (!ridden.field_70170_p.field_72995_K && ridden instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)ridden;
            Entity rider = event.getEntityMounting();
            if (InteractionBWA.HORSES_SET_HOME && event.isDismounting() && horse.func_110248_bS() && HorseFoodHandler.isHorseSafe(horse, rider)) {
                horse.func_175449_a(horse.func_180425_c(), 5);
                if (rider instanceof EntityPlayer) {
                    ((EntityPlayer)rider).func_146105_b((ITextComponent)(!horse.func_145818_k_() ? new TextComponentTranslation("info.horse.will_wait", new Object[0]) : new TextComponentTranslation("info.horse.your_horse_will_wait", new Object[]{horse.func_95999_t()})), true);
                }
            }
        }
    }

    public static boolean isHorseSafe(AbstractHorse horse, Entity rider) {
        return !horse.func_70027_ad() && !horse.func_70026_G() && rider.field_70172_ad <= 0 && horse.func_70643_av() == null;
    }

    @SubscribeEvent
    public void onFeedHorse(PlayerInteractEvent.EntityInteract event) {
        this.onFeed(event.getTarget(), (PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public void onFeedHorseSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        this.onFeed(event.getTarget(), (PlayerInteractEvent)event);
    }

    public void onFeed(Entity entity, PlayerInteractEvent event) {
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184586_b(event.getHand());
            if (InteractionBWA.HORSES_IGNORE_GOLD && (stack.func_77973_b() == Items.field_151153_ao || stack.func_77973_b() == Items.field_151150_bK)) {
                event.setCancellationResult(EnumActionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    public static boolean canHorseBreed(AbstractHorse horse) {
        return horse.func_110248_bS() && horse.func_70874_b() == 0 && !horse.func_70880_s();
    }
}

