/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.recipes;

import betterwithaddons.block.AdobeType;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.util.ItemUtil;
import betterwithmods.common.registry.block.recipe.IngredientSpecial;
import betterwithmods.common.registry.bulk.recipes.BulkCraftEvent;
import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class AdobeRecipe
extends CookingPotRecipe {
    Ingredient sand = new IngredientSpecial(stack -> this.getSand((ItemStack)stack) > 0);
    Ingredient clay = new IngredientSpecial(stack -> this.getClay((ItemStack)stack) > 0);
    Ingredient hay = new IngredientSpecial(stack -> this.getHay((ItemStack)stack) > 0);
    Ingredient dung = new IngredientSpecial(stack -> this.getDung((ItemStack)stack) > 0);

    public AdobeRecipe() {
        super(new ArrayList(), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)ModBlocks.ADOBE)}), 1);
        this.inputs.add((Object)this.sand);
        this.inputs.add((Object)this.clay);
    }

    public List<Ingredient> getInputs() {
        return Lists.newArrayList((Object[])new Ingredient[]{this.sand, this.clay, this.hay, this.dung});
    }

    private int getSand(ItemStack stack) {
        if (ItemUtil.matchesOreDict(stack, "pileSand")) {
            return stack.func_190916_E();
        }
        if (ItemUtil.matchesOreDict(stack, "sand")) {
            return 4 * stack.func_190916_E();
        }
        return 0;
    }

    private int getClay(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151119_aD) {
            return stack.func_190916_E();
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150435_aG) {
            return 4 * stack.func_190916_E();
        }
        return 0;
    }

    private int getHay(ItemStack stack) {
        if (ItemUtil.matchesOreDict(stack, "hay") || ItemUtil.matchesOreDict(stack, "straw") || ItemUtil.matchesOreDict(stack, "cropWheat") || ItemUtil.matchesOreDict(stack, "cropBarley") || ItemUtil.matchesOreDict(stack, "cropRye")) {
            return stack.func_190916_E();
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
            return 9 * stack.func_190916_E();
        }
        return 0;
    }

    private int getDung(ItemStack stack) {
        if (ItemUtil.matchesOreDict(stack, "dung")) {
            return stack.func_190916_E();
        }
        if (ItemUtil.matchesOreDict(stack, "blockDung")) {
            return 9 * stack.func_190916_E();
        }
        return 0;
    }

    @Nonnull
    public ArrayList<ItemStack> getOutputs() {
        ArrayList<ItemStack> allOutputs = new ArrayList<ItemStack>();
        for (int i = 0; i < 8; ++i) {
            ItemStack output = new ItemStack((Block)ModBlocks.ADOBE, 1, i);
            output.func_190924_f("tooltip.adobe.crafting");
            allOutputs.add(output);
        }
        return Lists.newArrayList(allOutputs);
    }

    public boolean consumeIngredients(ItemStackHandler inv, NonNullList<ItemStack> containItems) {
        int clay = 0;
        int sand = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            clay += this.getClay(stack);
            sand += this.getSand(stack);
            if (this.getClay(stack) <= 0 && this.getSand(stack) <= 0 && this.getDung(stack) <= 0 && this.getHay(stack) <= 0) continue;
            ItemStack container = stack.func_77973_b().getContainerItem(stack);
            container.func_190920_e(stack.func_190916_E());
            containItems.add((Object)container);
            inv.extractItem(i, stack.func_190916_E(), false);
        }
        return clay > 0 && sand > 0;
    }

    private ArrayList<ItemStack> getMixedResult(ItemStackHandler inv) {
        int clay = 0;
        int sand = 0;
        int dung = 0;
        int wheat = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            clay += this.getClay(stack);
            sand += this.getSand(stack);
            dung += this.getDung(stack);
            wheat += this.getHay(stack);
        }
        int total = clay + sand + dung + wheat;
        float clayPart = (float)clay / (float)total;
        float sandPart = (float)sand / (float)total;
        float dungPart = (float)dung / (float)total;
        float wheatPart = (float)wheat / (float)total;
        AdobeType type = (double)clayPart > 0.5 && clayPart > sandPart + dungPart + wheatPart ? AdobeType.MOSTLY_CLAY : ((double)sandPart > 0.5 && sandPart > clayPart + dungPart + wheatPart ? AdobeType.MOSTLY_SAND : ((double)dungPart > 0.5 ? AdobeType.MOSTLY_DUNG : ((double)wheatPart > 0.5 ? AdobeType.MOSTLY_STRAW : ((double)(dungPart + wheatPart) < 0.1 ? (clayPart > sandPart ? AdobeType.CLAYSAND : AdobeType.SANDCLAY) : (sandPart > dungPart + wheatPart ? AdobeType.LIGHT : AdobeType.DARK)))));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = total / 4; i > 0; i -= 64) {
            stacks.add(type.getBlockStack(Math.min(i, 64), true));
        }
        return stacks;
    }

    public boolean isInvalid() {
        return false;
    }

    public NonNullList<ItemStack> onCraft(World world, TileEntity tile, ItemStackHandler inv) {
        NonNullList items = NonNullList.func_191196_a();
        ArrayList<ItemStack> mixedResult = this.getMixedResult(inv);
        if (this.consumeIngredients(inv, (NonNullList<ItemStack>)items)) {
            items.addAll(mixedResult);
            return BulkCraftEvent.fireOnCraft((TileEntity)tile, (World)world, (ItemStackHandler)inv, (BulkRecipe)this, (NonNullList)items);
        }
        return NonNullList.func_191196_a();
    }
}

