/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.crafting.recipes.SmeltingRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CraftingManagerTatara {
    private static final CraftingManagerTatara instance = new CraftingManagerTatara();
    private final ArrayList<SmeltingRecipe> recipes = new ArrayList();

    public static CraftingManagerTatara instance() {
        return instance;
    }

    private CraftingManagerTatara() {
    }

    public void addRecipe(Ingredient input, ItemStack output) {
        this.recipes.add(this.createRecipe(input, output));
    }

    public void addRecipe(SmeltingRecipe recipe) {
        this.recipes.add(recipe);
    }

    protected SmeltingRecipe createRecipe(Ingredient input, ItemStack output) {
        return new SmeltingRecipe(input, output);
    }

    public SmeltingRecipe getSmeltingRecipe(ItemStack input) {
        SmeltingRecipe entry;
        Iterator<SmeltingRecipe> var2 = this.recipes.iterator();
        do {
            if (var2.hasNext()) continue;
            return null;
        } while (!(entry = var2.next()).matchesInput(input));
        return entry;
    }

    public List<SmeltingRecipe> findRecipeForRemoval(@Nonnull ItemStack input) {
        return this.recipes.stream().filter(recipe -> recipe.matchesInput(input)).collect(Collectors.toList());
    }

    public List<SmeltingRecipe> getRecipes() {
        return this.recipes;
    }
}

