/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.crafting.recipes.PackingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CraftingManagerPacking {
    private static final CraftingManagerPacking instance = new CraftingManagerPacking();
    private List<PackingRecipe> recipes = new ArrayList<PackingRecipe>();

    public static CraftingManagerPacking getInstance() {
        return instance;
    }

    public void addRecipe(PackingRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addRecipe(IBlockState output, ItemStack jeiOutput, Ingredient input) {
        PackingRecipe recipe = this.createRecipe(output, input);
        recipe.setJeiOutput(jeiOutput);
        this.recipes.add(recipe);
    }

    public void addRecipe(IBlockState output, Ingredient input) {
        this.recipes.add(this.createRecipe(output, input));
    }

    public List<PackingRecipe> findRecipeForRemoval(@Nonnull ItemStack input) {
        return this.recipes.stream().filter(recipe -> recipe.matchesInput(input)).collect(Collectors.toList());
    }

    public PackingRecipe getMostValidRecipe(IBlockState compressState, List<EntityItem> inv) {
        List<PackingRecipe> recipes = this.getValidCraftingRecipes(compressState, inv);
        if (recipes == null || recipes.size() == 0) {
            return null;
        }
        return recipes.get(0);
    }

    public List<PackingRecipe> getValidCraftingRecipes(IBlockState compressState, List<EntityItem> inv) {
        return this.recipes.stream().filter(recipe -> recipe.matches(compressState, inv)).collect(Collectors.toCollection(ArrayList::new));
    }

    private PackingRecipe createRecipe(IBlockState output, Ingredient input) {
        return new PackingRecipe(input, output);
    }

    public List<PackingRecipe> getRecipes() {
        return this.recipes;
    }
}

