/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.crafting.recipes.infuser.TransmutationRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CraftingManagerInfuserTransmutation {
    private static final CraftingManagerInfuserTransmutation instance = new CraftingManagerInfuserTransmutation();
    private final ArrayList<TransmutationRecipe> recipes = new ArrayList();

    public static CraftingManagerInfuserTransmutation getInstance() {
        return instance;
    }

    private CraftingManagerInfuserTransmutation() {
    }

    public void addRecipe(TransmutationRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addRecipe(Ingredient input, int spirits, ItemStack output) {
        this.recipes.add(this.createRecipe(input, spirits, output));
    }

    public void removeRecipe(TransmutationRecipe recipe) {
        this.recipes.remove(recipe);
    }

    public void clearRecipes() {
        this.recipes.clear();
    }

    protected TransmutationRecipe createRecipe(Ingredient input, int spirits, ItemStack output) {
        return new TransmutationRecipe(input, spirits, output);
    }

    public List<TransmutationRecipe> findRecipeForRemoval(@Nonnull ItemStack output) {
        return this.recipes.stream().filter(recipe -> recipe.output.func_77969_a(output)).collect(Collectors.toList());
    }

    public TransmutationRecipe getSmeltingRecipe(ItemStack input, int spirits) {
        TransmutationRecipe entry;
        Iterator<TransmutationRecipe> var2 = this.recipes.iterator();
        do {
            if (var2.hasNext()) continue;
            return null;
        } while (!(entry = var2.next()).matchesInput(input, spirits));
        return entry;
    }

    public List<TransmutationRecipe> getRecipes() {
        return this.recipes;
    }
}

