/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.crafting.recipes.infuser.InfuserRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class CraftingManagerInfuser {
    private static final CraftingManagerInfuser INSTANCE = new CraftingManagerInfuser();
    private final List<InfuserRecipe> recipes = Lists.newArrayList();

    public static CraftingManagerInfuser getInstance() {
        return INSTANCE;
    }

    private CraftingManagerInfuser() {
    }

    public void addRecipe(InfuserRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addRecipe(IRecipe recipe, int spirits) {
        this.addRecipe(new InfuserRecipe(recipe, spirits));
    }

    public void removeRecipe(InfuserRecipe recipe) {
        this.recipes.remove(recipe);
    }

    public void clearRecipes() {
        this.recipes.clear();
    }

    public InfuserRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        for (InfuserRecipe irecipe : this.recipes) {
            if (!irecipe.internal.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe;
        }
        return null;
    }

    public List<InfuserRecipe> getRecipesByOutput(ItemStack stack) {
        return this.recipes.stream().filter(irecipe -> irecipe.internal.func_77571_b().func_77969_a(stack)).collect(Collectors.toCollection(ArrayList::new));
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting craftMatrix, World worldIn) {
        for (InfuserRecipe irecipe : this.recipes) {
            if (!irecipe.internal.func_77569_a(craftMatrix, worldIn)) continue;
            return irecipe.internal.func_179532_b(craftMatrix);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)craftMatrix.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)craftMatrix.func_70301_a(i));
        }
        return nonnulllist;
    }

    public List<InfuserRecipe> getRecipeList() {
        return this.recipes;
    }
}

