/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockContainerBase;
import betterwithaddons.tileentity.TileEntityAlchDragon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAlchDragon
extends BlockContainerBase {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool NODROP = PropertyBool.func_177716_a((String)"nodrop");
    protected static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75);

    protected BlockAlchDragon() {
        super("alchemical_dragon", Material.field_151594_q);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)NODROP, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    public boolean func_149686_d(IBlockState p_isFullCube_1_) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        switch ((EnumFacing)p_getBoundingBox_1_.func_177229_b((IProperty)FACING)) {
            default: {
                return DEFAULT_AABB;
            }
            case SOUTH: {
                return NORTH_AABB;
            }
            case NORTH: {
                return SOUTH_AABB;
            }
            case EAST: {
                return WEST_AABB;
            }
            case WEST: 
        }
        return EAST_AABB;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float p_onBlockPlaced_4_, float p_onBlockPlaced_5_, float p_onBlockPlaced_6_, int p_onBlockPlaced_7_, EntityLivingBase entity) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)NODROP, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        if (world != null && pos != null) {
            if (player != null) {
                int inc = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntityAlchDragon) {
                    ((TileEntityAlchDragon)te).setSkullRotation(inc);
                }
            }
            if (world.field_72995_K) {
                return;
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            state = state.func_177226_a((IProperty)NODROP, (Comparable)Boolean.valueOf(true));
            world.func_180501_a(pos, state, 4);
        }
        this.func_176226_b(world, pos, state, 0);
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.func_180663_b(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    public IBlockState func_176203_a(int p_getStateFromMeta_1_) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(p_getStateFromMeta_1_ & 7))).func_177226_a((IProperty)NODROP, (Comparable)Boolean.valueOf((p_getStateFromMeta_1_ & 8) > 0));
    }

    public int func_176201_c(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        int i1 = i | ((EnumFacing)p_getMetaFromState_1_.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)p_getMetaFromState_1_.func_177229_b((IProperty)NODROP)).booleanValue()) {
            i1 |= 8;
        }
        return i1;
    }

    public IBlockState func_185499_a(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.func_177226_a((IProperty)FACING, (Comparable)p_withRotation_2_.func_185831_a((EnumFacing)p_withRotation_1_.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.func_185907_a(p_withMirror_2_.func_185800_a((EnumFacing)p_withMirror_1_.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NODROP});
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAlchDragon();
    }
}

