/*
 * Decompiled with CFR 0.152.
 */
package advancedmotd.utils;

import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class MessageHelper {
    public static final String PREFIX = "[AdvancedMotd] ";

    public static String getFormattedText(String message) {
        String msgRet = message;
        String colorPrefix = "\u00a7";
        String formats = "0123456789abcdeflnomkr";
        for (int i = 0; i < formats.length(); ++i) {
            msgRet = msgRet.replaceAll("&" + formats.charAt(i), colorPrefix + formats.charAt(i));
        }
        msgRet = msgRet.replaceAll("\\\\n", "\n");
        return msgRet;
    }

    public static String getFormattedMotd(String message) {
        String msgRet = message;
        String colorPrefix = "\u00a7";
        String formats = "0123456789abcdeflnomkr";
        for (int i = 0; i < formats.length(); ++i) {
            msgRet = msgRet.replaceAll(colorPrefix + formats.charAt(i), "&" + formats.charAt(i));
        }
        msgRet = msgRet.replaceAll("\\\\n", "\n");
        return msgRet;
    }

    public static String prependPrefix(String message) {
        return PREFIX + message;
    }

    public static ITextComponent getIText(String message, boolean prefix) {
        return new TextComponentString(prefix ? MessageHelper.prependPrefix(message) : message);
    }

    public static ITextComponent getIText(String message, boolean formatted, boolean prefix) {
        if (prefix) {
            message = MessageHelper.prependPrefix(message);
        }
        if (formatted) {
            message = MessageHelper.getFormattedText(message);
        }
        return new TextComponentString(message);
    }

    public static ITextComponent getIText(String message, TextFormatting color, boolean formatted, boolean prefix) {
        ITextComponent iText = MessageHelper.getIText(message, formatted, prefix);
        return iText.func_150255_a(new Style().func_150238_a(color));
    }

    public static void sendText(ICommandSender sender, String message, TextFormatting color, boolean formatted, boolean prefix) {
        sender.func_145747_a(MessageHelper.getIText(message, color, formatted, prefix));
    }

    public static void sendText(ICommandSender sender, String message, boolean formatted, boolean prefix) {
        sender.func_145747_a(MessageHelper.getIText(message, formatted, prefix));
    }
}

