/*
 * Decompiled with CFR 0.152.
 */
package advancedmotd.config;

import advancedmotd.AdvancedMotd;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigLang {
    public static String infoNoDimension = "Dimension ID '%s' doesn't seem to exist!";
    public static String cmdHelpInfo = "Shows help for each available command.";
    public static String cmdHelpUsage = "Shows help and usage for each available command by typing:\\n%s <command>";
    public static String errNoCommandAvailable = "There is no command '%s' available.";
    public static String cmdPrintUsage = "Shows the current unformated server motd.";
    public static String cmdPrintInfo = "Shows the current unformated server motd.";
    public static String errPrintNoMotd = "No motd set.";
    public static String cmdReloadInfo = "Will reload the configuration from disc.";
    public static String execReloadDone = "Reload done.";
    public static String cmdSetUsage = "Sets a (new) motd for the server.\\nSet a text with %s <text>";
    public static String cmdSetInfo = "Sets a (new) motd for the server.";
    public static String execSetDone = "New motd set.";
    public static String errSetNoProperty = "No property like motd.";
    public static String cmdShowUsage = "Shows the current formated server motd.";
    public static String cmdShowInfo = "Shows the current formated server motd.";
    public static String errShowNoMotd = "No motd set.";
    public static String msgSeasonSpring = "Spring";
    public static String msgSeasonSummer = "Summer";
    public static String msgSeasonAutumn = "Autumn";
    public static String msgSeasonWinter = "Winter";
    public static String cmdAliasesInfo = "Shows available aliases for the main command '%s'.";
    private Configuration cfg;
    public static final String CONFIG_VERSION = "v1";
    public static final String CONFIG_NAME = "configLang.cfg";
    public static final String CONFIG_DIR = "/advancedmotd";
    public String path = "";

    public ConfigLang(String cfgPath) {
        this.path = cfgPath;
        this.loadConfigurationFile(this.path);
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    public void loadConfigurationFile(String cfgPath) {
        if (!cfgPath.isEmpty()) {
            File file = new File(cfgPath + CONFIG_DIR, CONFIG_NAME);
            this.cfg = new Configuration(file, CONFIG_VERSION, false);
            if (!this.cfg.getDefinedConfigVersion().equals(this.cfg.getLoadedConfigVersion())) {
                AdvancedMotd.getLogger().warn(" ");
                AdvancedMotd.getLogger().warn("################### WARNING ####################");
                AdvancedMotd.getLogger().warn("Config: " + cfgPath + CONFIG_DIR + "/" + CONFIG_NAME);
                AdvancedMotd.getLogger().warn("Version: Mismatch");
                AdvancedMotd.getLogger().warn("################################################");
                AdvancedMotd.getLogger().warn("Shut down the server after the boot is finished.");
                AdvancedMotd.getLogger().warn("Make a backup of your old config by renaming it.");
                AdvancedMotd.getLogger().warn("Start the server again to create the new config.");
                AdvancedMotd.getLogger().warn("Take over the old settings into the new config.");
                AdvancedMotd.getLogger().warn("################################################");
                AdvancedMotd.getLogger().warn(" ");
            }
            this.loadFromConfiguration();
            this.save();
        }
    }

    public void loadFromConfiguration() {
        this.cfg.setCategoryComment("language", "The language section of AdvancedMotd.");
        infoNoDimension = this.cfg.get("language", "info.noDimension", infoNoDimension).getString();
        cmdHelpInfo = this.cfg.get("language", "cmd.help.info", cmdHelpInfo).getString();
        cmdHelpUsage = this.cfg.get("language", "cmd.help.usage", cmdHelpUsage).getString();
        errNoCommandAvailable = this.cfg.get("language", "err.noCommandAvailable", errNoCommandAvailable).getString();
        cmdPrintUsage = this.cfg.get("language", "cmd.print.usage", cmdPrintUsage).getString();
        cmdPrintInfo = this.cfg.get("language", "cmd.print.info", cmdPrintInfo).getString();
        errPrintNoMotd = this.cfg.get("language", "err.noDimension", errPrintNoMotd).getString();
        cmdReloadInfo = this.cfg.get("language", "cmd.reload.info", cmdReloadInfo).getString();
        execReloadDone = this.cfg.get("language", "exec.reload.done", execReloadDone).getString();
        cmdSetUsage = this.cfg.get("language", "cmd.set.usage", cmdSetUsage).getString();
        cmdSetInfo = this.cfg.get("language", "cmd.set.info", cmdSetInfo).getString();
        execSetDone = this.cfg.get("language", "exec.set.done", execSetDone).getString();
        cmdShowUsage = this.cfg.get("language", "cmd.show.usage", cmdShowUsage).getString();
        cmdShowInfo = this.cfg.get("language", "cmd.show.info", cmdShowInfo).getString();
        errShowNoMotd = this.cfg.get("language", "err.show.noMotd", errShowNoMotd).getString();
        cmdAliasesInfo = this.cfg.get("language", "cmd.aliases.info", cmdAliasesInfo).getString();
        msgSeasonSpring = this.cfg.get("language", "msg.season.spring", msgSeasonSpring).getString();
        msgSeasonSummer = this.cfg.get("language", "msg.season.summer", msgSeasonSummer).getString();
        msgSeasonAutumn = this.cfg.get("language", "msg.season.autumn", msgSeasonAutumn).getString();
        msgSeasonWinter = this.cfg.get("language", "msg.season.winter", msgSeasonWinter).getString();
    }

    public void save() {
        this.cfg.save();
    }

    public void load() {
        this.cfg.load();
        this.loadFromConfiguration();
    }
}

