/*
 * Decompiled with CFR 0.152.
 */
package advancedmotd.commands;

import advancedmotd.AdvancedMotd;
import advancedmotd.config.ConfigGeneral;
import advancedmotd.utils.MessageHelper;
import advancedmotd.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class Commands
extends CommandTreeBase {
    public Commands() {
        PermissionAPI.registerNode((String)this.getPermission(), (DefaultPermissionLevel)this.getPermissionLevel(), (String)this.getInfo());
    }

    private String concatCommands(MinecraftServer server, @Nonnull ICommandSender sender) {
        String cmdStr = "<";
        cmdStr = cmdStr + String.join((CharSequence)"|", this.getCommandMap(server, sender).keySet());
        cmdStr = cmdStr + ">";
        return cmdStr;
    }

    public String func_71517_b() {
        if (AdvancedMotd.config != null) {
            if (!ConfigGeneral.commandName.getString().isEmpty()) {
                return ConfigGeneral.commandName.getString();
            }
        }
        return "worldjointext";
    }

    public Map<String, Commands> getCommandMap(MinecraftServer server, @Nonnull ICommandSender sender) {
        HashMap<String, Commands> cmdMap = new HashMap<String, Commands>();
        for (Map.Entry entry : super.getCommandMap().entrySet()) {
            if (!(entry.getValue() instanceof Commands) || !((Commands)((Object)entry.getValue())).func_184882_a(server, sender)) continue;
            cmdMap.put((String)entry.getKey(), (Commands)((Object)entry.getValue()));
        }
        return cmdMap;
    }

    public String func_71518_a(ICommandSender sender) {
        return "Usage: /" + this.func_71517_b() + " " + this.concatCommands(null, sender) + "\nFor details type /" + this.func_71517_b() + " help <command>";
    }

    public List<String> func_71514_a() {
        if (AdvancedMotd.config != null) {
            if (ConfigGeneral.commandNameAliases.getStringList().length > 0) {
                ArrayList<String> retList = new ArrayList<String>();
                int i = 0;
                while (true) {
                    if (i >= ConfigGeneral.commandNameAliases.getStringList().length) break;
                    retList.add(ConfigGeneral.commandNameAliases.getStringList()[i]);
                    ++i;
                }
                return retList;
            }
        }
        return Collections.emptyList();
    }

    public String getInfo() {
        return "";
    }

    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    public String getPermission() {
        return "advancedmotd.commands." + ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)("advancedmotd.commands." + ((Object)((Object)this)).getClass().getSimpleName()));
        }
        return true;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length < 1) {
            String cmdStr = this.func_71518_a(sender);
            MessageHelper.sendText(sender, cmdStr, TextFormatting.YELLOW, true, true);
        } else {
            ICommand cmd = (ICommand)this.getCommandMap().get(args[0]);
            if (cmd == null) {
                throw new CommandException("commands.tree_base.invalid_cmd", new Object[]{args[0]});
            }
            if (!cmd.func_184882_a(server, sender)) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            cmd.func_184881_a(server, sender, Utils.shiftArgs(args));
        }
    }
}

