/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.lib.SilentLib;

@Mod.EventBusSubscriber(modid="silentlib")
public final class ServerTicks {
    private static final int QUEUE_OVERFLOW_LIMIT = 30;
    private static volatile Queue<Runnable> scheduledActions = new ArrayDeque<Runnable>();

    private ServerTicks() {
    }

    public static void scheduleAction(Runnable action) {
        scheduledActions.add(action);
        if (scheduledActions.size() > 30) {
            SilentLib.LOGGER.warn("Too many server tick actions queued! Currently at {} items.", (Object)scheduledActions.size());
        }
    }

    @SubscribeEvent
    public static void serverTicks(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerTicks.runScheduledActions();
        }
    }

    private static void runScheduledActions() {
        Runnable action = scheduledActions.poll();
        while (action != null) {
            action.run();
            action = scheduledActions.poll();
        }
    }
}

