/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.world.structure.StructureBarakoaVillage;
import com.bobmowzie.mowziesmobs.server.world.structure.StructureWroughtnautRoom;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class MowzieWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public static void generatePrePopulate(World world, Random random, int chunkX, int chunkZ) {
        if (MowzieWorldGenerator.canSpawnStructureAtCoords(chunkX, chunkZ, world, ConfigHandler.BARAKO.generationData.generationFrequency)) {
            StructureBarakoaVillage.generateVillage(world, random, chunkX * 16 + 8, chunkZ * 16 + 8);
        }
        if (MowzieWorldGenerator.canSpawnStructureAtCoords(chunkX, chunkZ, world, ConfigHandler.FROSTMAW.generationData.generationFrequency)) {
            EntityFrostmaw frostmaw = new EntityFrostmaw(world);
            frostmaw.spawnInWorld(world, random, chunkX * 16 + 8, chunkZ * 16 + 8);
        }
    }

    private static boolean canSpawnStructureAtCoords(int chunkX, int chunkZ, World world, int genFrequency) {
        if (genFrequency <= 0) {
            return false;
        }
        int maxDistanceBetween = genFrequency + 8;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= maxDistanceBetween - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= maxDistanceBetween - 1;
        }
        int k = chunkX / maxDistanceBetween;
        int l = chunkZ / maxDistanceBetween;
        Random random = world.func_72843_D(k, l, 14357617);
        k *= maxDistanceBetween;
        l *= maxDistanceBetween;
        return i == (k += random.nextInt(maxDistanceBetween - 8)) && j == (l += random.nextInt(maxDistanceBetween - 8));
    }

    private void generateSurface(World world, Random random, int x, int z) {
        if (MowzieWorldGenerator.canSpawnStructureAtCoords(x, z, world, ConfigHandler.FERROUS_WROUGHTNAUT.generationData.generationFrequency)) {
            StructureWroughtnautRoom.tryWroughtChamber(world, random, x, z);
        }
    }

    private void generateEnd(World world, Random random, int i, int i1) {
    }

    private void generateNether(World world, Random random, int i, int i1) {
    }

    public static int findGenHeight(World world, BlockPos pos, int heightMax, int heightMin) {
        IBlockState topBlock = world.func_180494_b((BlockPos)pos).field_76752_A;
        IBlockState fillerBlock = world.func_180494_b((BlockPos)pos).field_76753_B;
        IBlockState stone = Blocks.field_150348_b.func_176223_P();
        for (int y = heightMax - pos.func_177956_o(); y > heightMin - pos.func_177956_o(); --y) {
            if (!world.func_180495_p(pos.func_177982_a(0, y, 0)).func_185913_b()) continue;
            IBlockState firstFullBlock = world.func_180495_p(pos.func_177982_a(0, y, 0));
            if (firstFullBlock != topBlock && firstFullBlock != fillerBlock && firstFullBlock != stone) break;
            return y;
        }
        return -1;
    }
}

