/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.grottol;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.server.ai.EntityAIGrottolFindMinecart;
import com.bobmowzie.mowziesmobs.server.ai.MMAIAvoidEntity;
import com.bobmowzie.mowziesmobs.server.ai.MMEntityMoveHelper;
import com.bobmowzie.mowziesmobs.server.ai.MMPathNavigateGround;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.block.BlockGrottol;
import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.grottol.BlackPinkRailLine;
import com.bobmowzie.mowziesmobs.server.entity.grottol.ai.EntityAIGrottolIdle;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityGrottol
extends MowzieEntity
implements IMob {
    public static final Animation DIE_ANIMATION = Animation.create((int)73);
    public static final Animation HURT_ANIMATION = Animation.create((int)10);
    public static final Animation IDLE_ANIMATION = EntityAIGrottolIdle.animation();
    public static final Animation BURROW_ANIMATION = Animation.create((int)20);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, IDLE_ANIMATION, BURROW_ANIMATION};
    public int fleeTime = 0;
    private int timeSinceFlee = 50;
    private int timeSinceMinecart = 0;
    private final BlackPinkRailLine reader = BlackPinkRailLine.create();
    private EnumDeathType death = EnumDeathType.NORMAL;

    public EntityGrottol(World world) {
        super(world);
        this.func_184644_a(PathNodeType.DANGER_OTHER, 1.0f);
        this.func_184644_a(PathNodeType.WATER, 3.0f);
        this.func_184644_a(PathNodeType.LAVA, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, 1.0f);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.15f;
        this.func_70105_a(0.9f, 1.2f);
        this.field_70765_h = new MMEntityMoveHelper((EntityLiving)this, 45.0f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGrottolFindMinecart(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MMAIAvoidEntity<EntityGrottol, EntityPlayer>(this, EntityPlayer.class, 16.0f, 0.5, 0.7){
            private int fleeCheckCounter;
            {
                this.fleeCheckCounter = 0;
            }

            @Override
            protected void onSafe() {
                this.fleeCheckCounter = 0;
            }

            @Override
            protected void onPathNotFound() {
                if (this.fleeCheckCounter < 4) {
                    ++this.fleeCheckCounter;
                } else if (EntityGrottol.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this.entity, BURROW_ANIMATION);
                }
            }

            @Override
            public void func_75246_d() {
                super.func_75246_d();
                ++((EntityGrottol)this.entity).fleeTime;
            }

            @Override
            public void func_75251_c() {
                super.func_75246_d();
                ((EntityGrottol)this.entity).timeSinceFlee = 0;
                this.fleeCheckCounter = 0;
            }
        });
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, new AnimationTakeDamage<EntityGrottol>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityGrottol>(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIGrottolIdle(this));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityGrottol>(this, BURROW_ANIMATION, false));
    }

    public int func_82143_as() {
        return 256;
    }

    protected PathNavigate func_175447_b(World world) {
        return new MMPathNavigateGround(this, world);
    }

    public float func_180484_a(BlockPos pos) {
        return (float)this.func_174831_c(pos);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70613_aW() {
        return super.func_70613_aW() && !this.isInMinecart();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(20.0f * ConfigHandler.GROTTOL.healthMultiplier));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected ConfigHandler.SpawnData getSpawnConfig() {
        return ConfigHandler.GROTTOL.spawnData;
    }

    @Override
    public boolean func_70601_bi() {
        return this.getEntitiesNearby(EntityGrottol.class, 20.0, 20.0, 20.0, 20.0).isEmpty() && super.func_70601_bi();
    }

    public boolean func_85031_j(Entity entity) {
        EntityPlayer player;
        if (entity instanceof EntityPlayer && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)(player = (EntityPlayer)entity).func_184614_ca()) > 0) {
            if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                this.func_70099_a(ItemHandler.CAPTURED_GROTTOL.create(this), 0.0f);
                IBlockState state = BlockHandler.GROTTOL.func_176223_P();
                SoundType sound = state.func_177230_c().getSoundType(state, this.field_70170_p, new BlockPos((Entity)this), entity);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, sound.func_185845_c(), this.func_184176_by(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
                if (this.field_70170_p instanceof WorldServer) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, 32, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)state)});
                }
                this.func_70106_y();
            }
            return true;
        }
        return super.func_85031_j(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.func_184823_b(Blocks.field_150482_ag.func_176223_P())) {
                this.death = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()) > 0 ? EnumDeathType.FORTUNE_PICKAXE : EnumDeathType.PICKAXE;
                return super.func_70097_a(source, this.func_110143_aJ());
            }
            this.func_184185_a(SoundEvents.field_187689_f, 0.4f, 2.9f);
            return false;
        }
        if (entity instanceof EntityLiving) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70071_h_() {
        IBlockState blockBeneath;
        Material mat;
        Entity e;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && EntityGrottol.isMinecart(e = this.func_184187_bx())) {
            this.reader.accept((EntityMinecart)e);
            this.func_191989_p(1.0f);
            ++this.timeSinceMinecart;
            boolean onRail = EntityGrottol.isBlockRail(this.field_70170_p.func_180495_p(e.func_180425_c()).func_177230_c());
            if (this.timeSinceMinecart > 3 && Math.abs(e.field_70159_w) <= 0.001 && Math.abs(e.field_70181_x) <= 0.001 && Math.abs(e.field_70179_y) <= 0.001 || !onRail) {
                this.func_184210_p();
                this.timeSinceMinecart = 0;
            } else if (onRail) {
                e.field_70159_w *= 2.7;
                e.field_70179_y *= 2.7;
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70146_Z.nextInt(15) == 0) {
            double x = this.field_70165_t + (double)(0.5f * (2.0f * this.field_70146_Z.nextFloat() - 1.0f));
            double y = this.field_70163_u + (double)0.8f + (double)(0.3f * (2.0f * this.field_70146_Z.nextFloat() - 1.0f));
            double z = this.field_70161_v + (double)(0.5f * (2.0f * this.field_70146_Z.nextFloat() - 1.0f));
            if (this.isBlackPinkInYourArea()) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.NOTE, x, y, z, this.field_70146_Z.nextDouble() / 2.0, 0.0, 0.0, new int[0]);
            } else {
                MMParticle.SPARKLE.spawn(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 4.0, 22));
            }
        }
        float moveX = (float)(this.field_70165_t - this.field_70169_q);
        float moveZ = (float)(this.field_70161_v - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if (this.frame % 6 == 0 && (double)speed > 0.05) {
            this.func_184185_a(MMSounds.ENTITY_GROTTOL_STEP, 1.0f, 1.8f);
        }
        if (this.timeSinceFlee < 50) {
            ++this.timeSinceFlee;
        } else {
            this.fleeTime = 0;
        }
        if (!(this.field_70170_p.field_72995_K || this.fleeTime < 55 || this.getAnimation() != NO_ANIMATION || this.func_175446_cd() || this.func_70644_a(PotionHandler.FROZEN) || (mat = (blockBeneath = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b())).func_185904_a()) != Material.field_151577_b && mat != Material.field_151578_c && mat != Material.field_151595_p && mat != Material.field_151571_B && mat != Material.field_151576_e)) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BURROW_ANIMATION);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == BURROW_ANIMATION && this.getAnimationTick() % 4 == 3) {
            this.func_184185_a(SoundEvents.field_187753_eE, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            blockBeneath = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
            mat = blockBeneath.func_185904_a();
            if (mat == Material.field_151577_b || mat == Material.field_151578_c || mat == Material.field_151595_p || mat == Material.field_151571_B || mat == Material.field_151576_e) {
                Vec3d pos = new Vec3d(0.7, 0.05, 0.0).func_178785_b((float)Math.toRadians(-this.field_70761_aq - 90.0f));
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + pos.field_72450_a, this.field_70163_u + pos.field_72448_b, this.field_70161_v + pos.field_72449_c, 8, 0.25, 0.025, 0.25, 0.1, new int[]{Block.func_176210_f((IBlockState)blockBeneath)});
            }
        }
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (animation == BURROW_ANIMATION) {
            this.func_70106_y();
        }
    }

    public static boolean isBlockRail(Block block) {
        return block == Blocks.field_150448_aq || block == Blocks.field_150408_cc || block == Blocks.field_150318_D || block == Blocks.field_150319_E;
    }

    private boolean isBlackPinkInYourArea() {
        Entity e = this.func_184187_bx();
        if (EntityGrottol.isMinecart(e)) {
            IBlockState state = ((EntityMinecart)e).func_174897_t();
            return state.func_177230_c() == BlockHandler.GROTTOL && state.func_177229_b(BlockGrottol.VARIANT) == BlockGrottol.Variant.BLACK_PINK;
        }
        return false;
    }

    public boolean isInMinecart() {
        return EntityGrottol.isMinecart(this.func_184187_bx());
    }

    public boolean hasMinecartBlockDisplay() {
        Entity entity = this.func_184187_bx();
        return EntityGrottol.isMinecart(entity) && ((EntityMinecart)entity).func_174897_t().func_177230_c() == BlockHandler.GROTTOL;
    }

    private static boolean isMinecart(Entity entity) {
        return entity instanceof EntityMinecartEmpty;
    }

    protected void func_82167_n(Entity entity) {
        if (!EntityGrottol.isMinecart(entity)) {
            super.func_82167_n(entity);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        if (super.func_184205_a(entity, force)) {
            EntityMinecart minecart;
            if (EntityGrottol.isMinecart(entity) && (minecart = (EntityMinecart)entity).func_174897_t().func_177230_c() != BlockHandler.GROTTOL) {
                minecart.func_174899_a(BlockHandler.GROTTOL.func_176223_P());
                minecart.func_94086_l(minecart.func_94085_r());
            }
            return true;
        }
        return false;
    }

    public void func_110145_l(Entity entity) {
        super.func_110145_l(entity);
        if (EntityGrottol.isMinecart(entity)) {
            ((EntityMinecart)entity).func_94096_e(false);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.GROTTOL;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(MMSounds.EFFECT_GEOMANCY_BREAK, 1.0f, 1.3f);
        return null;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    public EnumDeathType getDeathType() {
        return this.death;
    }

    public static enum EnumDeathType {
        NORMAL,
        PICKAXE,
        FORTUNE_PICKAXE;

    }
}

