/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.frostmaw;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particles.ParticleCloud;
import com.bobmowzie.mowziesmobs.server.ai.MMEntityMoveHelper;
import com.bobmowzie.mowziesmobs.server.ai.MMPathNavigateGround;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAreaAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.LegSolverQuadruped;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBall;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBreath;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.spawn.SpawnHandler;
import com.bobmowzie.mowziesmobs.server.world.MowzieWorldGenerator;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityFrostmaw
extends MowzieEntity
implements IMob {
    public static final Animation DIE_ANIMATION = Animation.create((int)94);
    public static final Animation HURT_ANIMATION = Animation.create((int)0);
    public static final Animation ROAR_ANIMATION = Animation.create((int)76);
    public static final Animation SWIPE_ANIMATION = Animation.create((int)28);
    public static final Animation SWIPE_TWICE_ANIMATION = Animation.create((int)57);
    public static final Animation ICE_BREATH_ANIMATION = Animation.create((int)92);
    public static final Animation ICE_BALL_ANIMATION = Animation.create((int)50);
    public static final Animation ACTIVATE_ANIMATION = Animation.create((int)118);
    public static final Animation ACTIVATE_NO_CRYSTAL_ANIMATION = Animation.create((int)100);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create((int)25);
    public static final Animation DODGE_ANIMATION = Animation.create((int)15);
    public static final Animation LAND_ANIMATION = Animation.create((int)14);
    public static final Animation SLAM_ANIMATION = Animation.create((int)113);
    private static final DataParameter<Boolean> ACTIVE = EntityDataManager.func_187226_a(EntityFrostmaw.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_CRYSTAL = EntityDataManager.func_187226_a(EntityFrostmaw.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> CRYSTAL = EntityDataManager.func_187226_a(EntityFrostmaw.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final int ICE_BREATH_COOLDOWN = 260;
    public static final int ICE_BALL_COOLDOWN = 200;
    public static final int SLAM_COOLDOWN = 500;
    public static final int DODGE_COOLDOWN = 200;
    public EntityItem crystal;
    public EntityIceBreath iceBreath;
    public boolean swingWhichArm = false;
    private Vec3d prevRightHandPos = new Vec3d(0.0, 0.0, 0.0);
    private Vec3d prevLeftHandPos = new Vec3d(0.0, 0.0, 0.0);
    private int iceBreathCooldown = 0;
    private int iceBallCooldown = 0;
    private int slamCooldown = 0;
    private int timeWithoutTarget;
    private int shouldDodgeMeasure = 0;
    private int dodgeCooldown = 0;
    private boolean shouldDodge;
    private float dodgeYaw = 0.0f;
    private Vec3d prevTargetPos = new Vec3d(0.0, 0.0, 0.0);
    private boolean shouldPlayLandAnimation = false;
    public LegSolverQuadruped legSolver;

    public EntityFrostmaw(World world) {
        super(world);
        this.func_70105_a(4.0f, 4.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, new AnimationAreaAttackAI<EntityFrostmaw>(this, SWIPE_ANIMATION, null, null, 2.0f, 7.0f, 6.0f, 135.0f, ConfigHandler.FROSTMAW.combatData.attackMultiplier, 9));
        this.field_70714_bg.func_75776_a(2, new AnimationAreaAttackAI<EntityFrostmaw>(this, SWIPE_TWICE_ANIMATION, null, null, 1.0f, 7.0f, 6.0f, 135.0f, ConfigHandler.FROSTMAW.combatData.attackMultiplier, 9));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityFrostmaw>(this, ICE_BREATH_ANIMATION, true));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityFrostmaw>(this, ICE_BALL_ANIMATION, true));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityFrostmaw>(this, ROAR_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationActivateAI<EntityFrostmaw>(this, ACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationActivateAI<EntityFrostmaw>(this, ACTIVATE_NO_CRYSTAL_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationDeactivateAI<EntityFrostmaw>(this, DEACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityFrostmaw>(this, LAND_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityFrostmaw>(this, SLAM_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityFrostmaw>(this, DODGE_ANIMATION, true));
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityFrostmaw>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityFrostmaw>(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70138_W = 1.0f;
        this.frame += this.field_70146_Z.nextInt(50);
        this.legSolver = new LegSolverQuadruped(1.0f, 2.0f, -1.0f, 1.5f);
        this.socketPosArray = new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 0.0)};
        this.active = false;
        this.playsHurtAnimation = false;
        this.field_70177_z = this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70728_aV = 60;
        this.field_70765_h = new MMEntityMoveHelper((EntityLiving)this, 7.0f);
    }

    protected PathNavigate func_175447_b(World world) {
        return new MMPathNavigateGround(this, world);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0 * (double)ConfigHandler.FROSTMAW.combatData.healthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(HAS_CRYSTAL, (Object)true);
        this.func_184212_Q().func_187214_a(CRYSTAL, (Object)Optional.absent());
    }

    public void func_70642_aH() {
        if (!this.active) {
            return;
        }
        int i = this.field_70146_Z.nextInt(4);
        super.func_70642_aH();
        if (i == 0 && this.getAnimation() == NO_ANIMATION) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ROAR_ANIMATION);
            return;
        }
        if (i < MMSounds.ENTITY_FROSTMAW_LIVING.size()) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_LIVING.get(i)).get(), 2.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    @Override
    public void func_70071_h_() {
        this.field_70177_z = this.field_70761_aq;
        super.func_70071_h_();
        this.repelEntities(3.8f, 3.8f, 3.8f, 3.8f);
        if (this.func_70638_az() != null && (this.func_70638_az().field_70128_L || this.func_70638_az().func_110143_aJ() <= 0.0f)) {
            this.func_70624_b(null);
        }
        if (this.field_70173_aa == 1 && this.getHasCrystal()) {
            Optional<UUID> crystalID = this.getCrystalID();
            if (!(this.getCrystalID().isPresent() || this.field_70170_p.field_72995_K || this.crystal != null || this.getActive())) {
                this.crystal = this.func_145779_a(ItemHandler.ICE_CRYSTAL, 1);
                this.setCrystalID((Optional<UUID>)Optional.of((Object)this.crystal.func_110124_au()));
            }
            this.crystal = this.getCrystal();
            if (this.crystal != null) {
                this.crystal.func_174873_u();
                this.crystal.func_189654_d(true);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.crystal != null && this.crystal.field_70128_L && !this.getActive() && this.getAnimation() != DEACTIVATE_ANIMATION) {
            this.setHasCrystal(false);
            this.setCrystalID((Optional<UUID>)Optional.absent());
        }
        if (this.getActive() && this.getAnimation() != ACTIVATE_ANIMATION && this.getAnimation() != ACTIVATE_NO_CRYSTAL_ANIMATION) {
            this.legSolver.update((EntityLivingBase)this);
            if (this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) {
                int i;
                if (this.getAnimationTick() == 1) {
                    this.swingWhichArm = this.field_70146_Z.nextBoolean();
                }
                if (this.getAnimationTick() == 3 && (i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)MMSounds.ENTITY_FROSTMAW_ATTACK.size())) < MMSounds.ENTITY_FROSTMAW_ATTACK.size()) {
                    this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_ATTACK.get(i)).get(), 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            }
            if (this.getAnimation() == SWIPE_ANIMATION) {
                if (this.getAnimationTick() == 6) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_WHOOSH, 2.0f, 0.8f);
                }
                if (this.func_70638_az() != null) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                }
            }
            if (this.getAnimation() == SWIPE_TWICE_ANIMATION && this.currentAnim instanceof AnimationAreaAttackAI) {
                if (this.getAnimationTick() == 21) {
                    ((AnimationAreaAttackAI)this.currentAnim).hitEntities();
                }
                if (this.getAnimationTick() == 16) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_WHOOSH, 2.0f, 0.7f);
                }
                if (this.getAnimationTick() == 6) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_WHOOSH, 2.0f, 0.8f);
                }
                if (this.func_70638_az() != null) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                }
            }
            if (this.getAnimation() == ROAR_ANIMATION) {
                if (this.getAnimationTick() == 10) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_ROAR, 4.0f, 1.0f);
                }
                if (this.getAnimationTick() >= 8 && this.getAnimationTick() < 65) {
                    this.doRoarEffects();
                }
            }
            if (this.getAnimation() == LAND_ANIMATION && this.getAnimationTick() == 3) {
                this.func_184185_a(MMSounds.ENTITY_FROSTMAW_LAND, 3.0f, 0.9f);
            }
            if (this.getAnimation() == SLAM_ANIMATION) {
                if (this.getAnimationTick() == 82) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_LIVING_1, 2.0f, 1.0f);
                }
                if (this.func_70638_az() != null) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                }
                if (this.getAnimationTick() == 82) {
                    int i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)(MMSounds.ENTITY_FROSTMAW_ATTACK.size() - 1));
                    if (i < MMSounds.ENTITY_FROSTMAW_ATTACK.size()) {
                        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_ATTACK.get(i)).get(), 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
                    }
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_WHOOSH, 2.0f, 0.7f);
                }
                if (this.getAnimationTick() == 87) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_LAND, 3.0f, 1.0f);
                    float radius = 4.0f;
                    float slamPosX = (float)(this.field_70165_t + (double)radius * Math.cos(Math.toRadians(this.field_70177_z + 90.0f)));
                    float slamPosZ = (float)(this.field_70161_v + (double)radius * Math.sin(Math.toRadians(this.field_70177_z + 90.0f)));
                    if (this.field_70170_p.field_72995_K) {
                        MMParticle.RING.spawn(this.field_70170_p, slamPosX, this.field_70163_u + (double)0.2f, slamPosZ, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(Float.valueOf(0.0f), Float.valueOf(1.5707964f), 17, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(60.0f), false, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
                    }
                    AxisAlignedBB hitBox = new AxisAlignedBB(new BlockPos((double)(slamPosX - 0.5f), this.field_70163_u, (double)(slamPosZ - 0.5f))).func_72314_b(3.0, 3.0, 3.0);
                    List entitiesHit = this.field_70170_p.func_72872_a(EntityLivingBase.class, hitBox);
                    for (EntityLivingBase entity : entitiesHit) {
                        if (entity == this) continue;
                        this.attackEntityAsMob((Entity)entity, 4.0f * ConfigHandler.FROSTMAW.combatData.attackMultiplier);
                        if (!entity.func_184585_cz()) continue;
                        entity.func_184607_cu().func_77972_a(400, entity);
                    }
                }
            }
            if (this.getAnimation() == DODGE_ANIMATION && !this.field_70170_p.field_72995_K) {
                this.func_70661_as().func_75499_g();
                if (this.getAnimationTick() == 2) {
                    this.dodgeYaw = (float)Math.toRadians(this.targetAngle + 90.0f + this.field_70146_Z.nextFloat() * 150.0f - 75.0f);
                }
                if (this.getAnimationTick() == 6 && this.field_70122_E) {
                    this.field_70181_x = 0.6;
                    float speed = 1.7f;
                    this.field_70159_w += (double)((float)((double)speed * Math.cos(this.dodgeYaw)));
                    this.field_70179_y += (double)((float)((double)speed * Math.sin(this.dodgeYaw)));
                }
                if (this.func_70638_az() != null) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                }
            }
            if (this.getAnimation() == ICE_BREATH_ANIMATION) {
                if (this.func_70638_az() != null) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                    this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                }
                Vec3d mouthPos = new Vec3d(2.3, 2.65, 0.0);
                mouthPos = mouthPos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
                mouthPos = mouthPos.func_178787_e(this.func_174791_d());
                mouthPos = mouthPos.func_178787_e(new Vec3d(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70759_as)));
                if (this.getAnimationTick() == 13) {
                    this.iceBreath = new EntityIceBreath(this.field_70170_p, (EntityLivingBase)this);
                    this.iceBreath.func_70080_a(mouthPos.field_72450_a, mouthPos.field_72448_b, mouthPos.field_72449_c, this.field_70759_as, this.field_70125_A + 10.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)this.iceBreath);
                    }
                }
                if (this.iceBreath != null) {
                    this.iceBreath.func_70080_a(mouthPos.field_72450_a, mouthPos.field_72448_b, mouthPos.field_72449_c, this.field_70759_as, this.field_70125_A + 10.0f);
                }
            }
            if (this.getAnimation() == ICE_BALL_ANIMATION) {
                if (this.func_70638_az() != null) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 15.0f, 15.0f);
                }
                Vec3d projectilePos = new Vec3d(2.0, 1.7, 0.0);
                projectilePos = projectilePos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
                projectilePos = projectilePos.func_178787_e(this.func_174791_d());
                projectilePos = projectilePos.func_178787_e(new Vec3d(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70759_as)));
                if (this.field_70170_p.field_72995_K) {
                    Vec3d mouthPos = this.socketPosArray[2];
                    if (this.getAnimationTick() < 12) {
                        Vec3d particlePos;
                        int i;
                        for (i = 0; i < 6; ++i) {
                            particlePos = new Vec3d(3.5, 0.0, 0.0);
                            particlePos = particlePos.func_178785_b((float)(Math.random() * 2.0 * Math.PI));
                            particlePos = particlePos.func_178789_a((float)(Math.random() * 2.0 * Math.PI));
                            double value = this.field_70146_Z.nextFloat() * 0.15f;
                            MMParticle.CLOUD.spawn(this.field_70170_p, mouthPos.field_72450_a + particlePos.field_72450_a, mouthPos.field_72448_b + particlePos.field_72448_b, mouthPos.field_72449_c + particlePos.field_72449_c, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{-0.1 * particlePos.field_72450_a, -0.1 * particlePos.field_72448_b, -0.1 * particlePos.field_72449_c, 0.75 + value, 0.75 + value, 1.0, 1, 5.0 + this.field_70146_Z.nextDouble() * 15.0, 30, ParticleCloud.EnumCloudBehavior.CONSTANT}));
                        }
                        for (i = 0; i < 8; ++i) {
                            particlePos = new Vec3d(3.5, 0.0, 0.0);
                            particlePos = particlePos.func_178785_b((float)(Math.random() * 2.0 * Math.PI));
                            particlePos = particlePos.func_178789_a((float)(Math.random() * 2.0 * Math.PI));
                            MMParticle.SNOWFLAKE.spawn(this.field_70170_p, mouthPos.field_72450_a + particlePos.field_72450_a, mouthPos.field_72448_b + particlePos.field_72448_b, mouthPos.field_72449_c + particlePos.field_72449_c, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(-0.07 * particlePos.field_72450_a, -0.07 * particlePos.field_72448_b, -0.07 * particlePos.field_72449_c));
                        }
                    }
                }
                if (this.getAnimationTick() == 1) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_ICEBALL_CHARGE, 2.0f, 0.9f);
                }
                if (this.getAnimationTick() == 32 && this.func_70638_az() != null) {
                    this.prevTargetPos = this.func_70638_az().func_174791_d().func_178787_e(new Vec3d(0.0, (double)this.func_70638_az().func_70047_e(), 0.0));
                }
                if (this.getAnimationTick() == 33) {
                    this.func_184185_a(MMSounds.ENTITY_FROSTMAW_ICEBALL_SHOOT, 2.0f, 0.7f);
                    EntityIceBall iceBall = new EntityIceBall(this.field_70170_p, (EntityLivingBase)this);
                    iceBall.func_70080_a(projectilePos.field_72450_a, projectilePos.field_72448_b, projectilePos.field_72449_c, this.field_70759_as, this.field_70125_A + 10.0f);
                    float projSpeed = 1.6f;
                    if (this.func_70638_az() != null) {
                        float ticksUntilHit = this.targetDistance / projSpeed;
                        Vec3d targetPos = this.func_70638_az().func_174791_d().func_178787_e(new Vec3d(0.0, (double)this.func_70638_az().func_70047_e(), 0.0));
                        Vec3d targetMovement = targetPos.func_178788_d(this.prevTargetPos).func_186678_a((double)ticksUntilHit * 0.95);
                        targetMovement = targetMovement.func_178786_a(0.0, targetMovement.field_72448_b, 0.0);
                        Vec3d futureTargetPos = targetPos.func_178787_e(targetMovement);
                        Vec3d shootVec = futureTargetPos.func_178788_d(projectilePos).func_72432_b();
                        iceBall.func_70186_c(shootVec.field_72450_a, shootVec.field_72448_b, shootVec.field_72449_c, projSpeed, 0.0f);
                    } else {
                        iceBall.func_70186_c(this.func_70040_Z().field_72450_a, this.func_70040_Z().field_72448_b, this.func_70040_Z().field_72449_c, projSpeed, 0.0f);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)iceBall);
                    }
                }
            }
            this.spawnSwipeParticles();
            if ((double)this.field_70143_R > 0.2 && !this.field_70122_E || this.getAnimation() == DODGE_ANIMATION) {
                this.shouldPlayLandAnimation = true;
            }
            if (this.field_70122_E && this.shouldPlayLandAnimation && this.getAnimation() != DODGE_ANIMATION) {
                if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LAND_ANIMATION);
                }
                this.shouldPlayLandAnimation = false;
            }
            if (this.func_70638_az() != null) {
                this.timeWithoutTarget = 0;
                float entityHitAngle = (float)((Math.atan2(this.func_70638_az().field_70161_v - this.field_70161_v, this.func_70638_az().field_70165_t - this.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.field_70761_aq % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                if (!(!this.func_70661_as().func_75500_f() || entityRelativeAngle <= 15.0f && entityRelativeAngle >= -15.0f || entityRelativeAngle >= 345.0f || entityRelativeAngle <= -345.0f)) {
                    this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.85);
                }
                if (this.shouldDodgeMeasure >= 14) {
                    this.shouldDodge = true;
                }
                if (this.targetDistance < 4.0f && this.shouldDodge && this.getAnimation() == NO_ANIMATION) {
                    this.shouldDodge = false;
                    this.dodgeCooldown = 200;
                    this.shouldDodgeMeasure = 0;
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, DODGE_ANIMATION);
                }
                if (this.targetDistance > 6.0f && (this.getAnimation() != ICE_BREATH_ANIMATION || !(this.targetDistance < 8.0f)) && this.field_70122_E) {
                    if (this.getAnimation() != SLAM_ANIMATION) {
                        this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 1.0);
                    } else {
                        this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.95);
                    }
                } else {
                    this.func_70661_as().func_75499_g();
                }
                if (this.targetDistance <= 9.0f && this.getAnimation() == NO_ANIMATION && this.slamCooldown <= 0 && this.field_70146_Z.nextInt(4) == 0 && !this.func_70638_az().func_70644_a((Potion)PotionHandler.FROZEN) && (double)(this.func_110143_aJ() / this.func_110138_aP()) < 0.6) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SLAM_ANIMATION);
                    this.slamCooldown = 500;
                }
                if (this.targetDistance <= 7.0f && this.getAnimation() == NO_ANIMATION) {
                    if (this.field_70146_Z.nextInt(4) == 0) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SWIPE_TWICE_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SWIPE_ANIMATION);
                    }
                }
                if (this.targetDistance >= 4.0f && this.targetDistance <= 14.0f && this.getAnimation() == NO_ANIMATION && this.iceBreathCooldown <= 0 && this.getHasCrystal() && this.field_70122_E) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ICE_BREATH_ANIMATION);
                    this.iceBreathCooldown = 260;
                }
                if (this.targetDistance >= 15.0f && this.getAnimation() == NO_ANIMATION && this.iceBallCooldown <= 0 && this.getHasCrystal() && this.field_70122_E) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ICE_BALL_ANIMATION);
                    this.iceBallCooldown = 200;
                }
            } else if (!this.field_70170_p.field_72995_K) {
                ++this.timeWithoutTarget;
                if (this.timeWithoutTarget > 1200 || this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                    this.timeWithoutTarget = 0;
                    if (this.getAnimation() == NO_ANIMATION) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, DEACTIVATE_ANIMATION);
                        this.setActive(false);
                    }
                }
            }
        } else {
            this.func_70661_as().func_75499_g();
            this.field_70761_aq = this.field_70760_ar;
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20, 1, true, true));
            if (this.func_70638_az() != null && this.func_70638_az().func_70644_a(MobEffects.field_76441_p)) {
                this.func_70624_b(null);
            }
            if (!this.getAttackableEntityLivingBaseNearby(8.0, 8.0, 8.0, 8.0).isEmpty() && this.func_70638_az() != null && this.getAnimation() == NO_ANIMATION && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                if (this.getHasCrystal()) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_ANIMATION);
                } else {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                }
                this.setActive(true);
            }
            if (this.crystal != null) {
                this.crystal.func_189654_d(true);
                this.crystal.field_70159_w = 0.0;
                this.crystal.field_70181_x = 0.0;
                this.crystal.field_70179_y = 0.0;
                Vec3d crystalPos = new Vec3d(1.6, 0.4, 1.8);
                crystalPos = crystalPos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
                crystalPos = crystalPos.func_178787_e(this.func_174791_d());
                this.crystal.func_70107_b(crystalPos.field_72450_a, crystalPos.field_72448_b, crystalPos.field_72449_c);
            }
        }
        if (this.getAnimation() == ACTIVATE_ANIMATION || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION) {
            if (this.getAnimationTick() == 1) {
                this.func_184185_a(MMSounds.ENTITY_FROSTMAW_WAKEUP, 1.0f, 1.0f);
            }
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() == 18) {
                this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_ATTACK.get(0)).get(), 1.5f, 1.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.crystal != null) {
                this.crystal.func_70106_y();
                this.setCrystalID((Optional<UUID>)Optional.absent());
            }
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() == 52 || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION && this.getAnimationTick() == 34) {
                this.func_184185_a(MMSounds.ENTITY_FROSTMAW_ROAR, 4.0f, 1.0f);
            }
            if (this.getAnimation() == ACTIVATE_ANIMATION && this.getAnimationTick() >= 51 && this.getAnimationTick() < 108 || this.getAnimation() == ACTIVATE_NO_CRYSTAL_ANIMATION && this.getAnimationTick() >= 33 && this.getAnimationTick() < 90) {
                this.doRoarEffects();
            }
        }
        if (this.getAnimation() == DEACTIVATE_ANIMATION && this.getAnimationTick() == 10 && this.getHasCrystal()) {
            Optional<UUID> crystalID = this.getCrystalID();
            if (!(this.getCrystalID().isPresent() || this.field_70170_p.field_72995_K || this.crystal != null && !this.crystal.field_70128_L)) {
                this.crystal = this.func_145779_a(ItemHandler.ICE_CRYSTAL, 1);
                this.setCrystalID((Optional<UUID>)Optional.of((Object)this.crystal.func_110124_au()));
            }
            this.crystal = this.getCrystal();
            if (this.crystal != null) {
                this.crystal.func_174873_u();
                this.crystal.func_189654_d(true);
            }
        }
        float moveX = (float)(this.field_70165_t - this.field_70169_q);
        float moveZ = (float)(this.field_70161_v - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if (this.frame % 16 == 5 && (double)speed > 0.05 && this.active) {
            this.func_184185_a(MMSounds.ENTITY_FROSTMAW_STEP, 3.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        if (this.frame % 118 == 1 && !this.active) {
            int i = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)1);
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_FROSTMAW_BREATH.get(i)).get(), 1.5f, 1.1f + this.field_70146_Z.nextFloat() * 0.1f);
        }
        if (this.iceBreathCooldown > 0) {
            --this.iceBreathCooldown;
        }
        if (this.iceBallCooldown > 0) {
            --this.iceBallCooldown;
        }
        if (this.slamCooldown > 0) {
            --this.slamCooldown;
        }
        if (this.shouldDodgeMeasure > 0 && this.field_70173_aa % 7 == 0) {
            --this.shouldDodgeMeasure;
        }
        if (this.dodgeCooldown > 0) {
            --this.dodgeCooldown;
        }
        this.field_70126_B = this.field_70177_z;
    }

    private void doRoarEffects() {
        List<EntityLivingBase> entities = this.getEntityLivingBaseNearby(10.0, 3.0, 10.0, 10.0);
        for (EntityLivingBase entity : entities) {
            double angle = (this.getAngleBetweenEntities((Entity)this, (Entity)entity) + 90.0) * Math.PI / 180.0;
            double distance = this.func_70032_d((Entity)entity) - 4.0f;
            entity.field_70159_w += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.cos(angle);
            entity.field_70179_y += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.sin(angle);
        }
        if (this.getAnimationTick() % 12 == 0 && this.field_70170_p.field_72995_K) {
            double zSpeed;
            double xSpeed;
            double speed;
            double yaw;
            int i;
            int particleCount = 15;
            for (i = 1; i <= particleCount; ++i) {
                yaw = i * 360 / particleCount;
                speed = 0.9;
                xSpeed = speed * Math.cos(Math.toRadians(yaw));
                zSpeed = speed * Math.sin(Math.toRadians(yaw));
                MMParticle.CLOUD.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{xSpeed, 0.0, zSpeed, 0.75, 0.75, 1.0, 1, 40.0, 22, ParticleCloud.EnumCloudBehavior.GROW}));
            }
            for (i = 1; i <= particleCount; ++i) {
                yaw = i * 360 / particleCount;
                speed = 0.65;
                xSpeed = speed * Math.cos(Math.toRadians(yaw));
                zSpeed = speed * Math.sin(Math.toRadians(yaw));
                MMParticle.CLOUD.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{xSpeed, 0.0, zSpeed, 0.75, 0.75, 1.0, 1, 35.0, 22, ParticleCloud.EnumCloudBehavior.GROW}));
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        List<EntityLivingBase> nearby = this.getEntityLivingBaseNearby(100.0, 100.0, 100.0, 100.0);
        for (EntityLivingBase nearbyEntity : nearby) {
            if (!(nearbyEntity instanceof EntityFrostmaw) && !(nearbyEntity instanceof EntityVillager)) continue;
            return false;
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 1;
    }

    private void spawnSwipeParticles() {
        if (this.field_70170_p.field_72995_K) {
            int snowflakeDensity = 4;
            float snowflakeRandomness = 0.5f;
            int cloudDensity = 2;
            float cloudRandomness = 0.5f;
            if (this.getAnimation() == SWIPE_ANIMATION || this.getAnimation() == SWIPE_TWICE_ANIMATION) {
                Vec3d rightHandPos = this.socketPosArray[0];
                Vec3d leftHandPos = this.socketPosArray[1];
                if (this.getAnimation() == SWIPE_ANIMATION) {
                    if (this.getAnimationTick() > 8 && this.getAnimationTick() < 14) {
                        if (this.swingWhichArm) {
                            double length = this.prevRightHandPos.func_178788_d(rightHandPos).func_72433_c();
                            int numClouds = (int)Math.floor(2.0 * length);
                            for (int i = 0; i < numClouds; ++i) {
                                float zOffset;
                                float yOffset;
                                float xOffset;
                                int j;
                                double x = this.prevRightHandPos.field_72450_a + (double)i * (rightHandPos.field_72450_a - this.prevRightHandPos.field_72450_a) / (double)numClouds;
                                double y = this.prevRightHandPos.field_72448_b + (double)i * (rightHandPos.field_72448_b - this.prevRightHandPos.field_72448_b) / (double)numClouds;
                                double z = this.prevRightHandPos.field_72449_c + (double)i * (rightHandPos.field_72449_c - this.prevRightHandPos.field_72449_c) / (double)numClouds;
                                for (j = 0; j < snowflakeDensity; ++j) {
                                    xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    MMParticle.SNOWFLAKE.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this.field_70159_w, this.field_70181_x - (double)0.01f, this.field_70179_y));
                                }
                                for (j = 0; j < cloudDensity; ++j) {
                                    xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    double value = this.field_70146_Z.nextFloat() * 0.1f;
                                    MMParticle.CLOUD.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.8 + value, 0.8 + value, 1.0, 1, 10.0 + this.field_70146_Z.nextDouble() * 10.0, 40, ParticleCloud.EnumCloudBehavior.SHRINK}));
                                }
                            }
                        } else {
                            double length = this.prevLeftHandPos.func_178788_d(leftHandPos).func_72433_c();
                            int numClouds = (int)Math.floor(2.5 * length);
                            for (int i = 0; i < numClouds; ++i) {
                                float zOffset;
                                float yOffset;
                                float xOffset;
                                int j;
                                double x = this.prevLeftHandPos.field_72450_a + (double)i * (leftHandPos.field_72450_a - this.prevLeftHandPos.field_72450_a) / (double)numClouds;
                                double y = this.prevLeftHandPos.field_72448_b + (double)i * (leftHandPos.field_72448_b - this.prevLeftHandPos.field_72448_b) / (double)numClouds;
                                double z = this.prevLeftHandPos.field_72449_c + (double)i * (leftHandPos.field_72449_c - this.prevLeftHandPos.field_72449_c) / (double)numClouds;
                                for (j = 0; j < snowflakeDensity; ++j) {
                                    xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    MMParticle.SNOWFLAKE.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this.field_70159_w, this.field_70181_x - (double)0.01f, this.field_70179_y));
                                }
                                for (j = 0; j < cloudDensity; ++j) {
                                    xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                                    double value = this.field_70146_Z.nextFloat() * 0.1f;
                                    MMParticle.CLOUD.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.8 + value, 0.8 + value, 1.0, 1, 10.0 + this.field_70146_Z.nextDouble() * 10.0, 40, ParticleCloud.EnumCloudBehavior.SHRINK}));
                                }
                            }
                        }
                    }
                } else if (this.swingWhichArm && this.getAnimationTick() > 8 && this.getAnimationTick() < 14 || !this.swingWhichArm && this.getAnimationTick() > 19 && this.getAnimationTick() < 25) {
                    double length = this.prevRightHandPos.func_178788_d(rightHandPos).func_72433_c();
                    int numClouds = (int)Math.floor(2.0 * length);
                    for (int i = 0; i < numClouds; ++i) {
                        float zOffset;
                        float yOffset;
                        float xOffset;
                        int j;
                        double x = this.prevRightHandPos.field_72450_a + (double)i * (rightHandPos.field_72450_a - this.prevRightHandPos.field_72450_a) / (double)numClouds;
                        double y = this.prevRightHandPos.field_72448_b + (double)i * (rightHandPos.field_72448_b - this.prevRightHandPos.field_72448_b) / (double)numClouds;
                        double z = this.prevRightHandPos.field_72449_c + (double)i * (rightHandPos.field_72449_c - this.prevRightHandPos.field_72449_c) / (double)numClouds;
                        for (j = 0; j < snowflakeDensity; ++j) {
                            xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            MMParticle.SNOWFLAKE.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this.field_70159_w, this.field_70181_x - (double)0.01f, this.field_70179_y));
                        }
                        for (j = 0; j < cloudDensity; ++j) {
                            xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            double value = this.field_70146_Z.nextFloat() * 0.1f;
                            MMParticle.CLOUD.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.8 + value, 0.8 + value, 1.0, 1, 10.0 + this.field_70146_Z.nextDouble() * 10.0, 40, ParticleCloud.EnumCloudBehavior.SHRINK}));
                        }
                    }
                } else if (!this.swingWhichArm && this.getAnimationTick() > 8 && this.getAnimationTick() < 14 || this.swingWhichArm && this.getAnimationTick() > 19 && this.getAnimationTick() < 25) {
                    double length = this.prevLeftHandPos.func_178788_d(leftHandPos).func_72433_c();
                    int numClouds = (int)Math.floor(2.5 * length);
                    for (int i = 0; i < numClouds; ++i) {
                        float zOffset;
                        float yOffset;
                        float xOffset;
                        int j;
                        double x = this.prevLeftHandPos.field_72450_a + (double)i * (leftHandPos.field_72450_a - this.prevLeftHandPos.field_72450_a) / (double)numClouds;
                        double y = this.prevLeftHandPos.field_72448_b + (double)i * (leftHandPos.field_72448_b - this.prevLeftHandPos.field_72448_b) / (double)numClouds;
                        double z = this.prevLeftHandPos.field_72449_c + (double)i * (leftHandPos.field_72449_c - this.prevLeftHandPos.field_72449_c) / (double)numClouds;
                        for (j = 0; j < snowflakeDensity; ++j) {
                            xOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = snowflakeRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            MMParticle.SNOWFLAKE.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(this.field_70159_w, this.field_70181_x - (double)0.01f, this.field_70179_y));
                        }
                        for (j = 0; j < cloudDensity; ++j) {
                            xOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            yOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            zOffset = cloudRandomness * (2.0f * this.field_70146_Z.nextFloat() - 1.0f);
                            double value = this.field_70146_Z.nextFloat() * 0.1f;
                            MMParticle.CLOUD.spawn(this.field_70170_p, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.8 + value, 0.8 + value, 1.0, 1, 10.0 + this.field_70146_Z.nextDouble() * 10.0, 40, ParticleCloud.EnumCloudBehavior.SHRINK}));
                        }
                    }
                }
                this.prevLeftHandPos = leftHandPos;
                this.prevRightHandPos = rightHandPos;
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityArrow) {
            this.func_184185_a(SoundEvents.field_187689_f, 0.4f, 2.0f);
            Entity entity = source.func_76346_g();
            if (!(entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || this.func_70638_az() != null || entity instanceof EntityFrostmaw)) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            if (!this.getActive()) {
                if (this.getAnimation() != DIE_ANIMATION && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                    if (this.getHasCrystal()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                    }
                }
                this.setActive(true);
            }
            return false;
        }
        boolean attack = super.func_70097_a(source, damage);
        if (attack) {
            this.shouldDodgeMeasure = (int)((float)this.shouldDodgeMeasure + damage);
            Entity entity = source.func_76346_g();
            if (!(entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || this.func_70638_az() != null || entity instanceof EntityFrostmaw)) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            if (!this.getActive()) {
                if (this.getAnimation() != DIE_ANIMATION && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                    if (this.getHasCrystal()) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_ANIMATION);
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_NO_CRYSTAL_ANIMATION);
                    }
                }
                this.setActive(true);
            }
        }
        return attack;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Override
    public boolean attackEntityAsMob(Entity entityIn, float damageMultiplier) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * damageMultiplier;
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        if (this.getAnimationTick() == 5) {
            this.func_184185_a(MMSounds.ENTITY_FROSTMAW_DIE, 2.5f, 1.0f);
        } else if (this.getAnimationTick() == 53) {
            this.func_184185_a(MMSounds.ENTITY_FROSTMAW_LAND, 2.5f, 1.0f);
        }
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public void setActive(boolean active) {
        this.func_184212_Q().func_187227_b(ACTIVE, (Object)active);
    }

    public boolean getActive() {
        this.active = (Boolean)this.func_184212_Q().func_187225_a(ACTIVE);
        return this.active;
    }

    public void setHasCrystal(boolean hasCrystal) {
        this.func_184212_Q().func_187227_b(HAS_CRYSTAL, (Object)hasCrystal);
    }

    public boolean getHasCrystal() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_CRYSTAL);
    }

    public void setCrystalID(Optional<UUID> crystalID) {
        this.func_184212_Q().func_187227_b(CRYSTAL, crystalID);
    }

    public Optional<UUID> getCrystalID() {
        return (Optional)this.func_184212_Q().func_187225_a(CRYSTAL);
    }

    public EntityItem getCrystal() {
        Optional<UUID> uuid = this.getCrystalID();
        if (uuid.isPresent()) {
            List potentialCrystals = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(32.0, 32.0, 32.0));
            for (EntityItem entity : potentialCrystals) {
                if (!((UUID)uuid.get()).equals(entity.func_110124_au())) continue;
                return entity;
            }
        }
        return null;
    }

    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ROAR_ANIMATION, SWIPE_ANIMATION, SWIPE_TWICE_ANIMATION, ICE_BREATH_ANIMATION, ICE_BALL_ANIMATION, ACTIVATE_ANIMATION, ACTIVATE_NO_CRYSTAL_ANIMATION, DEACTIVATE_ANIMATION, SLAM_ANIMATION, LAND_ANIMATION, DODGE_ANIMATION};
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.crystal != null) {
            this.crystal.func_70106_y();
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHasCrystal(compound.func_74767_n("has_crystal"));
        this.setActive(compound.func_74767_n("active"));
        String uuid = compound.func_74779_i("crystalUUID");
        if (uuid.isEmpty()) {
            this.setCrystalID((Optional<UUID>)Optional.absent());
        } else {
            this.setCrystalID((Optional<UUID>)Optional.of((Object)UUID.fromString(uuid)));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("has_crystal", this.getHasCrystal());
        compound.func_74757_a("active", this.getActive());
        Optional<UUID> crystalUUID = this.getCrystalID();
        if (crystalUUID.isPresent()) {
            compound.func_74778_a("crystalUUID", ((UUID)crystalUUID.get()).toString());
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        return super.func_180482_a(difficulty, livingdata);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.FROSTMAW;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void spawnInWorld(World world, Random rand, int x, int z) {
        int y;
        Biome biome = world.func_180494_b(new BlockPos(x, 50, z));
        if (rand.nextFloat() > ConfigHandler.FROSTMAW.generationData.generationChance) {
            return;
        }
        if (!SpawnHandler.FROSTMAW_BIOMES.contains(biome)) {
            return;
        }
        BlockPos pos = new BlockPos(x, 0, z);
        int heightMax = (int)ConfigHandler.FROSTMAW.generationData.heightMax;
        int heightMin = (int)ConfigHandler.FROSTMAW.generationData.heightMin;
        if (heightMax == -1) {
            heightMax = world.func_72800_K();
        }
        if (heightMin == -1) {
            heightMin = 0;
        }
        if ((y = MowzieWorldGenerator.findGenHeight(world, pos, heightMax, heightMin) + 1) == 0) {
            return;
        }
        this.func_70080_a(x, y, z, rand.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)this);
        this.func_180482_a(world.func_175649_E(new BlockPos(x, y, z)), null);
    }
}

