/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.server.ai.BarakoaAttackTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoan;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityBarakoana
extends EntityBarakoa
implements LeaderSunstrikeImmune {
    private List<EntityBarakoanToBarakoana> pack = new ArrayList<EntityBarakoanToBarakoana>();
    private int packRadius = 3;

    public EntityBarakoana(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new BarakoaHurtByTargetAI(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCow.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPig.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySheep.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 6.0f, 1.0, 1.2));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new BarakoaAttackTargetAI(this, EntityPlayer.class, 0, true, false));
        this.setMask(MaskType.FURY);
        this.field_70728_aV = 12;
    }

    @Override
    protected boolean canHoldVaryingWeapons() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < this.pack.size(); ++i) {
            this.pack.get((int)i).index = i;
        }
        if (!this.field_70170_p.field_72995_K && this.pack != null) {
            float theta = (float)Math.PI * 2 / (float)this.pack.size();
            for (int i = 0; i < this.pack.size(); ++i) {
                EntityBarakoanToBarakoana hunter = this.pack.get(i);
                if (hunter.func_70638_az() != null) continue;
                hunter.func_70661_as().func_75492_a(this.field_70165_t + (double)((float)this.packRadius * MathHelper.func_76134_b((float)(theta * (float)i))), this.field_70163_u, this.field_70161_v + (double)((float)this.packRadius * MathHelper.func_76126_a((float)(theta * (float)i))), 0.45);
                if (!(this.func_70032_d((Entity)hunter) > 20.0f) || !this.field_70122_E) continue;
                hunter.func_70107_b(this.field_70165_t + (double)((float)this.packRadius * MathHelper.func_76134_b((float)(theta * (float)i))), this.field_70163_u, this.field_70161_v + (double)((float)this.packRadius * MathHelper.func_76126_a((float)(theta * (float)i))));
            }
        }
    }

    public void func_70106_y() {
        if (this.field_70173_aa == 0) {
            this.pack.forEach(EntityBarakoan::setShouldSetDead);
        }
        super.func_70106_y();
    }

    @Override
    public boolean func_70058_J() {
        if (this.field_70173_aa == 0) {
            return !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
        }
        return !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, damage);
    }

    public void removePackMember(EntityBarakoanToBarakoana tribeHunter) {
        this.pack.remove(tribeHunter);
        this.sortPackMembers();
    }

    public void addPackMember(EntityBarakoanToBarakoana tribeHunter) {
        this.pack.add(tribeHunter);
        this.sortPackMembers();
    }

    private void sortPackMembers() {
        double theta = Math.PI * 2 / (double)this.pack.size();
        for (int i = 0; i < this.pack.size(); ++i) {
            int nearestIndex = -1;
            double smallestDiffSq = Double.MAX_VALUE;
            double targetTheta = theta * (double)i;
            double x = this.field_70165_t + (double)this.packRadius * Math.cos(targetTheta);
            double z = this.field_70161_v + (double)this.packRadius * Math.sin(targetTheta);
            for (int n = 0; n < this.pack.size(); ++n) {
                EntityBarakoanToBarakoana tribeHunter = this.pack.get(n);
                double diffSq = (x - tribeHunter.field_70165_t) * (x - tribeHunter.field_70165_t) + (z - tribeHunter.field_70161_v) * (z - tribeHunter.field_70161_v);
                if (!(diffSq < smallestDiffSq)) continue;
                smallestDiffSq = diffSq;
                nearestIndex = n;
            }
            if (nearestIndex == -1) {
                throw new ArithmeticException("All pack members have NaN x and z?");
            }
            this.pack.add(i, this.pack.remove(nearestIndex));
        }
    }

    public int getPackSize() {
        return this.pack.size();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        int size = this.field_70146_Z.nextInt(2) + 3;
        float theta = (float)Math.PI * 2 / (float)size;
        for (int i = 0; i <= size; ++i) {
            EntityBarakoanToBarakoana tribeHunter = new EntityBarakoanToBarakoana(this.field_70170_p, this);
            tribeHunter.func_70107_b(this.field_70165_t + 0.1 * (double)MathHelper.func_76134_b((float)(theta * (float)i)), this.field_70163_u, this.field_70161_v + 0.1 * (double)MathHelper.func_76126_a((float)(theta * (float)i)));
            int weapon = this.field_70146_Z.nextInt(3) == 0 ? 1 : 0;
            tribeHunter.setWeapon(weapon);
            this.field_70170_p.func_72838_d((Entity)tribeHunter);
        }
        return super.func_180482_a(difficulty, data);
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.pack.forEach(EntityBarakoanToBarakoana::removeLeader);
    }

    @Override
    protected ConfigHandler.SpawnData getSpawnConfig() {
        return ConfigHandler.BARAKOA.spawnData;
    }

    @Override
    public boolean func_70601_bi() {
        List<EntityLivingBase> nearby = this.getEntityLivingBaseNearby(20.0, 4.0, 20.0, 20.0);
        for (EntityLivingBase nearbyEntity : nearby) {
            if (!(nearbyEntity instanceof EntityBarakoana) && !(nearbyEntity instanceof EntityVillager) && !(nearbyEntity instanceof EntityBarako) && !(nearbyEntity instanceof EntityAnimal)) continue;
            return false;
        }
        return super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_70623_bb() {
        Event.Result result;
        if (this.func_104002_bU()) {
            this.field_70708_bq = 0;
        } else if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.pack.forEach(EntityBarakoan::setShouldSetDead);
                this.func_70106_y();
            }
        } else {
            EntityPlayer closestPlayer = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (closestPlayer != null) {
                double dX = closestPlayer.field_70165_t - this.field_70165_t;
                double dY = closestPlayer.field_70163_u - this.field_70163_u;
                double dZ = closestPlayer.field_70161_v - this.field_70161_v;
                double distance = dX * dX + dY * dY + dZ * dZ;
                if (this.func_70692_ba() && distance > 16384.0) {
                    this.pack.forEach(EntityBarakoan::setShouldSetDead);
                    this.func_70106_y();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && distance > 1024.0 && this.func_70692_ba()) {
                    this.pack.forEach(EntityBarakoan::setShouldSetDead);
                    this.func_70106_y();
                } else if (distance < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }
}

