/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.config;

import java.io.File;
import net.minecraftforge.common.config.Config;

@Config(modid="mowziesmobs", category="", name="mowziesmobs")
public class ConfigHandler {
    @Config.Ignore
    public static File configDir;
    @Config.Ignore
    private static final String LANG_PREFIX = "config.mowziesmobs.";
    @Config.Name(value="foliaath")
    @Config.LangKey(value="config.mowziesmobs.foliaath")
    public static final Foliaath FOLIAATH;
    @Config.Name(value="barakoa")
    @Config.LangKey(value="config.mowziesmobs.barakoa")
    public static final Barakoa BARAKOA;
    @Config.Name(value="naga")
    @Config.LangKey(value="config.mowziesmobs.naga")
    public static final Naga NAGA;
    @Config.Name(value="lantern")
    @Config.LangKey(value="config.mowziesmobs.lantern")
    public static final Lantern LANTERN;
    @Config.Name(value="grottol")
    @Config.LangKey(value="config.mowziesmobs.grottol")
    public static final Grottol GROTTOL;
    @Config.Name(value="ferrous_wroughtnaut")
    @Config.LangKey(value="config.mowziesmobs.ferrous_wroughtnaut")
    public static final Ferrous_Wroughtnaut FERROUS_WROUGHTNAUT;
    @Config.Name(value="barako")
    @Config.LangKey(value="config.mowziesmobs.barako")
    public static final Barako BARAKO;
    @Config.Name(value="frostmaw")
    @Config.LangKey(value="config.mowziesmobs.frostmaw")
    public static final Frostmaw FROSTMAW;
    @Config.Name(value="tools_and_abilities")
    @Config.LangKey(value="config.mowziesmobs.tools_and_abilities")
    public static final ToolsAndAbilities TOOLS_AND_ABILITIES;

    static {
        FOLIAATH = new Foliaath();
        BARAKOA = new Barakoa();
        NAGA = new Naga();
        LANTERN = new Lantern();
        GROTTOL = new Grottol();
        FERROUS_WROUGHTNAUT = new Ferrous_Wroughtnaut();
        BARAKO = new Barako();
        FROSTMAW = new Frostmaw();
        TOOLS_AND_ABILITIES = new ToolsAndAbilities();
    }

    public static class ToolsAndAbilities {
        @Config.Name(value="axe_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.axe_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float axeAttackMultiplier = 1.0f;
        @Config.Name(value="suns_blessing_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.suns_blessing_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float sunsBlessingAttackMultiplier = 1.0f;
        @Config.Name(value="spear_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.spear_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float spearAttackMultiplier = 1.0f;
        @Config.Name(value="blowgun_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.blowgun_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float blowgunAttackMultiplier = 1.0f;
        @Config.Name(value="geomancy_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.geomancy_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float geomancyAttackMultiplier = 1.0f;
        @Config.Name(value="ice_crystal_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.ice_crystal_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float iceCrystalAttackMultiplier = 1.0f;
        @Config.Name(value="naga_fang_dagger_attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.naga_fang_dagger_attack_multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public float nagaDaggerAttackMultiplier = 1.0f;
    }

    public static class Frostmaw {
        @Config.Name(value="generation_data")
        @Config.LangKey(value="config.mowziesmobs.generation_data")
        @Config.Comment(value={"Controls for spawning mob/structure with world generation"})
        public GenerationData generationData = new GenerationData(12, 0.8f, new BiomeData(new String[]{"SNOWY,!OCEAN,!RIVER,!BEACH"}, new String[0], new String[0]), 50.0f, 100.0f);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class Barako {
        @Config.Name(value="generation_data")
        @Config.LangKey(value="config.mowziesmobs.generation_data")
        @Config.Comment(value={"Controls for spawning mob/structure with world generation", "Generation controls for Barakoa villages"})
        public GenerationData generationData = new GenerationData(12, 0.8f, new BiomeData(new String[]{"SAVANNA"}, new String[0], new String[0]), 50.0f, 100.0f);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class Ferrous_Wroughtnaut {
        @Config.Name(value="ferrous_wroughtnaut")
        @Config.LangKey(value="config.mowziesmobs.ferrous_wroughtnaut")
        @Config.Comment(value={"Controls for spawning mob/structure with world generation"})
        public GenerationData generationData = new GenerationData(2, 0.5f, new BiomeData(new String[]{""}, new String[0], new String[0]), 30.0f, 55.0f);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class Grottol {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(2, 1, 1, new BiomeData(new String[]{""}, new String[0], new String[0]), new String[0], 55, -1, false, false, true);
        @Config.Name(value="health_multiplier")
        @Config.LangKey(value="config.mowziesmobs.health_multiplier")
        @Config.Comment(value={"Scale mob health by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public float healthMultiplier = 1.0f;
    }

    public static class Lantern {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(5, 1, 2, new BiomeData(new String[]{"FOREST,MAGICAL,!SNOWY"}, new String[]{"Roofed Forest", "Roofed Forest M"}, new String[0]), new String[]{"grass", "leaves", "leaves2", "log", "log2"}, -1, 60, true, false, false);
        @Config.Name(value="health_multiplier")
        @Config.LangKey(value="config.mowziesmobs.health_multiplier")
        @Config.Comment(value={"Scale mob health by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public float healthMultiplier = 1.0f;
    }

    public static class Naga {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(3, 1, 3, new BiomeData(new String[]{"BEACH,MOUNTAIN", "BEACH,HILLS"}, new String[]{"Stone Beach"}, new String[0]), new String[]{"grass", "stone", "sand"}, -1, -1, false, true, false);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class Barakoa {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning", "Controls spawning for Barakoana hunting groups", "Group size controls how many elites spawn, not followers", "See Barako config for village controls"})
        public SpawnData spawnData = new SpawnData(4, 1, 1, new BiomeData(new String[]{"SAVANNA"}, new String[0], new String[0]), new String[]{"grass", "stone", "sand"}, -1, 60, false, false, false);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class Foliaath {
        @Config.Name(value="spawn_data")
        @Config.LangKey(value="config.mowziesmobs.spawn_data")
        @Config.Comment(value={"Controls for vanilla-style mob spawning"})
        public SpawnData spawnData = new SpawnData(20, 1, 3, new BiomeData(new String[]{"JUNGLE"}, new String[0], new String[0]), new String[]{"grass", "leaves", "leaves2", "log", "log2"}, -1, 60, false, false, false);
        @Config.Name(value="combat_data")
        @Config.LangKey(value="config.mowziesmobs.combat_data")
        public CombatData combatData = new CombatData(1.0f, 1.0f);
    }

    public static class CombatData {
        @Config.Name(value="health_multiplier")
        @Config.LangKey(value="config.mowziesmobs.health_multiplier")
        @Config.Comment(value={"Scale mob health by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.RequiresWorldRestart
        public float healthMultiplier = 1.0f;
        @Config.Name(value="attack_multiplier")
        @Config.LangKey(value="config.mowziesmobs.attack_multiplier")
        @Config.Comment(value={"Scale mob attack damage by this value"})
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.RequiresWorldRestart
        public float attackMultiplier = 1.0f;

        CombatData(float healthMultiplier, float attackMultiplier) {
            this.healthMultiplier = healthMultiplier;
            this.attackMultiplier = attackMultiplier;
        }
    }

    public static class GenerationData {
        @Config.Name(value="generation_frequency")
        @Config.LangKey(value="config.mowziesmobs.generation_frequency")
        @Config.Comment(value={"Smaller number causes more generation, 0 to disable spawning", "Maximum number of chunks between placements of this mob/structure"})
        @Config.RangeInt(min=1, max=1000)
        public int generationFrequency = 15;
        @Config.Name(value="generation_chance")
        @Config.LangKey(value="config.mowziesmobs.generation_chance")
        @Config.Comment(value={"Probability that generation succeeds.", "For example, set to 0.5 to randomly not generate half of these structures in the world.", "Set to 1 to allow all generation attempts to succeed."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float generationChance = 1.0f;
        @Config.Name(value="biome_data")
        @Config.LangKey(value="config.mowziesmobs.biome_data")
        @Config.Comment(value={"Control which biomes this generation is allowed in"})
        @Config.RequiresMcRestart
        public BiomeData biomeData;
        @Config.Name(value="dimensions")
        @Config.LangKey(value="config.mowziesmobs.dimensions")
        @Config.Comment(value={"IDs of dimensions this mob/structure can generate in"})
        public int[] dimensions = new int[]{0};
        @Config.Name(value="height_min")
        @Config.LangKey(value="config.mowziesmobs.height_min")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Minimum height for generation placement. -1 to ignore"})
        public float heightMin = 0.0f;
        @Config.Name(value="height_max")
        @Config.LangKey(value="config.mowziesmobs.height_max")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Maximum height for generation placement. -1 to ignore"})
        public float heightMax = 255.0f;

        GenerationData(int generationFrequency, float generationChance, BiomeData biomeData, float heightMin, float heightMax) {
            this.generationFrequency = generationFrequency;
            this.generationChance = generationChance;
            this.biomeData = biomeData;
            this.heightMax = heightMax;
            this.heightMin = heightMin;
        }
    }

    public static class SpawnData {
        @Config.Name(value="spawn_rate")
        @Config.LangKey(value="config.mowziesmobs.spawn_rate")
        @Config.Comment(value={"Smaller number causes less spawning, 0 to disable spawning"})
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int spawnRate = 20;
        @Config.Name(value="min_group_size")
        @Config.LangKey(value="config.mowziesmobs.min_group_size")
        @Config.Comment(value={"Minimum number of mobs that appear in a spawn group"})
        @Config.RangeInt(min=1, max=100)
        @Config.RequiresMcRestart
        public int minGroupSize = 1;
        @Config.Name(value="max_group_size")
        @Config.LangKey(value="config.mowziesmobs.max_group_size")
        @Config.Comment(value={"Maximum number of mobs that appear in a spawn group"})
        @Config.RangeInt(min=1, max=100)
        @Config.RequiresMcRestart
        public int maxGroupSize = 3;
        @Config.Name(value="biome_data")
        @Config.LangKey(value="config.mowziesmobs.biome_data")
        @Config.Comment(value={"Control which biomes this spawn is allowed in"})
        @Config.RequiresMcRestart
        public BiomeData biomeData;
        @Config.Name(value="dimensions")
        @Config.LangKey(value="config.mowziesmobs.dimensions")
        @Config.Comment(value={"IDs of dimensions this mob can spawn in"})
        public int[] dimensions = new int[]{0};
        @Config.Name(value="height_min")
        @Config.LangKey(value="config.mowziesmobs.height_min")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Minimum height for this spawn. -1 to ignore."})
        public float heightMin = 0.0f;
        @Config.Name(value="height_max")
        @Config.LangKey(value="config.mowziesmobs.height_max")
        @Config.RangeDouble(min=-1.0, max=255.0)
        @Config.Comment(value={"Maximum height for this spawn. -1 to ignore."})
        public float heightMax = 255.0f;
        @Config.Name(value="needs_darkness")
        @Config.LangKey(value="config.mowziesmobs.needs_darkness")
        @Config.Comment(value={"Set to true to only allow this mob to spawn in the dark, like zombies and skeletons"})
        public boolean needsDarkness;
        @Config.Name(value="requires_see_sky")
        @Config.LangKey(value="config.mowziesmobs.requires_see_sky")
        @Config.Comment(value={"Set to true to only spawn mob if it can see the sky"})
        public boolean needsSeeSky;
        @Config.Name(value="requires_cant_see_sky")
        @Config.LangKey(value="config.mowziesmobs.requires_cant_see_sky")
        @Config.Comment(value={"Set to true to only spawn mob if it can't see the sky"})
        public boolean needsCantSeeSky;
        @Config.Name(value="allowed_blocks")
        @Config.LangKey(value="config.mowziesmobs.allowed_blocks")
        @Config.Comment(value={"Names of blocks this mob is allowed to spawn on. Leave blank to allow any block."})
        @Config.RequiresMcRestart
        public String[] allowedBlocks = new String[0];

        SpawnData(int spawnRate, int minGroupSize, int maxGroupSize, BiomeData biomeData, String[] allowedBlocks, int heightMax, int heightMin, boolean needsDarkness, boolean needsSeeSky, boolean needsCantSeeSky) {
            this.spawnRate = spawnRate;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.biomeData = biomeData;
            this.allowedBlocks = allowedBlocks;
            this.heightMax = heightMax;
            this.heightMin = heightMin;
            this.needsDarkness = needsDarkness;
            this.needsSeeSky = needsSeeSky;
            this.needsCantSeeSky = needsCantSeeSky;
        }
    }

    public static class BiomeData {
        @Config.Name(value="biome_type")
        @Config.LangKey(value="config.mowziesmobs.biome_type")
        @Config.Comment(value={"Each entry is a combination of allowed biome types.", "Separate types with commas to require biomes to have all types in an entry", "Put a '!' before a biome type to mean NOT that type", "A blank entry means all biomes. No entries means no biomes.", "For example, 'FOREST,MAGICAL,!SNOWY' would mean all biomes that are magical forests but not snowy", "'!MOUNTAIN' would mean all non-mountain biomes"})
        @Config.RequiresMcRestart
        public String[] biomeTypes = new String[0];
        @Config.Name(value="biome_whitelist")
        @Config.LangKey(value="config.mowziesmobs.biome_whitelist")
        @Config.Comment(value={"Allow spawns in these biomes regardless of the biome type settings"})
        @Config.RequiresMcRestart
        public String[] biomeWhitelist = new String[0];
        @Config.Name(value="biome_blacklist")
        @Config.LangKey(value="config.mowziesmobs.biome_blacklist")
        @Config.Comment(value={"Prevent spawns in these biomes regardless of the biome type settings"})
        @Config.RequiresMcRestart
        public String[] biomeBlacklist = new String[0];

        BiomeData(String[] biomeTypes, String[] biomeWhitelist, String[] biomeBlacklist) {
            this.biomeTypes = biomeTypes;
            this.biomeWhitelist = biomeWhitelist;
            this.biomeBlacklist = biomeBlacklist;
        }
    }
}

